/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class JarFileUtils {
    public static final Pattern DEPLOYED_FILE_PATTERN = Pattern.compile("(?<baseName>..*)\\.v(?<version>\\d++).jar$");
    private static final Pattern USER_VERSION_PATTERN = Pattern.compile("(?<artifact>.*?)[-.]\\d+.*.*?\\.jar$");

    public static String getArtifactId(String deployedJarFileName) {
        Matcher semanticVersionMatcher = USER_VERSION_PATTERN.matcher(deployedJarFileName);
        if (semanticVersionMatcher.matches()) {
            return semanticVersionMatcher.group("artifact");
        }
        return FilenameUtils.getBaseName((String)deployedJarFileName);
    }

    public static boolean isSemanticVersion(String filename) {
        return USER_VERSION_PATTERN.matcher(filename).find();
    }

    public static boolean hasValidJarContent(File jarFile) {
        boolean valid = false;
        try (FileInputStream fileInputStream = new FileInputStream(jarFile);
             JarInputStream jarInputStream = new JarInputStream(fileInputStream);){
            valid = jarInputStream.getNextJarEntry() != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return valid;
    }

    public static boolean isDeployedFile(String filename) {
        return DEPLOYED_FILE_PATTERN.matcher(filename).find();
    }

    public static int extractVersionFromFilename(String filename) {
        Matcher matcher = DEPLOYED_FILE_PATTERN.matcher(filename);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(2));
        }
        return 0;
    }

    public static String getDeployedFileBaseName(String sequencedJarFileName) {
        Matcher semanticVersionMatcher = DEPLOYED_FILE_PATTERN.matcher(sequencedJarFileName);
        if (semanticVersionMatcher.matches()) {
            return semanticVersionMatcher.group("baseName");
        }
        return null;
    }

    public static String toArtifactId(String sequencedJarFileName) {
        String baseName = JarFileUtils.getDeployedFileBaseName(sequencedJarFileName);
        if (baseName == null) {
            return null;
        }
        return JarFileUtils.getArtifactId(baseName + ".jar");
    }
}

