/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.util.EncodingInputStream;
import com.healthmarketscience.rmiio.util.InputStreamAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPRemoteInputStream
extends RemoteInputStreamServer {
    private static final long serialVersionUID = 20080212L;
    private final transient GZIPEncodingInputStream _packetIStream;
    private transient GZIPOutputStream _gzipOStream;
    private final transient InputStreamAdapter _inAdapter;

    public GZIPRemoteInputStream(InputStream in) throws IOException {
        this(in, DUMMY_MONITOR, 7168);
    }

    public GZIPRemoteInputStream(InputStream in, RemoteStreamMonitor<RemoteInputStreamServer> monitor) throws IOException {
        this(in, monitor, 7168);
    }

    public GZIPRemoteInputStream(InputStream in, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize) throws IOException {
        super(in, monitor, chunkSize);
        this._packetIStream = new GZIPEncodingInputStream(this._chunkSize);
        this._inAdapter = InputStreamAdapter.create(in, this._chunkSize);
    }

    @Override
    public boolean usingGZIPCompression() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int availableImpl() throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            return this._packetIStream.available();
        }
    }

    @Override
    protected void closeImpl(boolean readSuccess) throws IOException {
        super.closeImpl(readSuccess);
    }

    @Override
    protected byte[] readPacket() throws IOException {
        return this._packetIStream.readPacket();
    }

    @Override
    protected long skip(long n) throws IOException {
        throw new IOException("Should not be called on compressed stream");
    }

    private class GZIPEncodingInputStream
    extends EncodingInputStream {
        private GZIPEncodingInputStream(int chunkSize) {
            super(chunkSize);
        }

        protected void encode(int suggestedLength) throws IOException {
            int numRead;
            if (GZIPRemoteInputStream.this._gzipOStream == null) {
                GZIPRemoteInputStream.this._gzipOStream = new GZIPOutputStream((OutputStream)this.createOutputStream(), GZIPRemoteInputStream.this._chunkSize);
            }
            if ((numRead = GZIPRemoteInputStream.this._inAdapter.readTemp()) > 0) {
                GZIPRemoteInputStream.this._monitor.localBytesMoved(GZIPRemoteInputStream.this, numRead);
                GZIPRemoteInputStream.this._gzipOStream.write(GZIPRemoteInputStream.this._inAdapter.getTempBuffer(), 0, numRead);
            } else if (GZIPRemoteInputStream.this._gzipOStream != null) {
                GZIPRemoteInputStream.this._gzipOStream.close();
            }
        }
    }
}

