/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.cache.query.internal.HashingStrategy;

public class ObjectIntHashMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7718697444988416372L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    final HashingStrategy hashingStrategy;
    private transient Set<Entry> entrySet = null;
    private transient Set<Object> keySet = null;

    public ObjectIntHashMap(int initialCapacity, float loadFactor, HashingStrategy hs) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.hashingStrategy = hs == null ? new IntHashMapStrategy() : hs;
        this.init();
    }

    public ObjectIntHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, null);
    }

    public ObjectIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, null);
    }

    public ObjectIntHashMap(int initialCapacity, HashingStrategy hs) {
        this(initialCapacity, 0.75f, hs);
    }

    public ObjectIntHashMap() {
        this(null);
    }

    public ObjectIntHashMap(HashingStrategy hs) {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.hashingStrategy = hs == null ? new IntHashMapStrategy() : hs;
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(Object key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key));
        Entry e = this.table[ObjectIntHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || this.hashingStrategy.equals(k, key))) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    private int getForNullKey() {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry getEntry(Object key) {
        int hash = key == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key));
        Entry e = this.table[ObjectIntHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && this.hashingStrategy.equals(k, key))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public int put(Object key, int value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || this.hashingStrategy.equals(k, key))) {
                int oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return 0;
    }

    private int putForNullKey(int value) {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                int oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return 0;
    }

    private void putForCreate(Object key, int value) {
        int hash = key == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && this.hashingStrategy.equals(k, key))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(ObjectIntHashMap m) {
        for (Entry e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = ObjectIntHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    public void putAll(ObjectIntHashMap m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Entry e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public int remove(Object key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? 0 : e.value;
    }

    Entry removeEntryForKey(Object key) {
        Entry prev;
        int hash = key == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Object k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && this.hashingStrategy.equals(k, key))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Entry)) {
            return null;
        }
        Entry entry = (Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(int value) {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        ObjectIntHashMap result = null;
        try {
            result = (ObjectIntHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectIntHashMap)) {
            return false;
        }
        ObjectIntHashMap m = (ObjectIntHashMap)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Entry e : this.entrySet()) {
                Object key = e.getKey();
                int value = e.getValue();
                if (!m.containsKey(key)) {
                    return false;
                }
                if (value == m.get(key)) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        Iterator<Entry> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        Iterator<Entry> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Entry e = i.next();
            Object key = e.getKey();
            int value = e.getValue();
            sb.append(key == this ? "(this Map)" : key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    void addEntry(int hash, Object key, int value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key, int value, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key, value, e);
        ++this.size;
    }

    Iterator<Object> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Entry> newEntryIterator() {
        return new EntryIterator();
    }

    public Set<Object> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Set<Entry> entrySet() {
        return this.entrySet0();
    }

    private Set<Entry> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<Entry> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                Entry e = i.next();
                s.writeObject(e.getKey());
                s.writeInt(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            int value = s.readInt();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class IntHashMapStrategy
    implements HashingStrategy {
        private IntHashMapStrategy() {
        }

        @Override
        public int hashCode(Object o) {
            return o.hashCode();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }
    }

    private class EntrySet
    extends AbstractSet<Entry> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry> iterator() {
            return ObjectIntHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = ObjectIntHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return ObjectIntHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return ObjectIntHashMap.this.size;
        }

        @Override
        public void clear() {
            ObjectIntHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<Object> {
        private KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return ObjectIntHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return ObjectIntHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ObjectIntHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ObjectIntHashMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            ObjectIntHashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator<Entry> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator<Object> {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = ObjectIntHashMap.this.modCount;
            if (ObjectIntHashMap.this.size > 0) {
                Entry[] t = ObjectIntHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (ObjectIntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = ObjectIntHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (ObjectIntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            ObjectIntHashMap.this.removeEntryForKey(k);
            this.expectedModCount = ObjectIntHashMap.this.modCount;
        }
    }

    class Entry {
        final Object key;
        int value;
        Entry next;
        final int hash;

        Entry(int h, Object k, int v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public Object getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public int setValue(int newValue) {
            int oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            int v2;
            int v1;
            Object k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && ObjectIntHashMap.this.hashingStrategy.equals(k1, k2)) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        public int hashCode() {
            return this.hash ^ this.value;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(ObjectIntHashMap m) {
        }

        void recordRemoval(ObjectIntHashMap m) {
        }
    }
}

