/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.AbstractRegionMap;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.EvictableRegion;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PlaceHolderDiskRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.RegionMap;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.eviction.AbstractEvictionController;
import org.apache.geode.internal.cache.eviction.CachedDeserializableValueWrapper;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.cache.eviction.EvictionList;
import org.apache.geode.internal.cache.eviction.EvictionListBuilder;
import org.apache.geode.internal.cache.eviction.HeapEvictor;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class VMLRURegionMap
extends AbstractRegionMap {
    private static final Logger logger = LogService.getLogger();
    private final EvictionController evictionController;
    private final EvictionList lruList;
    private final ThreadLocal lruDelta = new ThreadLocal();
    private final ThreadLocal mustRemove = new ThreadLocal();
    private final ThreadLocal callbackDisabled = new ThreadLocal();

    public VMLRURegionMap(EvictableRegion owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs) {
        this(owner, attr, internalRegionArgs, VMLRURegionMap.createEvictionController(owner, internalRegionArgs));
    }

    public VMLRURegionMap(EvictableRegion owner, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs, EvictionController evictionController) {
        super(internalRegionArgs);
        this.initialize(owner, attr, internalRegionArgs);
        this.evictionController = evictionController;
        this.getEvictionController().setPerEntryOverhead(this.getEntryOverhead());
        this.lruList = new EvictionListBuilder(this.getEvictionController()).create();
    }

    public EvictionList getEvictionList() {
        return this.lruList;
    }

    @Override
    public EvictionController getEvictionController() {
        return this.evictionController;
    }

    protected void initialize(EvictableRegion evictableRegion, RegionMap.Attributes attr, InternalRegionArguments internalRegionArgs) {
        if (evictableRegion instanceof InternalRegion) {
            this.initialize((InternalRegion)((Object)evictableRegion), attr, internalRegionArgs, true);
        } else {
            this.initialize((PlaceHolderDiskRegion)evictableRegion, attr, internalRegionArgs, true);
        }
    }

    @Override
    public void setEntryFactory(RegionEntryFactory f) {
        super.setEntryFactory(f);
        if (this.getEvictionController() != null) {
            this.getEvictionController().setPerEntryOverhead(this.getEntryOverhead());
        }
    }

    private static EvictionController createEvictionController(EvictableRegion owner, InternalRegionArguments internalRegionArgs) {
        EvictionController controller = owner.getExistingController(internalRegionArgs);
        if (controller == null) {
            controller = AbstractEvictionController.create(owner.getEvictionAttributes(), owner.getOffHeap(), owner.getStatisticsFactory(), owner.getNameForStats());
        }
        return controller;
    }

    private int getDelta() {
        Object d = this.lruDelta.get();
        this.lruDelta.set(null);
        if (d == null) {
            return 0;
        }
        return (Integer)d;
    }

    private void setDelta(int delta) {
        Integer delt;
        if (!this.getCallbackDisabled()) {
            if (this.getMustRemove()) {
                this.lruUpdateCallback();
            }
            this.setMustRemove(true);
        }
        if ((delt = (Integer)this.lruDelta.get()) != null) {
            delta += delt.intValue();
        }
        this.lruDelta.set(delta);
    }

    @Override
    public boolean beginChangeValueForm(EvictableEntry le, CachedDeserializable cd, Object v) {
        if (this.getEvictionController().getEvictionAlgorithm().isLRUEntry()) {
            return false;
        }
        Object curVal = le.getValue();
        if (curVal != cd) {
            if (cd instanceof StoredObject) {
                if (!cd.equals(curVal)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        boolean result = false;
        int delta = le.updateEntrySize(this.getEvictionController(), new CachedDeserializableValueWrapper(v));
        if (delta != 0) {
            result = true;
            boolean disabledLURCallbacks = this.disableLruUpdateCallback();
            this.setDelta(delta);
            if (disabledLURCallbacks) {
                this.enableLruUpdateCallback();
            }
        }
        if (this.getEvictionController().getEvictionAlgorithm().isLRUHeap() && this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion && HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST) {
            result = false;
        }
        return result;
    }

    @Override
    public void finishChangeValueForm() {
        this.lruUpdateCallback();
    }

    private boolean getMustRemove() {
        Object d = this.mustRemove.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setMustRemove(boolean b) {
        this.mustRemove.set(b ? Boolean.TRUE : null);
    }

    private boolean getCallbackDisabled() {
        Object d = this.callbackDisabled.get();
        if (d == null) {
            return false;
        }
        return (Boolean)d;
    }

    private void setCallbackDisabled(boolean b) {
        this.callbackDisabled.set(b ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int evictEntry(EvictableEntry entry, EvictionCounters stats) throws RegionClearedException {
        EvictionAction action = this.getEvictionController().getEvictionAction();
        LocalRegion region = this._getOwner();
        if (action.isLocalDestroy()) {
            int size = entry.getEntrySize();
            if (region.evictDestroy(entry)) {
                stats.incDestroys();
                return size;
            }
            return 0;
        }
        if (action.isOverflowToDisk()) {
            boolean result;
            Assert.assertTrue(entry instanceof DiskEntry);
            int change = 0;
            EvictableEntry evictableEntry = entry;
            synchronized (evictableEntry) {
                if (entry.isInUseByTransaction()) {
                    entry.unsetEvicted();
                    if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
                        logger.trace(LogMarker.LRU_VERBOSE, "No eviction of transactional entry for key={}", entry.getKey());
                    }
                    return 0;
                }
                Token entryVal = entry.getValueAsToken();
                if (entryVal == null) {
                    if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
                        logger.trace(LogMarker.LRU_VERBOSE, "no need to evict already evicted key={}", entry.getKey());
                    }
                    return 0;
                }
                if (Token.isInvalidOrRemoved(entryVal)) {
                    if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
                        logger.trace(LogMarker.LRU_VERBOSE, "no need to evict {} token for key={}", (Object)entryVal, entry.getKey());
                    }
                    return 0;
                }
                entry.setEvicted();
                change = DiskEntry.Helper.overflowToDisk((DiskEntry)((Object)entry), region, this.getEvictionController());
            }
            boolean bl = result = change < 0;
            if (result) {
                if (this._getOwner() instanceof BucketRegion) {
                    BucketRegion bucketRegion = (BucketRegion)this._getOwner();
                    bucketRegion.updateCounter(change);
                    stats.updateCounter(change);
                } else {
                    stats.updateCounter(change);
                }
            } else if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
                logger.trace(LogMarker.LRU_VERBOSE, "no need to evict token for key={} because moving its value to disk resulted in a net change of {} bytes.", entry.getKey(), (Object)change);
            }
            return change * -1;
        }
        throw new InternalGemFireException(String.format("Unknown eviction action: %s", action));
    }

    protected void changeTotalEntrySize(int delta) {
        if (this._isOwnerALocalRegion() && this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            bucketRegion.updateCounter(delta);
        }
        this.getEvictionList().getStatistics().updateCounter(delta);
        if (delta > 0 && logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
            logger.trace(LogMarker.LRU_VERBOSE, "total lru size is now: {}", (Object)this.getTotalEntrySize());
        }
    }

    @Override
    public void evictValue(Object key) {
        throw new IllegalStateException("The evictValue is not supported on regions with eviction attributes.");
    }

    protected long getLimit() {
        if (this._getOwner() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getLimit();
        }
        return this.getEvictionController().getCounters().getLimit();
    }

    public EvictionCounters getLRUStatistics() {
        return this.getEvictionController().getCounters();
    }

    protected long getTotalEntrySize() {
        if (this._getOwnerObject() instanceof BucketRegion) {
            BucketRegion bucketRegion = (BucketRegion)this._getOwner();
            return bucketRegion.getCounter();
        }
        return this.getEvictionController().getCounters().getCounter();
    }

    @Override
    public void lruUpdateCallback() {
        boolean isDebugEnabled_LRU;
        block28: {
            int delta;
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU_VERBOSE);
            if (this.getCallbackDisabled()) {
                return;
            }
            int bytesToEvict = delta = this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU && this._isOwnerALocalRegion()) {
                logger.trace(LogMarker.LRU_VERBOSE, "lruUpdateCallback; list size is: {}; actual size is: {}; map size is: {}; delta is: {}; limit is: {}; tombstone count={}", (Object)this.getTotalEntrySize(), (Object)this.getEvictionList().size(), (Object)this.size(), (Object)delta, (Object)this.getLimit(), (Object)this._getOwner().getTombstoneCount());
            }
            EvictionCounters stats = this.getEvictionList().getStatistics();
            if (!this._isOwnerALocalRegion()) {
                this.changeTotalEntrySize(delta);
            } else {
                if (this.getEvictionController().getEvictionAlgorithm().isLRUHeap()) {
                    this.changeTotalEntrySize(delta);
                    try {
                        while (bytesToEvict > 0 && this.getEvictionController().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                            boolean evictFromThisRegion = true;
                            if (HeapEvictor.EVICT_HIGH_ENTRY_COUNT_BUCKETS_FIRST && this._getOwner() instanceof BucketRegion) {
                                long bytesEvicted = 0L;
                                long totalBytesEvicted = 0L;
                                List<BucketRegion> regions = ((BucketRegion)this._getOwner()).getPartitionedRegion().getSortedBuckets();
                                Iterator<BucketRegion> iter = regions.iterator();
                                while (iter.hasNext()) {
                                    BucketRegion region = iter.next();
                                    if (region.getBucketAdvisor().isPrimary()) continue;
                                    try {
                                        bytesEvicted = region.getRegionMap().centralizedLruUpdateCallback();
                                        if (bytesEvicted == 0L) {
                                            iter.remove();
                                        } else {
                                            evictFromThisRegion = false;
                                        }
                                        totalBytesEvicted += bytesEvicted;
                                        bytesToEvict = (int)((long)bytesToEvict - bytesEvicted);
                                        if (bytesEvicted > (long)bytesToEvict) {
                                            bytesToEvict = 0;
                                            break;
                                        }
                                        if (totalBytesEvicted <= (long)bytesToEvict) continue;
                                        break;
                                    }
                                    catch (RegionDestroyedException rd) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(rd);
                                    }
                                    catch (Exception e) {
                                        region.cache.getCancelCriterion().checkCancelInProgress(e);
                                        logger.warn(String.format("Exception: %s occurred during eviction ", e.getMessage()), (Throwable)e);
                                    }
                                }
                            }
                            if (!evictFromThisRegion) continue;
                            EvictableEntry removalEntry = this.getEvictionList().getEvictableEntry();
                            if (removalEntry != null) {
                                int sizeOfValue = this.evictEntry(removalEntry, stats);
                                if (sizeOfValue == 0) continue;
                                bytesToEvict -= sizeOfValue;
                                if (isDebugEnabled_LRU) {
                                    logger.trace(LogMarker.LRU_VERBOSE, "evicted entry key={} total entry size is now: {} bytesToEvict :{}", removalEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)bytesToEvict);
                                }
                                stats.incEvictions();
                                if (this._isOwnerALocalRegion()) {
                                    this._getOwner().incBucketEvictions();
                                }
                                if (!isDebugEnabled_LRU) continue;
                                logger.trace(LogMarker.LRU_VERBOSE, "evictions={}", (Object)stats.getEvictions());
                                continue;
                            }
                            if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU_VERBOSE, "leaving evict loop early");
                            }
                            break block28;
                        }
                        break block28;
                    }
                    catch (RegionClearedException e) {
                        if (isDebugEnabled_LRU) {
                            logger.trace(LogMarker.LRU_VERBOSE, "exception ={}", (Object)e.getCause().getMessage(), (Object)e.getCause());
                        }
                        break block28;
                    }
                }
                try {
                    while (bytesToEvict > 0 && this.getEvictionController().mustEvict(stats, this._getOwner(), bytesToEvict)) {
                        EvictableEntry removalEntry = this.getEvictionList().getEvictableEntry();
                        if (removalEntry != null) {
                            if (this.evictEntry(removalEntry, stats) == 0) continue;
                            if (isDebugEnabled_LRU) {
                                logger.trace(LogMarker.LRU_VERBOSE, "evicted entry key(2)={} total entry size is now: {} bytesToEvict: {}", removalEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)bytesToEvict);
                            }
                            stats.incEvictions();
                            if (this._isOwnerALocalRegion()) {
                                this._getOwner().incBucketEvictions();
                            }
                            if (!isDebugEnabled_LRU) continue;
                            logger.trace(LogMarker.LRU_VERBOSE, "evictions={}", (Object)stats.getEvictions());
                            continue;
                        }
                        if (this.getTotalEntrySize() == 0L || !isDebugEnabled_LRU) break;
                        logger.trace(LogMarker.LRU_VERBOSE, "leaving evict loop early");
                        break;
                    }
                    this.changeTotalEntrySize(delta);
                }
                catch (RegionClearedException e) {
                    if (!isDebugEnabled_LRU) break block28;
                    logger.debug("exception ={}", (Object)e.getCause().getMessage(), (Object)e.getCause());
                }
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU_VERBOSE, "callback complete.  LRU size is now {}", (Object)this.getEvictionController().getCounters().getCounter());
        }
    }

    private boolean mustEvict() {
        boolean offheap;
        LocalRegion owner = this._getOwner();
        InternalResourceManager resourceManager = owner.getCache().getInternalResourceManager();
        return resourceManager.getMemoryMonitor(offheap = owner.getAttributes().getOffHeap()).getState().isEviction() && this.sizeInVM() > 0;
    }

    @Override
    public int centralizedLruUpdateCallback() {
        int evictedBytes;
        boolean isDebugEnabled_LRU;
        block8: {
            isDebugEnabled_LRU = logger.isTraceEnabled(LogMarker.LRU_VERBOSE);
            evictedBytes = 0;
            if (this.getCallbackDisabled()) {
                return evictedBytes;
            }
            this.getDelta();
            this.resetThreadLocals();
            if (isDebugEnabled_LRU) {
                logger.trace(LogMarker.LRU_VERBOSE, "centralLruUpdateCallback: lru size is now {}, limit is: {}", (Object)this.getTotalEntrySize(), (Object)this.getLimit());
            }
            EvictionCounters stats = this.getEvictionList().getStatistics();
            try {
                while (this.mustEvict() && evictedBytes == 0) {
                    EvictableEntry removalEntry = this.getEvictionList().getEvictableEntry();
                    if (removalEntry != null) {
                        evictedBytes = this.evictEntry(removalEntry, stats);
                        if (evictedBytes == 0) continue;
                        this._getOwner().incBucketEvictions();
                        stats.incEvictions();
                        if (!isDebugEnabled_LRU) continue;
                        logger.debug("evictions={}", (Object)stats.getEvictions());
                        continue;
                    }
                    if (this.getTotalEntrySize() != 0L && isDebugEnabled_LRU) {
                        logger.trace(LogMarker.LRU_VERBOSE, "leaving evict loop early");
                    }
                    break;
                }
            }
            catch (RegionClearedException e) {
                if (!isDebugEnabled_LRU) break block8;
                logger.trace(LogMarker.LRU_VERBOSE, "exception ={}", (Object)e.getCause().getMessage(), (Object)e.getCause());
            }
        }
        if (isDebugEnabled_LRU) {
            logger.trace(LogMarker.LRU_VERBOSE, "callback complete");
        }
        return evictedBytes;
    }

    @Override
    public void updateEvictionCounter() {
        int delta = this.getDelta();
        this.resetThreadLocals();
        if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
            logger.trace(LogMarker.LRU_VERBOSE, "updateStats - delta is: {} total is: {} limit is: {}", (Object)delta, (Object)this.getTotalEntrySize(), (Object)this.getLimit());
        }
        if (delta != 0) {
            this.changeTotalEntrySize(delta);
        }
    }

    @Override
    public boolean disableLruUpdateCallback() {
        if (this.getCallbackDisabled()) {
            return false;
        }
        this.setCallbackDisabled(true);
        return true;
    }

    @Override
    public void enableLruUpdateCallback() {
        this.setCallbackDisabled(false);
    }

    @Override
    public void resetThreadLocals() {
        this.mustRemove.set(null);
        this.lruDelta.set(null);
        this.callbackDisabled.set(null);
    }

    @Override
    public Set<VersionSource> clear(RegionVersionVector rvv, BucketRegion bucketRegion) {
        this.getEvictionList().clear(rvv, bucketRegion);
        return super.clear(rvv, bucketRegion);
    }

    @Override
    public void lruEntryCreate(RegionEntry re) {
        boolean possibleClear;
        EvictableEntry e = (EvictableEntry)re;
        if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
            logger.trace(LogMarker.LRU_VERBOSE, "lruEntryCreate for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", re.getKey(), (Object)this.getTotalEntrySize(), (Object)this.getEvictionList().size(), (Object)this.size(), (Object)e.getEntrySize(), (Object)(!e.isEvicted() ? 1 : 0));
        }
        e.unsetEvicted();
        EvictionList lruList = this.getEvictionList();
        DiskRegion disk = this._getOwner().getDiskRegion();
        boolean bl = possibleClear = disk != null && disk.didClearCountChange();
        if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
            lruList.appendEntry(e);
            this.lruEntryUpdate(e);
        }
    }

    @Override
    public void lruEntryUpdate(RegionEntry re) {
        EvictableEntry e = (EvictableEntry)re;
        this.setDelta(e.updateEntrySize(this.getEvictionController()));
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryUpdate for key={} size={}", re.getKey(), (Object)e.getEntrySize());
        }
        EvictionList lruList = this.getEvictionList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(re.getKey()) == re) {
                if (e instanceof DiskEntry && !e.isEvicted()) {
                    lruList.appendEntry(e);
                }
                e.resetRefCount(lruList);
            }
        } else if (!e.isEvicted()) {
            lruList.appendEntry(e);
        }
    }

    @Override
    public void lruEntryDestroy(RegionEntry regionEntry) {
        EvictableEntry e = (EvictableEntry)regionEntry;
        if (logger.isTraceEnabled(LogMarker.LRU_VERBOSE)) {
            logger.trace(LogMarker.LRU_VERBOSE, "lruEntryDestroy for key={}; list size is: {}; actual size is: {}; map size is: {}; entry size: {}; in lru clock: {}", regionEntry.getKey(), (Object)this.getTotalEntrySize(), (Object)this.getEvictionList().size(), (Object)this.size(), (Object)e.getEntrySize(), (Object)(!e.isEvicted() ? 1 : 0));
        }
        this.getEvictionList().destroyEntry(e);
        this.changeTotalEntrySize(-1 * e.getEntrySize());
        Token vTok = regionEntry.getValueAsToken();
        if (vTok == Token.DESTROYED || vTok == Token.TOMBSTONE) {
            e.updateEntrySize(this.getEvictionController());
        }
    }

    @Override
    public void lruEntryFaultIn(EvictableEntry e) {
        if (logger.isDebugEnabled()) {
            logger.debug("lruEntryFaultIn for key={} size={}", e.getKey(), (Object)e.getEntrySize());
        }
        EvictionList lruList = this.getEvictionList();
        if (this._isOwnerALocalRegion()) {
            boolean possibleClear;
            DiskRegion disk = this._getOwner().getDiskRegion();
            boolean bl = possibleClear = disk != null && disk.didClearCountChange();
            if (!possibleClear || this._getOwner().basicGetEntry(e.getKey()) == e) {
                this.lruEntryUpdate(e);
                e.unsetEvicted();
                lruList.appendEntry(e);
            }
        } else {
            this.lruEntryUpdate(e);
            lruList.appendEntry(e);
        }
    }

    @Override
    public void decTxRefCount(RegionEntry re) {
        LocalRegion lr = null;
        if (this._isOwnerALocalRegion()) {
            lr = this._getOwner();
        }
        re.decRefCount(this.getEvictionList(), lr);
    }

    @Override
    public boolean lruLimitExceeded(DiskRegionView diskRegionView) {
        return this.getEvictionController().lruLimitExceeded(this.getEvictionController().getCounters(), diskRegionView);
    }

    @Override
    public void lruCloseStats() {
        this.getEvictionList().closeStats();
    }

    @Override
    public boolean confirmEvictionDestroy(RegionEntry regionEntry) {
        EvictableEntry lruRe = (EvictableEntry)regionEntry;
        if (lruRe.isInUseByTransaction() || lruRe.isDestroyed()) {
            lruRe.unsetEvicted();
            return false;
        }
        return true;
    }

    @Override
    public long getEvictions() {
        return this.getEvictionController().getCounters().getEvictions();
    }

    @Override
    public void incRecentlyUsed() {
        this.getEvictionList().incrementRecentlyUsed();
    }
}

