/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.event;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.event.BulkOperationHolder;
import org.apache.geode.internal.cache.event.EventSequenceNumberHolder;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.versions.VersionTag;

public interface EventTracker {
    public void start();

    public void stop();

    public Map<ThreadIdentifier, EventSequenceNumberHolder> getState();

    public void recordState(InternalDistributedMember var1, Map<ThreadIdentifier, EventSequenceNumberHolder> var2);

    public void setInitialized();

    public void waitOnInitialization() throws InterruptedException;

    public void recordEvent(InternalCacheEvent var1);

    public boolean hasSeenEvent(InternalCacheEvent var1);

    public boolean hasSeenEvent(EventID var1);

    public boolean hasSeenEvent(EventID var1, InternalCacheEvent var2);

    public VersionTag findVersionTagForSequence(EventID var1);

    public VersionTag findVersionTagForBulkOp(EventID var1);

    public String getName();

    public ConcurrentMap<ThreadIdentifier, BulkOperationHolder> getRecordedBulkOpVersionTags();

    public ConcurrentMap<ThreadIdentifier, EventSequenceNumberHolder> getRecordedEvents();

    public void syncBulkOp(Runnable var1, EventID var2, boolean var3);

    public void recordBulkOpStart(EventID var1, ThreadIdentifier var2);

    public boolean isInitialized();

    public boolean isInitialImageProvider(DistributedMember var1);

    public void clear();
}

