/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.versions;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.versions.RVVException;
import org.apache.geode.internal.cache.versions.RVVExceptionB;

public class RVVExceptionT
extends RVVException {
    TreeSet<Long> received;

    RVVExceptionT(long previousVersion, long nextVersion) {
        super(previousVersion, nextVersion);
    }

    @Override
    public void add(long receivedVersion) {
        if (receivedVersion == this.previousVersion + 1L) {
            this.previousVersion = receivedVersion;
            if (this.received != null) {
                this.consumeReceivedVersions();
            }
        } else if (receivedVersion == this.nextVersion - 1L) {
            this.nextVersion = receivedVersion;
            if (this.received != null) {
                this.consumeReceivedVersions();
            }
        } else if (this.previousVersion < receivedVersion && receivedVersion < this.nextVersion) {
            this.addReceived(receivedVersion);
        }
    }

    @Override
    protected void addReceived(long rv) {
        if (this.received == null) {
            this.received = new TreeSet();
        }
        this.received.add(rv);
    }

    private void consumeReceivedVersions() {
        long v;
        Iterator<Long> it = this.received.iterator();
        while (it.hasNext() && (v = it.next().longValue()) <= this.previousVersion + 1L) {
            it.remove();
            if (v != this.previousVersion + 1L) continue;
            this.previousVersion = v;
        }
        it = this.received.descendingIterator();
        while (it.hasNext() && (v = it.next().longValue()) >= this.nextVersion - 1L) {
            it.remove();
            if (v != this.nextVersion - 1L) continue;
            this.nextVersion = v;
        }
    }

    @Override
    public RVVException clone() {
        RVVExceptionT clone = new RVVExceptionT(this.previousVersion, this.nextVersion);
        if (this.received != null) {
            clone.received = new TreeSet<Long>((SortedSet<Long>)this.received);
        }
        return clone;
    }

    @Override
    public void writeReceived(DataOutput out) throws IOException {
        int size = this.received == null ? 0 : this.received.size();
        InternalDataSerializer.writeUnsignedVL(size, out);
        long last = this.previousVersion;
        if (this.received != null) {
            for (Long version : this.received) {
                long delta = version - last;
                InternalDataSerializer.writeUnsignedVL(delta, out);
                last = version;
            }
        }
        long delta = this.nextVersion - last;
        InternalDataSerializer.writeUnsignedVL(delta, out);
    }

    public String toString() {
        if (this.received != null) {
            return "e(n=" + this.nextVersion + " p=" + this.previousVersion + (this.received.size() == 0 ? "" : "; rs=" + this.received) + ")";
        }
        return "et(n=" + this.nextVersion + " p=" + this.previousVersion + "; rs=[])";
    }

    @Override
    public boolean sameAs(RVVException ex) {
        if (!super.sameAs(ex)) {
            return false;
        }
        RVVExceptionT other = (RVVExceptionT)ex;
        return !(this.received == null ? other.received != null && !other.received.isEmpty() : other.received == null || !this.received.equals(other.received));
    }

    protected boolean sameAs(RVVExceptionB ex) {
        if (!super.sameAs(ex)) {
            return false;
        }
        RVVException.ReceivedVersionsReverseIterator it = this.receivedVersionsReverseIterator();
        while (it.hasNext()) {
            if (ex.contains(it.next())) continue;
            return false;
        }
        it = ex.receivedVersionsReverseIterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(long version) {
        if (version <= this.previousVersion) {
            return false;
        }
        return this.received != null && this.received.contains(version);
    }

    @Override
    public boolean isEmpty() {
        return this.received == null || this.received.isEmpty();
    }

    @Override
    public RVVException.ReceivedVersionsReverseIterator receivedVersionsReverseIterator() {
        return new ReceivedVersionsReverseIteratorT();
    }

    @Override
    public long getHighestReceivedVersion() {
        if (this.received == null || this.received.isEmpty()) {
            return this.previousVersion;
        }
        return this.received.last();
    }

    @Override
    public boolean shouldChangeForm() {
        return this.received != null && (long)(this.received.size() * 512) > this.nextVersion - this.previousVersion;
    }

    @Override
    public RVVException changeForm() {
        RVVExceptionB ex = new RVVExceptionB(this.previousVersion, this.nextVersion);
        RVVException.ReceivedVersionsReverseIterator it = this.receivedVersionsReverseIterator();
        while (it.hasNext()) {
            long next = it.next();
            ex.add(next);
        }
        return ex;
    }

    protected class ReceivedVersionsReverseIteratorT
    extends RVVException.ReceivedVersionsReverseIterator {
        boolean noIterator;
        Iterator<Long> treeSetIterator;

        ReceivedVersionsReverseIteratorT() {
            if (RVVExceptionT.this.received == null) {
                this.noIterator = true;
            } else {
                this.treeSetIterator = RVVExceptionT.this.received.descendingIterator();
            }
        }

        @Override
        boolean hasNext() {
            return !this.noIterator && this.treeSetIterator.hasNext();
        }

        @Override
        long next() {
            if (!this.noIterator) {
                return this.treeSetIterator.next();
            }
            throw new NoSuchElementException("no more elements");
        }

        @Override
        void remove() {
            if (!this.noIterator) {
                this.treeSetIterator.remove();
            }
        }
    }
}

