/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.util.concurrent.CountDownLatch;

public class DelayedAction
implements Runnable {
    private final CountDownLatch hit = new CountDownLatch(1);
    private final CountDownLatch run = new CountDownLatch(1);
    private final Runnable delayedAction;

    public DelayedAction(Runnable action) {
        this.delayedAction = action;
    }

    @Override
    public void run() {
        this.hit.countDown();
        try {
            this.run.await();
            if (this.delayedAction != null) {
                this.delayedAction.run();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void waitForArrival() throws InterruptedException {
        this.hit.await();
    }

    public void allowToProceed() {
        this.run.countDown();
    }
}

