/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesMutator;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqResults;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.cq.internal.CqQueryImpl;
import org.apache.geode.cache.query.cq.internal.CqServiceImpl;
import org.apache.geode.cache.query.cq.internal.ServerCQResultsCache;
import org.apache.geode.cache.query.cq.internal.ServerCQResultsCacheNoOpImpl;
import org.apache.geode.cache.query.cq.internal.ServerCQResultsCachePartitionRegionImpl;
import org.apache.geode.cache.query.cq.internal.ServerCQResultsCacheReplicateRegionImpl;
import org.apache.geode.cache.query.internal.CompiledBindArgument;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CqStateImpl;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.cq.CqServiceProvider;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ServerCQImpl
extends CqQueryImpl
implements DataSerializable,
ServerCQ {
    private static final Logger logger = LogService.getLogger();
    private static final ServerCQResultsCache NO_OP_CACHE = new ServerCQResultsCacheNoOpImpl();
    private volatile ServerCQResultsCache serverCQResultsCache = NO_OP_CACHE;
    volatile boolean isPR = false;
    private ClientProxyMembershipID clientProxyId = null;
    private CacheClientNotifier ccn = null;
    private String serverCqName;
    private Long filterID;

    public ServerCQImpl(CqServiceImpl cqService, String cqName, String queryString, boolean isDurable, String serverCqName) {
        super(cqService, cqName, queryString, isDurable);
        this.serverCqName = serverCqName;
    }

    public ServerCQImpl() {
    }

    @Override
    public Long getFilterID() {
        return this.filterID;
    }

    @Override
    public void setFilterID(Long filterID) {
        this.filterID = filterID;
    }

    @Override
    public void setName(String cqName) {
        this.cqName = this.serverCqName = cqName;
    }

    @Override
    public String getServerCqName() {
        return this.serverCqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void registerCq(ClientProxyMembershipID p_clientProxyId, CacheClientNotifier p_ccn, int p_cqState) throws CqException, RegionNotFoundException {
        clientProxy = null;
        this.clientProxyId = p_clientProxyId;
        if (p_ccn != null) {
            this.ccn = p_ccn;
            clientProxy = p_ccn.getClientProxy(p_clientProxyId, true);
        }
        this.validateCq();
        isDebugEnabled = ServerCQImpl.logger.isDebugEnabled();
        msg = "%s";
        t = null;
        try {
            this.query = this.constructServerSideQuery();
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug("Server side query for the cq: {} is: {}", (Object)this.cqName, (Object)this.query.getQueryString());
            }
            ** if (t == null) goto lbl-1000
        }
        catch (Exception ex) {
            try {
                t = ex;
                msg = ex instanceof ClassNotFoundException != false ? "Class not found exception. The antlr.jar or the spcified class may be missing from server side classpath. Error : %s" : "Error while parsing the query. Error : %s";
                ** if (t == null) goto lbl-1000
            }
            catch (Throwable var9_12) {
                if (t != null) {
                    s = String.format(msg, new Object[]{t});
                    if (isDebugEnabled) {
                        ServerCQImpl.logger.debug(s, (Throwable)t);
                    }
                    throw new CqException(s);
                }
                throw var9_12;
            }
lbl-1000:
            // 1 sources

            {
                s = String.format(msg, new Object[]{t});
                if (isDebugEnabled) {
                    ServerCQImpl.logger.debug(s, (Throwable)t);
                }
                throw new CqException(s);
            }
lbl-1000:
            // 1 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            s = String.format(msg, new Object[]{t});
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug(s, (Throwable)t);
            }
            throw new CqException(s);
        }
lbl-1000:
        // 1 sources

        {
        }
        this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
        if (this.cqBaseRegion == null) {
            throw new RegionNotFoundException(String.format("Region : %s specified with cq not found. CqName: %s", new Object[]{this.regionName, this.cqName}));
        }
        dp = this.cqBaseRegion.getDataPolicy();
        this.isPR = dp.withPartitioning();
        if (!this.isPR && !dp.withReplication()) {
            errMsg = dp.withPreloaded() != false && this.cqBaseRegion.getAttributes().getEvictionAttributes() != null && this.cqBaseRegion.getAttributes().getEvictionAttributes().getAction().equals(EvictionAction.LOCAL_DESTROY) != false ? String.format("CQ is not supported for replicated region: %s with eviction action: %s", new Object[]{this.regionName, this.cqBaseRegion.getAttributes().getEvictionAttributes().getAction()}) : "The region " + this.regionName + "  specified in CQ creation is neither replicated nor partitioned; only replicated or partitioned regions are allowed in CQ creation.";
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug(errMsg);
            }
            throw new CqException(errMsg);
        }
        if (dp.withReplication() && !this.cqBaseRegion.getAttributes().getScope().isDistributedAck() && !this.cqBaseRegion.getAttributes().getScope().isGlobal()) {
            errMsg = "The replicated region " + this.regionName + " specified in CQ creation does not have scope supported by CQ. The CQ supported scopes are DISTRIBUTED_ACK and GLOBAL.";
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug(errMsg);
            }
            throw new CqException(errMsg);
        }
        if (clientProxy != null) {
            clientProxy.incCqCount();
            if (clientProxy.hasOneCq()) {
                this.cqService.stats().incClientsWithCqs();
            }
            if (isDebugEnabled) {
                ServerCQImpl.logger.debug("Added CQ to the base region: {} With key as: {}", (Object)this.cqBaseRegion.getFullPath(), (Object)this.serverCqName);
            }
        }
        this.updateCqCreateStats();
        if (this.cqState.getState() != p_cqState) {
            this.setCqState(p_cqState);
        }
        if (p_cqState == 1) {
            this.cqService.addToMatchingCqMap(this);
        }
        if (CqServiceProvider.MAINTAIN_KEYS) {
            if (this.isPR) {
                this.serverCQResultsCache = new ServerCQResultsCachePartitionRegionImpl();
                this.setCqResultsCacheInitialized();
            } else {
                this.serverCQResultsCache = new ServerCQResultsCacheReplicateRegionImpl();
            }
        }
        if (p_ccn != null) {
            try {
                this.cqService.addToCqMap(this);
            }
            catch (CqExistsException cqe) {
                throw new CqException(String.format("Unable to create cq %s Error : %s", new Object[]{this.cqName, cqe.getMessage()}));
            }
            this.cqBaseRegion.getFilterProfile().registerCq(this);
        }
    }

    @VisibleForTesting
    public Set<Object> getCqResultKeyCache() {
        return this.serverCQResultsCache.getKeys();
    }

    Query constructServerSideQuery() {
        InternalCache cache = this.cqService.getInternalCache();
        DefaultQuery locQuery = (DefaultQuery)cache.getLocalQueryService().newQuery(this.queryString);
        CompiledSelect select = locQuery.getSimpleSelect();
        CompiledIteratorDef from = (CompiledIteratorDef)select.getIterators().get(0);
        this.regionName = ((CompiledRegion)from.getCollectionExpr()).getRegionPath();
        from.setCollectionExpr(new CompiledBindArgument(1));
        return locQuery;
    }

    public boolean isPartOfCqResult(Object key) {
        return this.serverCQResultsCache.contains(key);
    }

    @Override
    public void addToCqResultKeys(Object key) {
        this.serverCQResultsCache.add(key);
    }

    @Override
    public void removeFromCqResultKeys(Object key, boolean isTokenMode) {
        this.serverCQResultsCache.remove(key, isTokenMode);
    }

    @Override
    public void invalidateCqResultKeys() {
        this.serverCQResultsCache.invalidate();
    }

    void markAsDestroyedInCqResultKeys(Object key) {
        this.serverCQResultsCache.markAsDestroyed(key);
    }

    @Override
    public void setCqResultsCacheInitialized() {
        this.serverCQResultsCache.setInitialized();
    }

    @Override
    public boolean isCqResultsCacheInitialized() {
        return this.serverCQResultsCache.isInitialized();
    }

    public int getCqResultKeysSize() {
        return this.serverCQResultsCache.size();
    }

    @Override
    public boolean isOldValueRequiredForQueryProcessing(Object key) {
        return this.serverCQResultsCache.isOldValueRequiredForQueryProcessing(key);
    }

    @Override
    public void close() throws CqClosedException, CqException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean sendRequestToServer) throws CqClosedException, CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Started closing CQ CqName: {} SendRequestToServer: {}", (Object)this.cqName, (Object)sendRequestToServer);
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                if (isDebugEnabled) {
                    logger.debug("CQ is already closed, CqName: {}", (Object)this.cqName);
                }
                return;
            }
            int stateBeforeClosing = this.cqState.getState();
            this.cqState.setState(3);
            this.removeFromCqMap();
            if (stateBeforeClosing == 1) {
                this.cqService.stats().decCqsActive();
            } else if (stateBeforeClosing == 0) {
                this.cqService.stats().decCqsStopped();
            }
            this.serverCQResultsCache.clear();
            this.cqState.setState(2);
            this.cqService.stats().incCqsClosed();
            this.cqService.stats().decCqsOnClient();
            if (this.stats != null) {
                this.stats.close();
            }
        }
        if (isDebugEnabled) {
            logger.debug("Successfully closed the CQ. {}", (Object)this.cqName);
        }
    }

    @Override
    public ClientProxyMembershipID getClientProxyId() {
        return this.clientProxyId;
    }

    public CacheClientNotifier getCacheClientNotifier() {
        return this.ccn;
    }

    @Override
    protected void cleanup() {
        block4: {
            try {
                if (this.cqBaseRegion != null && !this.cqBaseRegion.isDestroyed()) {
                    this.cqBaseRegion.getFilterProfile().closeCq(this);
                    CacheClientProxy clientProxy = this.ccn.getClientProxy(this.clientProxyId);
                    clientProxy.decCqCount();
                    if (clientProxy.hasNoCq()) {
                        this.cqService.stats().decClientsWithCqs();
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug("Failed to remove CQ from the base region. CqName :{}", (Object)this.cqName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws CqClosedException {
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                throw new CqClosedException(String.format("CQ is closed, CqName : %s", this.cqName));
            }
            if (!this.isRunning()) {
                throw new IllegalStateException(String.format("CQ is not in running state, stop CQ does not apply, CqName : %s", this.cqName));
            }
            this.cqState.setState(0);
            this.cqService.stats().incCqsStopped();
            this.cqService.stats().decCqsActive();
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully stopped the CQ. {}", (Object)this.cqName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromData(DataInput in) throws IOException {
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            this.cqState.setState(DataSerializer.readInteger(in));
        }
        this.isDurable = DataSerializer.readBoolean(in);
        this.queryString = DataSerializer.readString(in);
        this.filterID = in.readLong();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeInteger(this.cqState.getState(), out);
        DataSerializer.writeBoolean(this.isDurable, out);
        DataSerializer.writeString(this.queryString, out);
        out.writeLong(this.filterID);
    }

    @Override
    public boolean isPR() {
        return this.isPR;
    }

    @Override
    public CqAttributes getCqAttributes() {
        throw new IllegalStateException("CQ attributes are not available on the server");
    }

    @Override
    public CqAttributesMutator getCqAttributesMutator() {
        throw new IllegalStateException("CQ attributes are not available on the server");
    }

    @Override
    public <E> CqResults<E> executeWithInitialResults() throws CqClosedException {
        throw new IllegalStateException("Execute cannot be called on a CQ on the server");
    }

    @Override
    public void execute() throws CqClosedException {
        throw new IllegalStateException("Execute cannot be called on a CQ on the server");
    }
}

