/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.util.List;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractHealthEvaluator {
    private static final Logger logger = LogService.getLogger();
    private int numEvaluations = 0;

    protected AbstractHealthEvaluator(GemFireHealthConfig config, DistributionManager dm) {
    }

    public void evaluate(List status) {
        ++this.numEvaluations;
        this.check(status);
    }

    protected abstract void check(List var1);

    protected boolean isFirstEvaluation() {
        return this.numEvaluations <= 1;
    }

    protected HealthStatus okayHealth(String diagnosis) {
        logger.info("OKAY_HEALTH:  {}", (Object)diagnosis);
        return new HealthStatus(GemFireHealth.OKAY_HEALTH, diagnosis);
    }

    protected HealthStatus poorHealth(String diagnosis) {
        logger.info("POOR_HEALTH:  {}", (Object)diagnosis);
        return new HealthStatus(GemFireHealth.POOR_HEALTH, diagnosis);
    }

    protected abstract String getDescription();

    abstract void close();

    public class HealthStatus {
        private GemFireHealth.Health healthCode;
        private String diagnosis;

        HealthStatus(GemFireHealth.Health healthCode, String diagnosis) {
            this.healthCode = healthCode;
            this.diagnosis = "[" + AbstractHealthEvaluator.this.getDescription() + "] " + diagnosis;
        }

        public GemFireHealth.Health getHealthCode() {
            return this.healthCode;
        }

        public String getDiagnosis() {
            return this.diagnosis;
        }
    }
}

