/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.sockets.Message;

public class TXFailoverOp {
    public static void execute(ExecutablePool pool, int txId) {
        pool.execute(new TXFailoverOpImpl(txId));
    }

    private TXFailoverOp() {
    }

    protected static class TXFailoverOpImpl
    extends AbstractOp {
        int txId;

        protected TXFailoverOpImpl(int txId) {
            super(88, 1);
            this.getMessage().setTransactionId(txId);
            this.txId = txId;
        }

        public String toString() {
            return "TXFailoverOp(txId=" + this.txId + ")";
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "txFailover");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 2;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startTxFailover();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endTxFailoverSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endTxFailover(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

