/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;

class AdminReplyProcessor
extends ReplyProcessor21 {
    private volatile AdminResponse response;
    private volatile Thread thread;
    private volatile boolean isCancelled = false;
    private final InternalDistributedMember responder;

    AdminReplyProcessor(InternalDistributedSystem system, InternalDistributedMember member) {
        super(system, member);
        this.responder = member;
    }

    @Override
    public void process(DistributionMessage message) {
        try {
            this.response = (AdminResponse)message;
        }
        finally {
            super.process(message);
        }
    }

    @Override
    protected void preWait() {
        this.thread = Thread.currentThread();
        super.preWait();
    }

    public void cancel() {
        this.isCancelled = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected boolean handleInterruption(InterruptedException ie, long msecsRemaining) throws InterruptedException, ReplyException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isCancelled) {
            return true;
        }
        throw ie;
    }

    public AdminResponse getResponse() {
        return this.response;
    }

    public InternalDistributedMember getResponder() {
        return this.responder;
    }
}

