/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.SystemFailure;

public class FunctionHelper {
    private static final short FUN_AVG = 1;
    private static final short FUN_MIN = 2;
    private static final short FUN_MAX = 3;
    private static final short FUN_SUM = 4;
    private static final String STR_AVG = "Average";
    private static final String STR_MIN = "Min Value";
    private static final String STR_MAX = "Max Value";
    private static final String STR_ADD = "Sum";

    public static String[] getFunctionNames() {
        return new String[]{STR_ADD, STR_AVG, STR_MIN, STR_MAX};
    }

    public static String getFunctionName(short functionId) {
        switch (functionId) {
            case 1: {
                return STR_AVG;
            }
            case 2: {
                return STR_MIN;
            }
            case 3: {
                return STR_MAX;
            }
            case 4: {
                return STR_ADD;
            }
        }
        return null;
    }

    public static short getFunctionIdentifier(String qFunctionName) {
        if (qFunctionName == null) {
            return -1;
        }
        if (qFunctionName.equalsIgnoreCase(STR_ADD)) {
            return 4;
        }
        if (qFunctionName.equalsIgnoreCase(STR_AVG)) {
            return 1;
        }
        if (qFunctionName.equalsIgnoreCase(STR_MIN)) {
            return 2;
        }
        if (qFunctionName.equalsIgnoreCase(STR_MAX)) {
            return 3;
        }
        return -1;
    }

    public static Number[] applyFunction(short functorId, Number[] vals) {
        Number[] res = new Number[1];
        switch (functorId) {
            case 4: {
                res[0] = FunctionHelper.SUM(vals);
                return res;
            }
            case 1: {
                res[0] = FunctionHelper.AVG(vals);
                return res;
            }
            case 2: {
                res[0] = FunctionHelper.MIN(vals);
                return res;
            }
            case 3: {
                res[0] = FunctionHelper.MAX(vals);
                return res;
            }
        }
        return null;
    }

    public static Number SUM(Number[] vals) {
        try {
            double sum = 0.0;
            for (int i = 0; i < vals.length; ++i) {
                sum += vals[i].doubleValue();
            }
            return sum;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return null;
        }
    }

    public static Number AVG(Number[] vals) {
        try {
            return FunctionHelper.SUM(vals).doubleValue() / (double)vals.length;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            return null;
        }
    }

    public static Number MIN(Number[] vals) {
        try {
            List<Number> col = Arrays.asList(vals);
            Number min = Collections.max(col);
            return min;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return null;
        }
    }

    public static Number MAX(Number[] vals) {
        try {
            List<Number> col = Arrays.asList(vals);
            Number max = Collections.max(col);
            return max;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return null;
        }
    }
}

