/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.persistence.PartitionOfflineException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.OneTaskOnlyExecutor;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.BucketPersistenceAdvisor;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionRegionConfig;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PartitionedRegionException;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.ProxyBucketRegion;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.internal.cache.partitioned.BucketBackupMessage;
import org.apache.geode.internal.cache.partitioned.CreateBucketMessage;
import org.apache.geode.internal.cache.partitioned.CreateMissingBucketsTask;
import org.apache.geode.internal.cache.partitioned.DataStoreBuckets;
import org.apache.geode.internal.cache.partitioned.EndBucketCreationMessage;
import org.apache.geode.internal.cache.partitioned.FetchPartitionDetailsMessage;
import org.apache.geode.internal.cache.partitioned.InternalPRInfo;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.cache.partitioned.ManageBackupBucketMessage;
import org.apache.geode.internal.cache.partitioned.ManageBucketMessage;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetailsImpl;
import org.apache.geode.internal.cache.partitioned.PRLoad;
import org.apache.geode.internal.cache.partitioned.PartitionMemberInfoImpl;
import org.apache.geode.internal.cache.partitioned.PartitionRegionInfoImpl;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOpFactory;
import org.apache.geode.internal.cache.partitioned.PersistentBucketRecoverer;
import org.apache.geode.internal.cache.partitioned.RecoveryRunnable;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.cache.partitioned.rebalance.CompositeDirector;
import org.apache.geode.internal.cache.partitioned.rebalance.FPRDirector;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.persistence.MembershipFlushRequest;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PRHARedundancyProvider {
    private static final Logger logger = LogService.getLogger();
    public static final String TIMEOUT_MSG = "If your system has sufficient space, perhaps it is under membership or region creation stress?";
    public static final String INSUFFICIENT_STORES_MSG = "Advise you to start enough data store nodes";
    private static final boolean DISABLE_CREATE_BUCKET_RANDOMNESS = Boolean.getBoolean("gemfire.DISABLE_CREATE_BUCKET_RANDOMNESS");
    private static final String DATASTORE_DISCOVERY_TIMEOUT_PROPERTY_NAME = "gemfire.partitionedRegionDatastoreDiscoveryTimeout";
    private static final String SUFFICIENT_STORES_MSG = "Found a member to host a bucket.";
    private static final String ALLOCATE_ENOUGH_MEMBERS_TO_HOST_BUCKET = "allocate enough members to host a new bucket";
    private static final long INSUFFICIENT_LOGGING_THROTTLE_TIME = TimeUnit.SECONDS.toNanos(Integer.getInteger("gemfire.InsufficientLoggingThrottleTime", 2).intValue());
    private static final ThreadLocal<Boolean> forceLocalPrimaries = new ThreadLocal();
    @MakeNotStatic
    private static final Long DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS = Long.getLong("gemfire.partitionedRegionDatastoreDiscoveryTimeout");
    @MakeNotStatic
    private static final AtomicLong insufficientLogTimeStamp = new AtomicLong(0L);
    @MakeNotStatic
    private final AtomicBoolean firstInsufficientStoresLogged = new AtomicBoolean(false);
    private final PartitionedRegion partitionedRegion;
    private final InternalResourceManager resourceManager;
    private final PartitionedRegionRebalanceOpFactory rebalanceOpFactory;
    private final CompletableFuture<Void> providerStartupTask;
    private final OneTaskOnlyExecutor recoveryExecutor;
    private final Object shutdownLock = new Object();
    private final BiFunction<PRHARedundancyProvider, Integer, PersistentBucketRecoverer> persistentBucketRecovererFunction;
    private volatile ScheduledFuture<?> recoveryFuture;
    private volatile PersistentBucketRecoverer persistentBucketRecoverer;
    private boolean shutdown;

    public PRHARedundancyProvider(PartitionedRegion partitionedRegion, InternalResourceManager resourceManager) {
        this(partitionedRegion, resourceManager, PersistentBucketRecoverer::new, PartitionedRegionRebalanceOp::new, new CompletableFuture<Void>());
    }

    @VisibleForTesting
    PRHARedundancyProvider(PartitionedRegion partitionedRegion, InternalResourceManager resourceManager, BiFunction<PRHARedundancyProvider, Integer, PersistentBucketRecoverer> persistentBucketRecovererFunction) {
        this(partitionedRegion, resourceManager, persistentBucketRecovererFunction, PartitionedRegionRebalanceOp::new, new CompletableFuture<Void>());
    }

    @VisibleForTesting
    PRHARedundancyProvider(PartitionedRegion partitionedRegion, InternalResourceManager resourceManager, BiFunction<PRHARedundancyProvider, Integer, PersistentBucketRecoverer> persistentBucketRecovererFunction, PartitionedRegionRebalanceOpFactory rebalanceOpFactory, CompletableFuture<Void> providerStartupTask) {
        this.partitionedRegion = partitionedRegion;
        this.resourceManager = resourceManager;
        this.rebalanceOpFactory = rebalanceOpFactory;
        this.providerStartupTask = providerStartupTask;
        this.recoveryExecutor = new OneTaskOnlyExecutor(resourceManager.getExecutor(), () -> InternalResourceManager.getResourceObserver().recoveryConflated(partitionedRegion), this.getThreadMonitorObj());
        this.persistentBucketRecovererFunction = persistentBucketRecovererFunction;
    }

    private static String regionStatus(PartitionedRegion partitionedRegion, Collection<InternalDistributedMember> allStores, Collection<InternalDistributedMember> alreadyUsed, boolean forLog) {
        String newLine = forLog ? " " : System.lineSeparator();
        String spaces = forLog ? "" : "   ";
        StringBuilder sb = new StringBuilder();
        sb.append("Partitioned Region name = ");
        sb.append(partitionedRegion.getFullPath());
        if (allStores != null) {
            sb.append(newLine).append(spaces);
            sb.append("Redundancy level set to ");
            sb.append(partitionedRegion.getRedundantCopies());
            sb.append(newLine);
            sb.append(". Number of available data stores: ");
            sb.append(allStores.size());
            sb.append(newLine).append(spaces);
            sb.append(". Number successfully allocated = ");
            sb.append(alreadyUsed.size());
            sb.append(newLine);
            sb.append(". Data stores: ");
            sb.append(PartitionedRegionHelper.printCollection(allStores));
            sb.append(newLine);
            sb.append(". Data stores successfully allocated: ");
            sb.append(PartitionedRegionHelper.printCollection(alreadyUsed));
            sb.append(newLine);
            sb.append(". Equivalent members: ");
            sb.append(PartitionedRegionHelper.printCollection(partitionedRegion.getDistributionManager().getMembersInThisZone()));
        }
        return sb.toString();
    }

    public static void timedOut(PartitionedRegion partitionedRegion, Set<InternalDistributedMember> allStores, Collection<InternalDistributedMember> alreadyUsed, String opString, long timeOut) {
        throw new PartitionedRegionStorageException(String.format("Timed out attempting to %s in the partitioned region.%sWaited for: %s ms.", opString, PRHARedundancyProvider.regionStatus(partitionedRegion, allStores, alreadyUsed, true), timeOut) + TIMEOUT_MSG);
    }

    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    private Set<InternalDistributedMember> getAllStores(String partitionName) {
        if (partitionName != null) {
            return this.getFixedPartitionStores(partitionName);
        }
        Set<InternalDistributedMember> allStores = this.partitionedRegion.getRegionAdvisor().adviseDataStore(true);
        PartitionedRegionDataStore localDataStore = this.partitionedRegion.getDataStore();
        if (localDataStore != null) {
            allStores.add(this.partitionedRegion.getDistributionManager().getId());
        }
        return allStores;
    }

    private Set<InternalDistributedMember> getFixedPartitionStores(String partitionName) {
        Set<InternalDistributedMember> members = this.partitionedRegion.getRegionAdvisor().adviseFixedPartitionDataStores(partitionName);
        List<FixedPartitionAttributesImpl> allFixedPartitionAttributes = this.partitionedRegion.getFixedPartitionAttributesImpl();
        if (allFixedPartitionAttributes != null) {
            for (FixedPartitionAttributesImpl fixedPartitionAttributes : allFixedPartitionAttributes) {
                if (!fixedPartitionAttributes.getPartitionName().equals(partitionName)) continue;
                members.add(this.partitionedRegion.getMyId());
            }
        }
        return members;
    }

    private void insufficientStores(Set<InternalDistributedMember> allStores, Collection<InternalDistributedMember> alreadyUsed, boolean onlyLog) {
        String notEnoughValidNodes;
        String regionStat = PRHARedundancyProvider.regionStatus(this.partitionedRegion, allStores, alreadyUsed, onlyLog);
        String newLine = onlyLog ? " " : System.lineSeparator();
        String string = notEnoughValidNodes = alreadyUsed.isEmpty() ? "Unable to find any members to host a bucket in the partitioned region. %s.%s" : "Configured redundancy level could not be satisfied. %s to satisfy redundancy for the region.%s";
        if (!onlyLog) {
            throw new PartitionedRegionStorageException(String.format(notEnoughValidNodes, INSUFFICIENT_STORES_MSG, newLine + regionStat + newLine));
        }
        logger.warn(String.format(notEnoughValidNodes, INSUFFICIENT_STORES_MSG, newLine + regionStat + newLine));
    }

    private InternalDistributedMember createBucketInstance(int bucketId, int newBucketSize, Collection<InternalDistributedMember> excludedMembers, Collection<InternalDistributedMember> alreadyUsed, ArrayListWithClearState<InternalDistributedMember> failedMembers, long timeOut, Set<InternalDistributedMember> allStores) {
        RegionAdvisor.PartitionProfile profile;
        InternalDistributedMember candidate;
        boolean isDebugEnabled = logger.isDebugEnabled();
        HashSet<InternalDistributedMember> candidateMembers = new HashSet<InternalDistributedMember>(allStores);
        candidateMembers.removeAll(alreadyUsed);
        candidateMembers.removeAll(excludedMembers);
        candidateMembers.removeAll(failedMembers);
        if (isDebugEnabled) {
            logger.debug("AllStores={} AlreadyUsed={} excluded={} failed={}", allStores, alreadyUsed, excludedMembers, failedMembers);
        }
        if (candidateMembers.isEmpty()) {
            this.partitionedRegion.checkReadiness();
            if (System.currentTimeMillis() > timeOut) {
                if (isDebugEnabled) {
                    logger.debug("createBucketInstance: ran out of candidates and timed out");
                }
                return null;
            }
            candidateMembers = new HashSet<InternalDistributedMember>(allStores);
            candidateMembers.removeAll(alreadyUsed);
            candidateMembers.removeAll(excludedMembers);
            failedMembers.clear();
        }
        if (isDebugEnabled) {
            logger.debug("createBucketInstance: candidateMembers = {}", candidateMembers);
        }
        if (candidateMembers.isEmpty()) {
            if (isDebugEnabled) {
                logger.debug("createBucketInstance: no valid candidates");
            }
            return null;
        }
        if (this.partitionedRegion.isFixedPartitionedRegion()) {
            candidate = (InternalDistributedMember)candidateMembers.iterator().next();
        } else {
            String colocatedWith = this.partitionedRegion.getAttributes().getPartitionAttributes().getColocatedWith();
            if (colocatedWith != null) {
                candidate = this.getColocatedDataStore(candidateMembers, alreadyUsed, bucketId, colocatedWith);
            } else {
                ArrayList<InternalDistributedMember> orderedCandidates = new ArrayList<InternalDistributedMember>(candidateMembers);
                candidate = this.getPreferredDataStore(orderedCandidates, alreadyUsed);
            }
        }
        if (candidate == null) {
            failedMembers.addAll(candidateMembers);
            return null;
        }
        if (!this.partitionedRegion.isShadowPR() && !ColocationHelper.checkMembersColocation(this.partitionedRegion, candidate)) {
            if (isDebugEnabled) {
                logger.debug("createBucketInstances - Member does not have all of the regions colocated with partitionedRegion {}", (Object)candidate);
            }
            failedMembers.add(candidate);
            return null;
        }
        if (!candidate.equals(this.partitionedRegion.getMyId()) && (profile = this.partitionedRegion.getRegionAdvisor().getPartitionProfile(candidate)) == null) {
            if (isDebugEnabled) {
                logger.debug("createBucketInstance: {}: no partition profile for {}", (Object)this.partitionedRegion.getFullPath(), (Object)candidate);
            }
            failedMembers.add(candidate);
            return null;
        }
        ManageBucketRsp response = this.createBucketOnMember(bucketId, candidate, newBucketSize, ((ArrayListWithClearState)failedMembers).wasCleared());
        if (response.isAcceptance()) {
            return candidate;
        }
        if (isDebugEnabled) {
            logger.debug("createBucketInstance: {}: candidate {} declined to manage bucketId={}: {}", (Object)this.partitionedRegion.getFullPath(), (Object)candidate, (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)response);
        }
        if (response.equals(ManageBucketRsp.CLOSED)) {
            excludedMembers.add(candidate);
        } else {
            failedMembers.add(candidate);
        }
        return null;
    }

    InternalDistributedMember createBucketOnDataStore(int bucketId, int size, PartitionedRegion.RetryTimeKeeper retryTimeKeeper) {
        InternalDistributedMember memberHostingBucket;
        boolean isDebugEnabled = logger.isDebugEnabled();
        InternalDistributedMember primaryForFixedPartition = null;
        if (this.partitionedRegion.isFixedPartitionedRegion()) {
            primaryForFixedPartition = this.partitionedRegion.getRegionAdvisor().adviseFixedPrimaryPartitionDataStore(bucketId);
        }
        HashSet<InternalDistributedMember> attempted = new HashSet<InternalDistributedMember>();
        do {
            this.partitionedRegion.checkReadiness();
            Set<InternalDistributedMember> available = this.partitionedRegion.getRegionAdvisor().adviseInitializedDataStore();
            available.removeAll(attempted);
            InternalDistributedMember targetMember = null;
            Iterator<InternalDistributedMember> iterator = available.iterator();
            if (iterator.hasNext()) {
                InternalDistributedMember member = iterator.next();
                targetMember = available.contains(primaryForFixedPartition) ? primaryForFixedPartition : member;
            }
            if (targetMember == null) {
                if (this.shouldLogInsufficientStores()) {
                    this.insufficientStores(available, Collections.emptySet(), true);
                }
                this.insufficientStores(available, Collections.emptySet(), false);
            }
            try {
                CreateBucketMessage.NodeResponse response;
                if (isDebugEnabled) {
                    logger.debug("Attempting to get data store {} to create the bucket {} for us", (Object)targetMember, (Object)this.partitionedRegion.bucketStringForLogs(bucketId));
                }
                if ((memberHostingBucket = (response = CreateBucketMessage.send(targetMember, this.partitionedRegion, bucketId, size)).waitForResponse()) != null) {
                    return memberHostingBucket;
                }
            }
            catch (ForceReattemptException forceReattemptException) {
                // empty catch block
            }
            attempted.add(targetMember);
        } while ((memberHostingBucket = this.partitionedRegion.getNodeForBucketWrite(bucketId, retryTimeKeeper)) == null);
        return memberHostingBucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalDistributedMember createBucketAtomically(int bucketId, int newBucketSize, boolean finishIncompleteCreation, String partitionName) throws PartitionedRegionStorageException, PartitionedRegionException, PartitionOfflineException {
        isDebugEnabled = PRHARedundancyProvider.logger.isDebugEnabled();
        this.partitionedRegion.checkPROffline();
        this.earlySufficientStoresCheck(partitionName);
        var6_6 = this;
        synchronized (var6_6) {
            block43: {
                block42: {
                    if (this.partitionedRegion.getCache().isCacheAtShutdownAll()) {
                        throw this.partitionedRegion.getCache().getCacheClosedException("Cache is shutting down");
                    }
                    if (isDebugEnabled) {
                        PRHARedundancyProvider.logger.debug("Starting atomic creation of bucketId={}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId));
                    }
                    timeOut = System.currentTimeMillis() + this.computeTimeout();
                    observer = null;
                    needToElectPrimary = true;
                    bucketPrimary = null;
                    try {
                        this.partitionedRegion.checkReadiness();
                        toCreate = this.partitionedRegion.getRegionAdvisor().getBucket(bucketId);
                        if (!finishIncompleteCreation && (bucketPrimary = this.partitionedRegion.getBucketPrimary(bucketId)) != null) {
                            if (isDebugEnabled) {
                                PRHARedundancyProvider.logger.debug("during atomic creation, discovered that the primary already exists {} returning early", (Object)bucketPrimary);
                            }
                            needToElectPrimary = false;
                            var13_15 = bucketPrimary;
                            if (observer == null) break block42;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (CancelException | RegionDestroyedException e) {
                        needToElectPrimary = false;
                        throw e;
                    }
                    catch (PartitionOfflineException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        if (isDebugEnabled) {
                            PRHARedundancyProvider.logger.debug("Unable to create new bucket {}: {}", (Object)bucketId, (Object)e.getMessage(), (Object)e);
                        }
                        if (finishIncompleteCreation != false) throw e;
                        this.cleanUpBucket(bucketId);
                        throw e;
                    }
                    catch (Throwable var29_35) {
                        if (observer != null) {
                            BucketMembershipObserver.access$800(observer);
                        }
                        if (needToElectPrimary == false) throw var29_35;
                        try {
                            this.endBucketCreation(bucketId, this.partitionedRegion.getRegionAdvisor().getBucketOwners(bucketId), bucketPrimary, partitionName);
                            throw var29_35;
                        }
                        catch (Exception e) {
                            if (e instanceof CancelException || this.partitionedRegion.getCancelCriterion().isCancelInProgress()) {
                                PRHARedundancyProvider.logger.debug("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                                throw var29_35;
                            }
                            PRHARedundancyProvider.logger.warn("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                        }
                        throw var29_35;
                    }
                    BucketMembershipObserver.access$800(observer);
                }
                if (needToElectPrimary == false) return var13_15;
                try {
                    this.endBucketCreation(bucketId, this.partitionedRegion.getRegionAdvisor().getBucketOwners(bucketId), bucketPrimary, partitionName);
                }
                catch (Exception e) {
                    if (e instanceof CancelException || this.partitionedRegion.getCancelCriterion().isCancelInProgress()) {
                        PRHARedundancyProvider.logger.debug("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                    }
                    PRHARedundancyProvider.logger.warn("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                }
                return var13_15;
lbl-1000:
                // 1 sources

                {
                    observer = BucketMembershipObserver.access$400(new BucketMembershipObserver(toCreate));
                    failedMembers = new ArrayListWithClearState<InternalDistributedMember>();
                    excludedMembers = new HashSet<InternalDistributedMember>();
                    acceptedMembers = new ArrayList<InternalDistributedMember>();
                    loggedInsufficientStores = false;
                    while (true) {
                        this.partitionedRegion.checkReadiness();
                        if (this.partitionedRegion.getCache().isCacheAtShutdownAll()) {
                            if (isDebugEnabled == false) throw this.partitionedRegion.getCache().getCacheClosedException("Cache is shutting down");
                            PRHARedundancyProvider.logger.debug("Aborted createBucketAtomically due to ShutdownAll");
                            throw this.partitionedRegion.getCache().getCacheClosedException("Cache is shutting down");
                        }
                        timeLeft = timeOut - System.currentTimeMillis();
                        if (timeLeft < 0L) {
                            PRHARedundancyProvider.timedOut(this.partitionedRegion, this.getAllStores(partitionName), acceptedMembers, "allocate enough members to host a new bucket", this.computeTimeout());
                        }
                        if (isDebugEnabled) {
                            PRHARedundancyProvider.logger.debug("createBucketAtomically: have {} ms left to finish this", (Object)timeLeft);
                        }
                        allStores = this.getAllStores(partitionName);
                        loggedInsufficientStores = this.checkSufficientStores(allStores, loggedInsufficientStores);
                        candidate = this.createBucketInstance(bucketId, newBucketSize, excludedMembers, acceptedMembers, failedMembers, timeOut, allStores);
                        if (candidate != null && this.partitionedRegion.getDistributionManager().enforceUniqueZone()) {
                            if (!(this.partitionedRegion.getDistributionManager() instanceof LonerDistributionManager)) {
                                exm = this.getBuddyMembersInZone(candidate, allStores);
                                exm.remove(candidate);
                                exm.removeAll(acceptedMembers);
                                excludedMembers.addAll(exm);
                            } else {
                                PRHARedundancyProvider.logger.warn("enforce-unique-host and redundancy-zone properties have no effect for a LonerDistributedSystem.");
                            }
                        }
                        acceptedMembers = this.partitionedRegion.getRegionAdvisor().getBucketOwners(bucketId);
                        if (isDebugEnabled) {
                            PRHARedundancyProvider.logger.debug("Accepted members: {}", acceptedMembers);
                        }
                        if (bucketPrimary == null && acceptedMembers.contains(candidate)) {
                            bucketPrimary = candidate;
                        }
                        this.verifyBucketNodes(excludedMembers, partitionName);
                        potentialCandidateCount = allStores.size() - (excludedMembers.size() + acceptedMembers.size() + failedMembers.size());
                        exhaustedPotentialCandidates = ArrayListWithClearState.access$000(failedMembers) != false && potentialCandidateCount <= 0;
                        redundancySatisfied = acceptedMembers.size() > this.partitionedRegion.getRedundantCopies();
                        bucketNotCreated = acceptedMembers.isEmpty();
                        if (isDebugEnabled) {
                            PRHARedundancyProvider.logger.debug("potentialCandidateCount={}, exhaustedPotentialCandidates={}, redundancySatisfied={}, bucketNotCreated={}", (Object)potentialCandidateCount, (Object)exhaustedPotentialCandidates, (Object)redundancySatisfied, (Object)bucketNotCreated);
                        }
                        if (bucketNotCreated) continue;
                        if (exhaustedPotentialCandidates && !redundancySatisfied) {
                            this.insufficientStores(allStores, acceptedMembers, true);
                        }
                        if (!redundancySatisfied && !exhaustedPotentialCandidates) continue;
                        this.endBucketCreation(bucketId, acceptedMembers, bucketPrimary, partitionName);
                        expectedRemoteHosts = acceptedMembers.size() - (acceptedMembers.contains(this.partitionedRegion.getMyId()) != false ? 1 : 0);
                        interrupted = Thread.interrupted();
                        try {
                            results = BucketMembershipObserver.access$600(observer, expectedRemoteHosts, acceptedMembers, partitionName);
                            if (BucketMembershipObserverResults.access$700(results)) continue;
                            bucketPrimary = results.primary;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                            this.partitionedRegion.getCancelCriterion().checkCancelInProgress(e);
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                    needToElectPrimary = false;
                    var27_31 = bucketPrimary;
                    if (observer == null) break block43;
                }
                BucketMembershipObserver.access$800(observer);
            }
            if (needToElectPrimary == false) return var27_31;
            try {
                this.endBucketCreation(bucketId, this.partitionedRegion.getRegionAdvisor().getBucketOwners(bucketId), bucketPrimary, partitionName);
            }
            catch (Exception e) {
                if (e instanceof CancelException || this.partitionedRegion.getCancelCriterion().isCancelInProgress()) {
                    PRHARedundancyProvider.logger.debug("Exception trying choose a primary after bucket creation failure", (Throwable)e);
                }
                PRHARedundancyProvider.logger.warn("Exception trying choose a primary after bucket creation failure", (Throwable)e);
            }
            return var27_31;
        }
    }

    private void endBucketCreation(int bucketId, Collection<InternalDistributedMember> acceptedMembers, InternalDistributedMember targetPrimary, String partitionName) {
        if (acceptedMembers.isEmpty()) {
            return;
        }
        acceptedMembers = new HashSet<InternalDistributedMember>(acceptedMembers);
        if (partitionName != null) {
            if (this.isLocalPrimary(partitionName)) {
                targetPrimary = this.partitionedRegion.getMyId();
            } else {
                targetPrimary = this.partitionedRegion.getRegionAdvisor().adviseFixedPrimaryPartitionDataStore(bucketId);
                if (targetPrimary == null) {
                    Set<InternalDistributedMember> fpDataStores = this.getFixedPartitionStores(partitionName);
                    targetPrimary = fpDataStores.iterator().next();
                }
            }
        }
        if (targetPrimary == null) {
            targetPrimary = this.getPreferredDataStore(acceptedMembers, Collections.emptySet());
        }
        boolean isHosting = acceptedMembers.remove(this.partitionedRegion.getDistributionManager().getId());
        EndBucketCreationMessage.send(acceptedMembers, targetPrimary, this.partitionedRegion, bucketId);
        if (isHosting) {
            this.endBucketCreationLocally(bucketId, targetPrimary);
        }
    }

    private boolean isLocalPrimary(String partitionName) {
        List<FixedPartitionAttributesImpl> allFixedPartitionAttributes = this.partitionedRegion.getFixedPartitionAttributesImpl();
        if (allFixedPartitionAttributes != null) {
            for (FixedPartitionAttributesImpl fixedPartitionAttributes : allFixedPartitionAttributes) {
                if (!fixedPartitionAttributes.getPartitionName().equals(partitionName) || !fixedPartitionAttributes.isPrimary()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBucketCreationLocally(int bucketId, InternalDistributedMember newPrimary) {
        if (this.partitionedRegion.getCancelCriterion().isCancelInProgress() || this.partitionedRegion.isDestroyed()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("endBucketCreationLocally: for region {} bucketId={} new primary: {}", (Object)this.partitionedRegion.getFullPath(), (Object)bucketId, (Object)newPrimary);
        }
        BucketAdvisor bucketAdvisor = this.partitionedRegion.getRegionAdvisor().getBucketAdvisor(bucketId);
        ProxyBucketRegion proxyBucketRegion = bucketAdvisor.getProxyBucketRegion();
        BucketPersistenceAdvisor persistentAdvisor = proxyBucketRegion.getPersistenceAdvisor();
        ProxyBucketRegion proxyBucketRegion2 = proxyBucketRegion;
        synchronized (proxyBucketRegion2) {
            BucketRegion realBucket;
            if (persistentAdvisor != null && (realBucket = proxyBucketRegion.getCreatedBucketRegion()) != null) {
                PersistentMemberID persistentId = realBucket.getPersistentID();
                persistentAdvisor.endBucketCreation(persistentId);
            }
            bucketAdvisor.setPrimaryElector(newPrimary);
            if (this.partitionedRegion.getGemFireCache().getMyId().equals(newPrimary)) {
                if (bucketAdvisor.isHosting()) {
                    bucketAdvisor.clearPrimaryElector();
                    bucketAdvisor.volunteerForPrimary();
                }
            } else {
                if (!bucketAdvisor.adviseInitialized().contains(newPrimary)) {
                    bucketAdvisor.clearPrimaryElector();
                    bucketAdvisor.volunteerForPrimary();
                }
                if (bucketAdvisor.getHadPrimary()) {
                    bucketAdvisor.clearPrimaryElector();
                    bucketAdvisor.volunteerForPrimary();
                }
            }
        }
        if (persistentAdvisor != null) {
            bucketAdvisor.endBucketCreation();
        }
        List<PartitionedRegion> colocatedWithList = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        for (PartitionedRegion child : colocatedWithList) {
            if (!child.getRegionAdvisor().isBucketLocal(bucketId)) continue;
            child.getRedundancyProvider().endBucketCreationLocally(bucketId, newPrimary);
        }
    }

    private Set<InternalDistributedMember> getBuddyMembersInZone(InternalDistributedMember acceptedMember, Collection<InternalDistributedMember> allStores) {
        DistributionManager dm = this.partitionedRegion.getDistributionManager();
        Set<InternalDistributedMember> buddies = dm.getMembersInSameZone(acceptedMember);
        buddies.retainAll(allStores);
        return buddies;
    }

    private void earlySufficientStoresCheck(String partitionName) {
        assert (Assert.assertHoldsLock(this, false));
        Set<InternalDistributedMember> currentStores = this.getAllStores(partitionName);
        if (currentStores.isEmpty()) {
            if (this.shouldLogInsufficientStores()) {
                this.insufficientStores(currentStores, Collections.emptyList(), true);
            }
            this.insufficientStores(currentStores, Collections.emptyList(), false);
        }
    }

    private boolean shouldLogInsufficientStores() {
        long now = NanoTimer.getTime();
        long delta = now - insufficientLogTimeStamp.get();
        if (this.firstInsufficientStoresLogged.compareAndSet(false, true) || delta >= INSUFFICIENT_LOGGING_THROTTLE_TIME) {
            insufficientLogTimeStamp.set(now);
            return true;
        }
        return false;
    }

    private long computeTimeout() {
        long millis;
        if (DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS != null && (millis = DATASTORE_DISCOVERY_TIMEOUT_MILLISECONDS.longValue()) > 0L) {
            return millis;
        }
        return this.partitionedRegion.getRetryTimeout();
    }

    private boolean checkSufficientStores(Set<InternalDistributedMember> allStores, boolean loggedInsufficientStores) {
        if (!loggedInsufficientStores) {
            if (allStores.isEmpty()) {
                this.insufficientStores(allStores, Collections.emptyList(), true);
                return true;
            }
        } else {
            if (!allStores.isEmpty()) {
                logger.info("{} Region name, {}", (Object)SUFFICIENT_STORES_MSG, (Object)this.partitionedRegion.getFullPath());
                return false;
            }
            this.insufficientStores(allStores, Collections.emptyList(), false);
        }
        return loggedInsufficientStores;
    }

    private void cleanUpBucket(int bucketId) {
        Set<InternalDistributedMember> dataStores = this.partitionedRegion.getRegionAdvisor().adviseDataStore();
        BucketBackupMessage.send(dataStores, this.partitionedRegion, bucketId);
    }

    public void finishIncompleteBucketCreation(int bucketId) {
        String partitionName = null;
        if (this.partitionedRegion.isFixedPartitionedRegion()) {
            FixedPartitionAttributesImpl fpa = PartitionedRegionHelper.getFixedPartitionAttributesForBucket(this.partitionedRegion, bucketId);
            partitionName = fpa.getPartitionName();
        }
        this.createBucketAtomically(bucketId, 0, true, partitionName);
    }

    public boolean createBackupBucketOnMember(int bucketId, InternalDistributedMember targetMember, boolean isRebalance, boolean replaceOfflineData, InternalDistributedMember fromMember, boolean forceCreation) {
        boolean bucketManaged;
        if (logger.isDebugEnabled()) {
            logger.debug("createBackupBucketOnMember for bucketId={} member: {}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)targetMember);
        }
        if (!targetMember.equals(this.partitionedRegion.getMyId())) {
            RegionAdvisor.PartitionProfile profile = this.partitionedRegion.getRegionAdvisor().getPartitionProfile(targetMember);
            if (profile == null) {
                return false;
            }
            try {
                ManageBackupBucketMessage.NodeResponse response = ManageBackupBucketMessage.send(targetMember, this.partitionedRegion, bucketId, isRebalance, replaceOfflineData, fromMember, forceCreation);
                if (response.waitForAcceptance()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("createBackupBucketOnMember: Bucket creation succeed for bucketId={} on member = {}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)targetMember);
                    }
                    return true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("createBackupBucketOnMember: Bucket creation failed for bucketId={} on member = {}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)targetMember);
                }
                return false;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!(e instanceof ForceReattemptException || e instanceof CancelException || e.getCause() != null && e.getCause() instanceof CancelException)) {
                    logger.warn("Exception creating partition on {}", (Object)targetMember, (Object)e);
                }
                return false;
            }
        }
        PartitionedRegionDataStore dataStore = this.partitionedRegion.getDataStore();
        boolean bl = bucketManaged = dataStore != null && dataStore.grabBucket(bucketId, fromMember, forceCreation, replaceOfflineData, isRebalance, null, false).equals((Object)PartitionedRegionDataStore.CreateBucketResult.CREATED);
        if (!bucketManaged && logger.isDebugEnabled()) {
            logger.debug("createBackupBucketOnMember: Local data store refused to accommodate the data for bucketId={} dataStore={}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)dataStore);
        }
        return bucketManaged;
    }

    private boolean getForceLocalPrimaries() {
        boolean result = false;
        Boolean forceLocalPrimariesValue = forceLocalPrimaries.get();
        if (forceLocalPrimariesValue != null) {
            result = forceLocalPrimariesValue;
        }
        return result;
    }

    private ManageBucketRsp createBucketOnMember(int bucketId, InternalDistributedMember targetMember, int newBucketSize, boolean forceCreation) {
        boolean bucketManaged;
        if (logger.isDebugEnabled()) {
            logger.debug("createBucketOnMember for bucketId={} member: {}{}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)targetMember, (Object)(forceCreation ? " forced" : ""));
        }
        if (!targetMember.equals(this.partitionedRegion.getMyId())) {
            RegionAdvisor.PartitionProfile profile = this.partitionedRegion.getRegionAdvisor().getPartitionProfile(targetMember);
            if (profile == null) {
                return ManageBucketRsp.NO;
            }
            try {
                ManageBucketMessage.NodeResponse response = ManageBucketMessage.send(targetMember, this.partitionedRegion, bucketId, newBucketSize, forceCreation);
                if (response.waitForAcceptance()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("createBucketOnMember: Bucket creation succeed for bucketId={} on member = {}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)targetMember);
                    }
                    return ManageBucketRsp.YES;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("createBucketOnMember: Bucket creation failed for bucketId={} on member = {}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId), (Object)targetMember);
                }
                return response.rejectedDueToInitialization() ? ManageBucketRsp.NO_INITIALIZING : ManageBucketRsp.NO;
            }
            catch (PartitionOfflineException e) {
                throw e;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (e instanceof CancelException || e.getCause() != null && e.getCause() instanceof CancelException) {
                    return ManageBucketRsp.CLOSED;
                }
                if (!(e instanceof ForceReattemptException)) {
                    logger.warn("Exception creating partition on {}", (Object)targetMember, (Object)e);
                }
                return ManageBucketRsp.NO;
            }
        }
        PartitionedRegionDataStore dataStore = this.partitionedRegion.getDataStore();
        boolean bl = bucketManaged = dataStore != null && dataStore.handleManageBucketRequest(bucketId, newBucketSize, this.partitionedRegion.getMyId(), forceCreation);
        if (!bucketManaged && logger.isDebugEnabled()) {
            logger.debug("createBucketOnMember: Local data store not able to accommodate the data for bucketId={}", (Object)this.partitionedRegion.bucketStringForLogs(bucketId));
        }
        return ManageBucketRsp.valueOf(bucketManaged);
    }

    private InternalDistributedMember getColocatedDataStore(Collection<InternalDistributedMember> candidates, Collection<InternalDistributedMember> alreadyUsed, int bucketId, String prName) {
        Assert.assertTrue(prName != null);
        PartitionedRegion colocatedRegion = ColocationHelper.getColocatedRegion(this.partitionedRegion);
        LocalRegion prRoot = PartitionedRegionHelper.getPRRoot(this.partitionedRegion.getCache());
        PartitionRegionConfig config = (PartitionRegionConfig)prRoot.get(this.partitionedRegion.getRegionIdentifier());
        if (!config.isColocationComplete()) {
            throw new IllegalStateException("Cannot create buckets, as colocated regions are not configured to be at the same nodes.");
        }
        RegionAdvisor advisor = colocatedRegion.getRegionAdvisor();
        if (alreadyUsed.isEmpty()) {
            InternalDistributedMember primary = advisor.getPrimaryMemberForBucket(bucketId);
            if (!candidates.contains(primary)) {
                return null;
            }
            return primary;
        }
        Set<InternalDistributedMember> bucketOwnersSet = advisor.getBucketOwners(bucketId);
        bucketOwnersSet.retainAll(candidates);
        ArrayList<InternalDistributedMember> members = new ArrayList<InternalDistributedMember>(bucketOwnersSet);
        if (members.isEmpty()) {
            return null;
        }
        return this.getPreferredDataStore(members, alreadyUsed);
    }

    private InternalDistributedMember getPreferredDataStore(Collection<InternalDistributedMember> candidates, Collection<InternalDistributedMember> alreadyUsed) {
        PartitionedRegionDataStore localDataStore;
        boolean forPrimary = alreadyUsed.isEmpty();
        if (forPrimary && this.getForceLocalPrimaries() && (localDataStore = this.partitionedRegion.getDataStore()) != null) {
            return this.partitionedRegion.getMyId();
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        Assert.assertTrue(candidates.size() > 1);
        ArrayList<DataStoreBuckets> stores = this.partitionedRegion.getRegionAdvisor().adviseFilteredDataStores(new HashSet<InternalDistributedMember>(candidates));
        DistributionManager dm = this.partitionedRegion.getDistributionManager();
        InternalDistributedMember localMember = dm.getId();
        PartitionedRegionDataStore localDataStore2 = this.partitionedRegion.getDataStore();
        if (localDataStore2 != null && candidates.contains(localMember)) {
            short bucketCount = localDataStore2.getBucketsManaged();
            int priCount = localDataStore2.getNumberOfPrimaryBucketsManaged();
            int localMaxMemory = this.partitionedRegion.getLocalMaxMemory();
            stores.add(new DataStoreBuckets(localMember, bucketCount, priCount, localMaxMemory));
        }
        if (stores.isEmpty()) {
            return null;
        }
        HashSet<InternalDistributedMember> existingHosts = new HashSet<InternalDistributedMember>();
        for (InternalDistributedMember mem : alreadyUsed) {
            existingHosts.addAll(dm.getMembersInSameZone(mem));
        }
        Comparator comparator = (d1, d2) -> {
            float load2;
            float load1;
            boolean host1Used = existingHosts.contains(d1.memberId());
            boolean host2Used = existingHosts.contains(d2.memberId());
            if (!host1Used && host2Used) {
                return -1;
            }
            if (host1Used && !host2Used) {
                return 1;
            }
            if (forPrimary) {
                load1 = (float)d1.numPrimaries() / (float)d1.localMaxMemoryMB();
                load2 = (float)d2.numPrimaries() / (float)d2.localMaxMemoryMB();
            } else {
                load1 = (float)d1.numBuckets() / (float)d1.localMaxMemoryMB();
                load2 = (float)d2.numBuckets() / (float)d2.localMaxMemoryMB();
            }
            int result = Float.compare(load1, load2);
            if (result == 0) {
                result = d2.localMaxMemoryMB() - d1.localMaxMemoryMB();
            }
            return result;
        };
        stores.sort(comparator);
        if (logger.isDebugEnabled()) {
            logger.debug(this.fancyFormatBucketAllocation("Sorted ", stores, existingHosts));
        }
        DataStoreBuckets bestDataStore = (DataStoreBuckets)stores.get(0);
        ArrayList<DataStoreBuckets> bestStores = new ArrayList<DataStoreBuckets>();
        bestStores.add(bestDataStore);
        boolean allStoresInUse = alreadyUsed.contains(bestDataStore.memberId());
        for (int i = 1; i < stores.size(); ++i) {
            DataStoreBuckets aDataStore = (DataStoreBuckets)stores.get(i);
            if (!allStoresInUse && alreadyUsed.contains(aDataStore.memberId()) || comparator.compare(bestDataStore, aDataStore) != 0) break;
            bestStores.add(aDataStore);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.fancyFormatBucketAllocation("Best Stores ", bestStores, existingHosts));
        }
        int chosen = DISABLE_CREATE_BUCKET_RANDOMNESS ? 0 : PartitionedRegion.RANDOM.nextInt(bestStores.size());
        return ((DataStoreBuckets)bestStores.get(chosen)).memberId();
    }

    void startRedundancyRecovery() {
        this.partitionedRegion.getRegionAdvisor().addMembershipListener(new PRMembershipListener());
        this.scheduleRedundancyRecovery(null);
    }

    private String fancyFormatBucketAllocation(String prefix, Iterable<DataStoreBuckets> dataStores, Collection<InternalDistributedMember> existingStores) {
        StringBuilder logStr = new StringBuilder();
        if (prefix != null) {
            logStr.append(prefix);
        }
        logStr.append("Bucket Allocation for prId=").append(this.partitionedRegion.getPRId()).append(":");
        logStr.append(System.lineSeparator());
        Iterator<DataStoreBuckets> iterator = dataStores.iterator();
        while (iterator.hasNext()) {
            DataStoreBuckets dataStore;
            DataStoreBuckets buckets = dataStore = iterator.next();
            logStr.append(buckets.memberId()).append(": ");
            if (existingStores.contains(buckets.memberId())) {
                logStr.append("+");
            } else {
                logStr.append("-");
            }
            logStr.append(buckets.numPrimaries());
            logStr.append("/");
            logStr.append(buckets.numBuckets() - buckets.numPrimaries());
            logStr.append(System.lineSeparator());
        }
        return logStr.toString();
    }

    private void verifyBucketNodes(Collection<InternalDistributedMember> members, String partitionName) {
        if (members == null || members.isEmpty()) {
            return;
        }
        Set<InternalDistributedMember> availableMembers = this.getAllStores(partitionName);
        Iterator<InternalDistributedMember> iterator = members.iterator();
        while (iterator.hasNext()) {
            InternalDistributedMember node = iterator.next();
            if (availableMembers.contains(node)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("verifyBucketNodes: removing member {}", (Object)node);
            }
            iterator.remove();
            Assert.assertTrue(!members.contains(node), "return value does not contain " + node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRedundancyRecovery(Object failedMemberId) {
        boolean requiresRedundancyRecovery;
        boolean movePrimaries;
        long delay;
        boolean isStartup;
        boolean bl = isStartup = failedMemberId == null;
        if (isStartup) {
            delay = this.partitionedRegion.getPartitionAttributes().getStartupRecoveryDelay();
            movePrimaries = !Boolean.getBoolean("gemfire.DISABLE_MOVE_PRIMARIES_ON_STARTUP");
        } else {
            delay = this.partitionedRegion.getPartitionAttributes().getRecoveryDelay();
            movePrimaries = false;
        }
        boolean bl2 = requiresRedundancyRecovery = delay >= 0L;
        if (!requiresRedundancyRecovery) {
            return;
        }
        if (!this.partitionedRegion.isDataStore()) {
            return;
        }
        RecoveryRunnable task = new RecoveryRunnable(this){

            @Override
            public void run2() {
                try {
                    boolean isFixedPartitionedRegion = PRHARedundancyProvider.this.partitionedRegion.isFixedPartitionedRegion();
                    boolean replaceOfflineData = isFixedPartitionedRegion || !isStartup;
                    RebalanceDirectorAdapter director = isFixedPartitionedRegion ? new FPRDirector(true, movePrimaries) : new CompositeDirector(true, true, false, movePrimaries);
                    PartitionedRegionRebalanceOp rebalance = PRHARedundancyProvider.this.rebalanceOpFactory.create(PRHARedundancyProvider.this.partitionedRegion, false, director, replaceOfflineData, false);
                    long start = PRHARedundancyProvider.this.partitionedRegion.getPrStats().startRecovery();
                    if (isFixedPartitionedRegion) {
                        rebalance.executeFPA();
                    } else {
                        rebalance.execute();
                    }
                    PRHARedundancyProvider.this.partitionedRegion.getPrStats().endRecovery(start);
                    PRHARedundancyProvider.this.recoveryFuture = null;
                    PRHARedundancyProvider.this.providerStartupTask.complete(null);
                }
                catch (CancelException e) {
                    logger.debug("Cache closed while recovery in progress");
                    PRHARedundancyProvider.this.providerStartupTask.completeExceptionally(e);
                }
                catch (RegionDestroyedException e) {
                    logger.debug("Region destroyed while recovery in progress");
                    PRHARedundancyProvider.this.providerStartupTask.completeExceptionally(e);
                }
                catch (Exception e) {
                    logger.error("Unexpected exception during bucket recovery", (Throwable)e);
                    PRHARedundancyProvider.this.providerStartupTask.completeExceptionally(e);
                }
            }
        };
        Object object = this.shutdownLock;
        synchronized (object) {
            if (!this.shutdown) {
                try {
                    if (logger.isDebugEnabled()) {
                        if (isStartup) {
                            logger.debug("{} scheduling redundancy recovery in {} ms", (Object)this.partitionedRegion, (Object)delay);
                        } else {
                            logger.debug("partitionedRegion scheduling redundancy recovery after departure/crash/error in {} in {} ms", failedMemberId, (Object)delay);
                        }
                    }
                    this.recoveryFuture = this.recoveryExecutor.schedule(task, delay, TimeUnit.MILLISECONDS);
                    this.resourceManager.addStartupTask(this.providerStartupTask);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isRedundancyImpaired() {
        int numBuckets = this.partitionedRegion.getPartitionAttributes().getTotalNumBuckets();
        int targetRedundancy = this.partitionedRegion.getPartitionAttributes().getRedundantCopies();
        for (int i = 0; i < numBuckets; ++i) {
            int redundancy = this.partitionedRegion.getRegionAdvisor().getBucketRedundancy(i);
            if ((redundancy >= targetRedundancy || redundancy == -1) && redundancy <= targetRedundancy) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverPersistentBuckets() {
        PartitionedRegion leaderRegion = ColocationHelper.getLeaderRegion(this.partitionedRegion);
        PartitionedRegion persistentLeader = this.getPersistentLeader();
        if (persistentLeader == null) {
            return true;
        }
        if (!ColocationHelper.checkMembersColocation(leaderRegion, leaderRegion.getDistributionManager().getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Skipping persistent recovery of {} because colocation is not complete for {}", (Object)this.partitionedRegion, (Object)leaderRegion);
            }
            return false;
        }
        ProxyBucketRegion[] proxyBucketArray = persistentLeader.getRegionAdvisor().getProxyBucketArray();
        if (proxyBucketArray.length == 0) {
            throw new IllegalStateException("Unexpected empty proxy bucket array");
        }
        for (ProxyBucketRegion proxyBucket : proxyBucketArray) {
            proxyBucket.initializePersistenceAdvisor();
        }
        Set<InternalDistributedMember> peers = this.partitionedRegion.getRegionAdvisor().adviseGeneric();
        MembershipFlushRequest.send(peers, this.partitionedRegion.getDistributionManager(), this.partitionedRegion.getFullPath());
        ArrayList<ProxyBucketRegion> bucketsNotHostedLocally = new ArrayList<ProxyBucketRegion>(proxyBucketArray.length);
        ArrayList<ProxyBucketRegion> bucketsHostedLocally = new ArrayList<ProxyBucketRegion>(proxyBucketArray.length);
        this.createPersistentBucketRecoverer(proxyBucketArray.length);
        for (final ProxyBucketRegion proxyBucket : proxyBucketArray) {
            if (proxyBucket.getPersistenceAdvisor().wasHosting()) {
                RecoveryRunnable recoveryRunnable = new RecoveryRunnable(this){

                    @Override
                    public void run() {
                        try {
                            super.run();
                        }
                        finally {
                            if (PRHARedundancyProvider.this.getPersistentBucketRecoverer() != null) {
                                PRHARedundancyProvider.this.getPersistentBucketRecoverer().countDown();
                            }
                        }
                    }

                    @Override
                    public void run2() {
                        proxyBucket.recoverFromDiskRecursively();
                    }
                };
                LoggingThread recoveryThread = new LoggingThread("Recovery thread for bucket " + proxyBucket.getName(), false, (Runnable)recoveryRunnable);
                recoveryThread.start();
                bucketsHostedLocally.add(proxyBucket);
                continue;
            }
            bucketsNotHostedLocally.add(proxyBucket);
        }
        try {
            for (ProxyBucketRegion proxyBucket : bucketsHostedLocally) {
                proxyBucket.waitForPrimaryPersistentRecovery();
            }
            for (ProxyBucketRegion proxyBucket : bucketsNotHostedLocally) {
                proxyBucket.recoverFromDiskRecursively();
            }
        }
        finally {
            if (this.getPersistentBucketRecoverer() != null) {
                this.getPersistentBucketRecoverer().countDown(bucketsNotHostedLocally.size());
            }
        }
        return true;
    }

    @VisibleForTesting
    void createPersistentBucketRecoverer(int proxyBuckets) {
        this.persistentBucketRecoverer = this.persistentBucketRecovererFunction.apply(this, proxyBuckets);
        this.persistentBucketRecoverer.startLoggingThread();
    }

    @VisibleForTesting
    PersistentBucketRecoverer getPersistentBucketRecoverer() {
        return this.persistentBucketRecoverer;
    }

    private PartitionedRegion getPersistentLeader() {
        PartitionedRegion leader = ColocationHelper.getLeaderRegion(this.partitionedRegion);
        return this.findPersistentRegionRecursively(leader);
    }

    private PartitionedRegion findPersistentRegionRecursively(PartitionedRegion partitionedRegion) {
        if (partitionedRegion.getDataPolicy().withPersistence()) {
            return partitionedRegion;
        }
        for (PartitionedRegion child : ColocationHelper.getColocatedChildRegions(partitionedRegion)) {
            PartitionedRegion leader = this.findPersistentRegionRecursively(child);
            if (leader == null) continue;
            return leader;
        }
        return null;
    }

    void scheduleCreateMissingBuckets() {
        if (this.partitionedRegion.getColocatedWith() != null && ColocationHelper.isColocationComplete(this.partitionedRegion)) {
            CreateMissingBucketsTask task = new CreateMissingBucketsTask(this);
            InternalResourceManager resourceManager = this.partitionedRegion.getGemFireCache().getInternalResourceManager();
            resourceManager.getExecutor().execute(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdown = true;
            ScheduledFuture<?> recoveryFuture = this.recoveryFuture;
            if (recoveryFuture != null) {
                recoveryFuture.cancel(false);
                this.recoveryExecutor.purge();
            }
        }
    }

    public InternalPRInfo buildPartitionedRegionInfo(boolean internal, LoadProbe loadProbe) {
        PartitionedRegion pr = this.partitionedRegion;
        if (pr == null) {
            return null;
        }
        int configuredBucketCount = pr.getTotalNumberOfBuckets();
        int createdBucketCount = pr.getRegionAdvisor().getCreatedBucketsCount();
        int lowRedundancyBucketCount = pr.getRedundancyTracker().getLowRedundancyBuckets();
        int configuredRedundantCopies = pr.getRedundantCopies();
        int actualRedundantCopies = pr.getRedundancyTracker().getActualRedundancy();
        PartitionedRegionDataStore dataStore = pr.getDataStore();
        Set<InternalDistributedMember> datastores = pr.getRegionAdvisor().adviseDataStore();
        TreeSet<InternalPartitionDetails> memberDetails = new TreeSet<InternalPartitionDetails>();
        OfflineMemberDetails offlineMembers = null;
        boolean fetchOfflineMembers = false;
        if (dataStore != null) {
            memberDetails.add(this.buildPartitionMemberDetails(internal, loadProbe));
            offlineMembers = this.fetchOfflineMembers();
        } else {
            fetchOfflineMembers = true;
        }
        if (!datastores.isEmpty()) {
            FetchPartitionDetailsMessage.FetchPartitionDetailsResponse response = FetchPartitionDetailsMessage.send(datastores, pr, internal, fetchOfflineMembers, loadProbe);
            memberDetails.addAll(response.waitForResponse());
            if (fetchOfflineMembers) {
                offlineMembers = response.getOfflineMembers();
            }
        }
        String colocatedWithPath = pr.getColocatedWith();
        return new PartitionRegionInfoImpl(pr.getFullPath(), configuredBucketCount, createdBucketCount, lowRedundancyBucketCount, configuredRedundantCopies, actualRedundantCopies, memberDetails, colocatedWithPath, offlineMembers);
    }

    public OfflineMemberDetailsImpl fetchOfflineMembers() {
        ProxyBucketRegion[] proxyBuckets = this.partitionedRegion.getRegionAdvisor().getProxyBucketArray();
        Set[] offlineMembers = new Set[proxyBuckets.length];
        for (int i = 0; i < proxyBuckets.length; ++i) {
            ProxyBucketRegion proxyBucket = proxyBuckets[i];
            if (this.partitionedRegion.getDataPolicy().withPersistence()) {
                Set<PersistentMemberID> persistedMembers = proxyBucket.getPersistenceAdvisor().getMissingMembers();
                if (persistedMembers == null) {
                    persistedMembers = Collections.emptySet();
                }
                offlineMembers[i] = persistedMembers;
                continue;
            }
            offlineMembers[i] = Collections.emptySet();
        }
        return new OfflineMemberDetailsImpl(offlineMembers);
    }

    public InternalPartitionDetails buildPartitionMemberDetails(boolean internal, LoadProbe loadProbe) {
        PartitionMemberInfoImpl localDetails;
        PartitionedRegion pr = this.partitionedRegion;
        PartitionedRegionDataStore dataStore = pr.getDataStore();
        if (dataStore == null) {
            return null;
        }
        long size = 0L;
        InternalDistributedMember localMember = pr.getMyId();
        int configuredBucketCount = pr.getTotalNumberOfBuckets();
        long[] bucketSizes = new long[configuredBucketCount];
        Map<Integer, Integer> bucketSizeMap = dataStore.getSizeLocally();
        for (Map.Entry<Integer, Integer> me : bucketSizeMap.entrySet()) {
            long bucketSize;
            int bid = me.getKey();
            bucketSizes[bid] = bucketSize = dataStore.getBucketSize(bid);
            size += bucketSize;
        }
        if (internal) {
            this.waitForPersistentBucketRecoveryOrClose();
            PRLoad prLoad = loadProbe.getLoad(pr);
            localDetails = new PartitionMemberInfoImpl(localMember, (long)pr.getLocalMaxMemory() * 1024L * 1024L, size, dataStore.getBucketsManaged(), dataStore.getNumberOfPrimaryBucketsManaged(), prLoad, bucketSizes);
        } else {
            localDetails = new PartitionMemberInfoImpl(localMember, (long)pr.getLocalMaxMemory() * 1024L * 1024L, size, dataStore.getBucketsManaged(), dataStore.getNumberOfPrimaryBucketsManaged());
        }
        return localDetails;
    }

    private void waitForPersistentBucketRecoveryOrClose() {
        if (this.getPersistentBucketRecoverer() != null) {
            this.getPersistentBucketRecoverer().await(100L, TimeUnit.MILLISECONDS);
        }
        List<PartitionedRegion> colocatedRegions = ColocationHelper.getColocatedChildRegions(this.partitionedRegion);
        for (PartitionedRegion child : colocatedRegions) {
            child.getRedundancyProvider().waitForPersistentBucketRecoveryOrClose();
        }
    }

    void waitForPersistentBucketRecovery() {
        if (this.getPersistentBucketRecoverer() != null) {
            this.getPersistentBucketRecoverer().await();
        }
    }

    public boolean isPersistentRecoveryComplete() {
        if (!ColocationHelper.checkMembersColocation(this.partitionedRegion, this.partitionedRegion.getMyId())) {
            return false;
        }
        if (this.getPersistentBucketRecoverer() != null && !this.getPersistentBucketRecoverer().hasRecoveryCompleted()) {
            return false;
        }
        Map<String, PartitionedRegion> colocatedRegions = ColocationHelper.getAllColocationRegions(this.partitionedRegion);
        for (PartitionedRegion region : colocatedRegions.values()) {
            PRHARedundancyProvider redundancyProvider = region.getRedundancyProvider();
            if (redundancyProvider.getPersistentBucketRecoverer() == null || redundancyProvider.getPersistentBucketRecoverer().hasRecoveryCompleted()) continue;
            return false;
        }
        return true;
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.partitionedRegion.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }

    private static class ArrayListWithClearState<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;
        private volatile boolean wasCleared;

        private ArrayListWithClearState() {
        }

        private boolean wasCleared() {
            return this.wasCleared;
        }

        @Override
        public void clear() {
            super.clear();
            this.wasCleared = true;
        }
    }

    private static class BucketMembershipObserverResults {
        private final boolean problematicDeparture;
        final InternalDistributedMember primary;

        BucketMembershipObserverResults(boolean re, InternalDistributedMember p) {
            this.problematicDeparture = re;
            this.primary = p;
        }

        public String toString() {
            return "pDepart:" + this.problematicDeparture + " primary:" + this.primary;
        }

        static /* synthetic */ boolean access$700(BucketMembershipObserverResults x0) {
            return x0.problematicDeparture;
        }
    }

    private static class ManageBucketRsp {
        @Immutable
        private static final ManageBucketRsp NO = new ManageBucketRsp("NO");
        @Immutable
        private static final ManageBucketRsp YES = new ManageBucketRsp("YES");
        @Immutable
        private static final ManageBucketRsp NO_INITIALIZING = new ManageBucketRsp("NO_INITIALIZING");
        @Immutable
        private static final ManageBucketRsp CLOSED = new ManageBucketRsp("CLOSED");
        private final String name;

        private ManageBucketRsp(String name) {
            this.name = name;
        }

        private boolean isAcceptance() {
            return this == YES;
        }

        public String toString() {
            return "ManageBucketRsp(" + this.name + ")";
        }

        private static ManageBucketRsp valueOf(boolean managed) {
            return managed ? YES : NO;
        }
    }

    private class PRMembershipListener
    implements MembershipListener {
        private PRMembershipListener() {
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            try {
                InternalDistributedMember member = PRHARedundancyProvider.this.partitionedRegion.getSystem().getDistributedMember();
                if (logger.isDebugEnabled()) {
                    logger.debug("MembershipListener invoked on DistributedMember = {} for failed memberId = {}", (Object)member, (Object)id);
                }
                if (!(PRHARedundancyProvider.this.partitionedRegion.isCacheClosing() || PRHARedundancyProvider.this.partitionedRegion.isDestroyed() || ((Object)member).equals(id))) {
                    Runnable postRecoveryTask = null;
                    if (!PRHARedundancyProvider.this.partitionedRegion.isFixedPartitionedRegion()) {
                        postRecoveryTask = () -> PRHARedundancyProvider.this.scheduleRedundancyRecovery(id);
                    }
                    PartitionedRegionHelper.cleanUpMetaDataForRegion(PRHARedundancyProvider.this.partitionedRegion.getCache(), PRHARedundancyProvider.this.partitionedRegion.getRegionIdentifier(), id, postRecoveryTask);
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
        }
    }

    private class BucketMembershipObserver
    implements MembershipListener {
        private final Bucket bucketToMonitor;
        private final AtomicInteger arrivals = new AtomicInteger(0);
        private final AtomicBoolean departures = new AtomicBoolean(false);

        private BucketMembershipObserver(Bucket bucketToMonitor) {
            this.bucketToMonitor = bucketToMonitor;
        }

        private BucketMembershipObserver beginMonitoring() {
            int profilesPresent = this.bucketToMonitor.getBucketAdvisor().addMembershipListenerAndAdviseGeneric(this).size();
            this.arrivals.addAndGet(profilesPresent);
            return this;
        }

        private void stopMonitoring() {
            this.bucketToMonitor.getBucketAdvisor().removeMembershipListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
            if (logger.isDebugEnabled()) {
                logger.debug("Observer for bucket {} member joined {}", (Object)this.bucketToMonitor, (Object)id);
            }
            BucketMembershipObserver bucketMembershipObserver = this;
            synchronized (bucketMembershipObserver) {
                this.arrivals.addAndGet(1);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            if (logger.isDebugEnabled()) {
                logger.debug("Observer for bucket {} member departed {}", (Object)this.bucketToMonitor, (Object)id);
            }
            BucketMembershipObserver bucketMembershipObserver = this;
            synchronized (bucketMembershipObserver) {
                this.departures.getAndSet(true);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BucketMembershipObserverResults waitForOwnersGetPrimary(int expectedCount, Collection<InternalDistributedMember> expectedOwners, String partitionName) throws InterruptedException {
            boolean problematicDeparture = false;
            BucketMembershipObserver bucketMembershipObserver = this;
            synchronized (bucketMembershipObserver) {
                while (true) {
                    this.bucketToMonitor.getCancelCriterion().checkCancelInProgress(null);
                    boolean oldDepartures = this.departures.get();
                    if (oldDepartures) {
                        PRHARedundancyProvider.this.verifyBucketNodes(expectedOwners, partitionName);
                        if (expectedOwners.isEmpty()) {
                            problematicDeparture = true;
                        }
                        this.arrivals.set(expectedOwners.size());
                        this.departures.set(false);
                        if (!problematicDeparture || !logger.isDebugEnabled()) break;
                        logger.debug("Bucket observer found departed members - retrying");
                        break;
                    }
                    int oldArrivals = this.arrivals.get();
                    if (oldArrivals >= expectedCount) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Waiting for bucket {} to finish being created", (Object)PRHARedundancyProvider.this.partitionedRegion.bucketStringForLogs(this.bucketToMonitor.getId()));
                    }
                    PRHARedundancyProvider.this.partitionedRegion.checkReadiness();
                    int creationWaitMillis = 5000;
                    this.wait(creationWaitMillis);
                    if (oldArrivals != this.arrivals.get() || oldDepartures != this.departures.get()) continue;
                    logger.warn("Time out waiting {} ms for creation of bucket for partitioned region {}. Members requested to create the bucket are: {}", (Object)creationWaitMillis, (Object)PRHARedundancyProvider.this.partitionedRegion.getFullPath(), expectedOwners);
                }
            }
            if (problematicDeparture) {
                return new BucketMembershipObserverResults(true, null);
            }
            InternalDistributedMember primary = this.bucketToMonitor.getBucketAdvisor().getPrimary();
            if (primary == null) {
                return new BucketMembershipObserverResults(true, null);
            }
            return new BucketMembershipObserverResults(false, primary);
        }

        static /* synthetic */ BucketMembershipObserver access$400(BucketMembershipObserver x0) {
            return x0.beginMonitoring();
        }

        static /* synthetic */ BucketMembershipObserverResults access$600(BucketMembershipObserver x0, int x1, Collection x2, String x3) throws InterruptedException {
            return x0.waitForOwnersGetPrimary(x1, x2, x3);
        }

        static /* synthetic */ void access$800(BucketMembershipObserver x0) {
            x0.stopMonitoring();
        }
    }
}

