/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class DiskStoreID
implements VersionSource<DiskStoreID>,
Serializable {
    private static final long serialVersionUID = 1L;
    private long mostSig;
    private long leastSig;

    public DiskStoreID(UUID uuid) {
        this.mostSig = uuid.getMostSignificantBits();
        this.leastSig = uuid.getLeastSignificantBits();
    }

    public DiskStoreID(long diskStoreIdHigh, long diskStoreIdLow) {
        this.mostSig = diskStoreIdHigh;
        this.leastSig = diskStoreIdLow;
    }

    public DiskStoreID() {
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeLong(this.mostSig);
        out.writeLong(this.leastSig);
    }

    @Override
    public void writeEssentialData(DataOutput out) throws IOException {
        out.writeLong(this.mostSig);
        out.writeLong(this.leastSig);
    }

    public static DiskStoreID readEssentialData(DataInput in) throws IOException {
        long mostSig = in.readLong();
        long leastSig = in.readLong();
        return new DiskStoreID(mostSig, leastSig);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.mostSig = in.readLong();
        this.leastSig = in.readLong();
    }

    @Override
    public int compareTo(DiskStoreID tagID) {
        if (tagID == null) {
            return 1;
        }
        int result = Long.signum(this.mostSig - tagID.mostSig);
        if (result != 0) {
            result = Long.signum(this.leastSig - tagID.leastSig);
        }
        return result;
    }

    public long getMostSignificantBits() {
        return this.mostSig;
    }

    public long getLeastSignificantBits() {
        return this.leastSig;
    }

    public static DiskStoreID random() {
        return new DiskStoreID(UUID.randomUUID());
    }

    public int getDSFID() {
        return 2133;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.leastSig ^ this.leastSig >>> 32);
        result = 31 * result + (int)(this.mostSig ^ this.mostSig >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskStoreID other = (DiskStoreID)obj;
        if (this.leastSig != other.leastSig) {
            return false;
        }
        return this.mostSig == other.mostSig;
    }

    public String toString() {
        return Long.toHexString(this.mostSig) + "-" + Long.toHexString(this.leastSig);
    }

    public UUID toUUID() {
        return new UUID(this.mostSig, this.leastSig);
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public String abbrev() {
        return Long.toHexString(this.mostSig).substring(8);
    }

    @Override
    public boolean isDiskStoreId() {
        return true;
    }
}

