/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.io.IOException;
import java.util.Arrays;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.internal.offheap.DataType;
import org.apache.geode.internal.offheap.MemoryAllocatorImpl;
import org.apache.geode.internal.offheap.MemoryBlock;
import org.apache.geode.internal.offheap.OffHeapStoredObject;

public class MemoryBlockNode
implements MemoryBlock {
    private final MemoryAllocatorImpl ma;
    private final MemoryBlock block;

    MemoryBlockNode(MemoryAllocatorImpl ma, MemoryBlock block) {
        this.ma = ma;
        this.block = block;
    }

    @Override
    public MemoryBlock.State getState() {
        return this.block.getState();
    }

    @Override
    public long getAddress() {
        return this.block.getAddress();
    }

    @Override
    public int getBlockSize() {
        return this.block.getBlockSize();
    }

    @Override
    public MemoryBlock getNextBlock() {
        return this.ma.getMemoryInspector().getBlockAfter(this);
    }

    @Override
    public int getSlabId() {
        return this.ma.findSlab(this.getAddress());
    }

    @Override
    public int getFreeListId() {
        return this.block.getFreeListId();
    }

    @Override
    public int getRefCount() {
        return this.block.getRefCount();
    }

    @Override
    public String getDataType() {
        if (this.block.getDataType() != null) {
            return this.block.getDataType();
        }
        if (!this.isSerialized()) {
            if (this.isCompressed()) {
                return "compressed byte[" + ((OffHeapStoredObject)this.block).getDataSize() + "]";
            }
            return "byte[" + ((OffHeapStoredObject)this.block).getDataSize() + "]";
        }
        if (this.isCompressed()) {
            return "compressed object of size " + ((OffHeapStoredObject)this.block).getDataSize();
        }
        byte[] bytes = ((OffHeapStoredObject)this.block).getRawBytes();
        return DataType.getDataType(bytes);
    }

    @Override
    public boolean isSerialized() {
        return this.block.isSerialized();
    }

    @Override
    public boolean isCompressed() {
        return this.block.isCompressed();
    }

    @Override
    public Object getDataValue() {
        String dataType = this.getDataType();
        if (dataType == null || dataType.equals("N/A")) {
            return null;
        }
        if (this.isCompressed()) {
            return ((OffHeapStoredObject)this.block).getCompressedBytes();
        }
        if (!this.isSerialized()) {
            return ((OffHeapStoredObject)this.block).getRawBytes();
        }
        try {
            byte[] bytes = ((OffHeapStoredObject)this.block).getRawBytes();
            return DataSerializer.readObject(DataType.getDataInput(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "IOException:" + e.getMessage();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return "ClassNotFoundException:" + e.getMessage();
        }
        catch (CacheClosedException e) {
            e.printStackTrace();
            return "CacheClosedException:" + e.getMessage();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(MemoryBlock.class.getSimpleName());
        sb.append("{");
        sb.append("MemoryAddress=").append(this.getAddress());
        sb.append(", State=").append((Object)this.getState());
        sb.append(", BlockSize=").append(this.getBlockSize());
        sb.append(", SlabId=").append(this.getSlabId());
        sb.append(", FreeListId=");
        if (this.getState() == MemoryBlock.State.UNUSED || this.getState() == MemoryBlock.State.ALLOCATED) {
            sb.append("NONE");
        } else if (this.getFreeListId() == -1) {
            sb.append("HUGE");
        } else {
            sb.append(this.getFreeListId());
        }
        sb.append(", RefCount=").append(this.getRefCount());
        sb.append(", isSerialized=").append(this.isSerialized());
        sb.append(", isCompressed=").append(this.isCompressed());
        sb.append(", DataType=").append(this.getDataType());
        sb.append(", DataValue=");
        Object dataValue = this.getDataValue();
        if (dataValue instanceof byte[]) {
            byte[] ba = (byte[])dataValue;
            if (ba.length < 1024) {
                sb.append(Arrays.toString(ba));
            } else {
                sb.append("<byte array of length " + ba.length + ">");
            }
        } else {
            sb.append(dataValue);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof MemoryBlockNode) {
            o = ((MemoryBlockNode)o).block;
        }
        return this.block.equals(o);
    }

    public int hashCode() {
        return this.block.hashCode();
    }
}

