/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.security.shiro;

import java.io.Serializable;
import org.apache.geode.internal.security.shiro.GeodeAuthenticationToken;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class CustomAuthRealm
extends AuthorizingRealm {
    private static final String REALM_NAME = "CUSTOMAUTHREALM";
    private SecurityManager securityManager = null;

    public CustomAuthRealm(SecurityManager securityManager) {
        this.securityManager = securityManager;
        this.setAuthenticationTokenClass(GeodeAuthenticationToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        GeodeAuthenticationToken authToken = (GeodeAuthenticationToken)token;
        Object principal = this.securityManager.authenticate(authToken.getProperties());
        return new SimpleAuthenticationInfo(principal, authToken.getCredentials(), REALM_NAME);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        ResourcePermission context = (ResourcePermission)permission;
        Serializable principal = (Serializable)principals.getPrimaryPrincipal();
        return this.securityManager.authorize(principal, context);
    }
}

