/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.management.internal.MBeanProxyInvocationHandler;
import org.apache.geode.management.internal.OpenMethod;
import org.apache.geode.management.internal.OpenTypeUtil;

public class MXBeanProxyInvocationHandler {
    @Immutable
    private static final Comparator<Method> METHOD_ORDER_COMPARATOR = new MethodOrder();
    private final ObjectName objectName;
    private final MBeanProxyInvocationHandler proxyHandler;
    private final Map<Method, MethodHandler> methodHandlerMap;

    MXBeanProxyInvocationHandler(ObjectName objectName, Class<?> mxbeanInterface, MBeanProxyInvocationHandler proxyHandler) throws IllegalArgumentException {
        this(objectName, mxbeanInterface, proxyHandler, OpenTypeUtil.newMap());
    }

    private MXBeanProxyInvocationHandler(ObjectName objectName, Class<?> mxbeanInterface, MBeanProxyInvocationHandler proxyHandler, Map<Method, MethodHandler> methodHandlerMap) throws IllegalArgumentException {
        if (mxbeanInterface == null) {
            throw new IllegalArgumentException("mxbeanInterface must not be null");
        }
        this.objectName = objectName;
        this.proxyHandler = proxyHandler;
        this.methodHandlerMap = methodHandlerMap;
        this.initHandlers(mxbeanInterface);
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws InvalidObjectException, OpenDataException, MBeanException {
        MethodHandler handler = this.methodHandlerMap.get(method);
        OpenMethod convertingMethod = handler.getConvertingMethod();
        Object[] openArgs = convertingMethod.toOpenParameters(arguments);
        Object result = handler.invoke(proxy, method, openArgs);
        return convertingMethod.fromOpenReturnValue(result);
    }

    private void initHandlers(Class<?> mxbeanInterface) {
        Method[] methodArray = mxbeanInterface.getMethods();
        List<Method> methods = MXBeanProxyInvocationHandler.eliminateCovariantMethods(methodArray);
        for (Method method : methods) {
            String name = method.getName();
            String attributeName = "";
            if (name.startsWith("get")) {
                attributeName = name.substring(3);
            } else if (name.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
                attributeName = name.substring(2);
            }
            if (!attributeName.isEmpty() && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                this.methodHandlerMap.put(method, new GetterHandler(attributeName, OpenMethod.from(method)));
                continue;
            }
            if (name.startsWith("set") && name.length() > 3 && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE) {
                this.methodHandlerMap.put(method, new SetterHandler(attributeName, OpenMethod.from(method)));
                continue;
            }
            this.methodHandlerMap.put(method, new OpHandler(attributeName, OpenMethod.from(method)));
        }
    }

    private static List<Method> eliminateCovariantMethods(Method[] methodArray) {
        int methodCount = methodArray.length;
        Method[] sorted = (Method[])methodArray.clone();
        Arrays.sort(sorted, METHOD_ORDER_COMPARATOR);
        Set<Method> overridden = OpenTypeUtil.newSet();
        for (int i = 1; i < methodCount; ++i) {
            Method m0 = sorted[i - 1];
            Method m1 = sorted[i];
            if (!m0.getName().equals(m1.getName()) || !Arrays.equals(m0.getParameterTypes(), m1.getParameterTypes())) continue;
            overridden.add(m0);
        }
        List<Method> methods = OpenTypeUtil.newList(Arrays.asList(methodArray));
        methods.removeAll(overridden);
        return methods;
    }

    private static class MethodOrder
    implements Comparator<Method> {
        private MethodOrder() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?> bret;
            Object[] bparams;
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Object[] aparams = a.getParameterTypes();
            if (aparams.length != (bparams = b.getParameterTypes()).length) {
                return aparams.length - bparams.length;
            }
            if (!Arrays.equals(aparams, bparams)) {
                return Arrays.toString(aparams).compareTo(Arrays.toString(bparams));
            }
            Class<?> aret = a.getReturnType();
            if (aret == (bret = b.getReturnType())) {
                return 0;
            }
            if (aret.isAssignableFrom(bret)) {
                return -1;
            }
            return 1;
        }
    }

    private class OpHandler
    extends MethodHandler {
        private OpHandler(String operationName, OpenMethod convertingMethod) {
            super(operationName, convertingMethod);
        }

        @Override
        Object invoke(Object proxy, Method method, Object[] arguments) throws MBeanException {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String[] signature = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                signature[i] = parameterTypes[i].getName();
            }
            return MXBeanProxyInvocationHandler.this.proxyHandler.delegateToFunctionService(MXBeanProxyInvocationHandler.this.objectName, methodName, arguments, signature);
        }
    }

    private class SetterHandler
    extends MethodHandler {
        private SetterHandler(String attributeName, OpenMethod convertingMethod) {
            super(attributeName, convertingMethod);
        }

        @Override
        Object invoke(Object proxy, Method method, Object[] arguments) throws MBeanException {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            String[] signature = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                signature[i] = parameterTypes[i].getName();
            }
            return MXBeanProxyInvocationHandler.this.proxyHandler.delegateToFunctionService(MXBeanProxyInvocationHandler.this.objectName, methodName, arguments, signature);
        }
    }

    private class GetterHandler
    extends MethodHandler {
        private GetterHandler(String attributeName, OpenMethod convertingMethod) {
            super(attributeName, convertingMethod);
        }

        @Override
        Object invoke(Object proxy, Method method, Object[] arguments) throws MBeanException {
            String methodName = method.getName();
            String attributeName = "";
            if (methodName.startsWith("get")) {
                attributeName = methodName.substring(3);
            } else if (methodName.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
                attributeName = methodName.substring(2);
            }
            return MXBeanProxyInvocationHandler.this.proxyHandler.delegateToObjectState(attributeName);
        }
    }

    private static abstract class MethodHandler {
        private final String name;
        private final OpenMethod convertingMethod;

        MethodHandler(String name, OpenMethod convertingMethod) {
            this.name = name;
            this.convertingMethod = convertingMethod;
        }

        String getName() {
            return this.name;
        }

        abstract Object invoke(Object var1, Method var2, Object[] var3) throws MBeanException;

        private OpenMethod getConvertingMethod() {
            return this.convertingMethod;
        }
    }
}

