/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.sink;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.geode.cache.Region;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRecords {
    private static final Logger logger = LoggerFactory.getLogger(BatchRecords.class);
    private final HashMap<Object, Object> updateMap;
    private final ArrayList<Object> removeList;

    public BatchRecords() {
        this(new HashMap<Object, Object>(), new ArrayList<Object>());
    }

    public BatchRecords(HashMap<Object, Object> updateMap, ArrayList<Object> removeList) {
        this.updateMap = updateMap;
        this.removeList = removeList;
    }

    public void addRemoveOperation(SinkRecord record) {
        if (this.updateMap.containsKey(record.key())) {
            this.updateMap.remove(record.key());
        } else {
            this.removeList.add(record.key());
        }
    }

    public void addUpdateOperation(SinkRecord record, boolean nullValuesMeansRemove) {
        if (nullValuesMeansRemove) {
            this.removeList.remove(record.key());
        }
        this.updateMap.put(record.key(), record.value());
    }

    public void executeOperations(Region<Object, Object> region) {
        if (region != null) {
            region.putAll(this.updateMap);
            region.removeAll(this.removeList);
        } else {
            logger.info("Unable to locate a proxy region. Value is null");
        }
    }
}

