/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka;

import java.util.List;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqResults;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.kafka.LocatorHostPort;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeContext {
    private ClientCache clientCache;
    private static final Logger logger = LoggerFactory.getLogger(GeodeContext.class);

    public ClientCache connectClient(List<LocatorHostPort> locatorHostPortList, String durableClientId, String durableClientTimeout, String securityAuthInit, String securityUserName, String securityPassword, boolean usesSecurity) {
        this.clientCache = this.createClientCache(locatorHostPortList, durableClientId, durableClientTimeout, securityAuthInit, securityUserName, securityPassword, usesSecurity);
        return this.clientCache;
    }

    public ClientCache connectClient(List<LocatorHostPort> locatorHostPortList, String securityAuthInit, String securityUserName, String securityPassword, boolean usesSecurity) {
        this.clientCache = this.createClientCache(locatorHostPortList, "", "", securityAuthInit, securityUserName, securityPassword, usesSecurity);
        return this.clientCache;
    }

    public ClientCache getClientCache() {
        return this.clientCache;
    }

    public ClientCache createClientCache(List<LocatorHostPort> locators, String durableClientName, String durableClientTimeOut, String securityAuthInit, String securityUserName, String securityPassword, boolean usesSecurity) {
        try {
            ClientCacheFactory ccf = new ClientCacheFactory();
            ccf.setPdxReadSerialized(true);
            if (usesSecurity) {
                if (securityUserName != null && securityPassword != null) {
                    ccf.set("security-username", securityUserName);
                    ccf.set("security-password", securityPassword);
                }
                ccf.set("security-client-auth-init", securityAuthInit);
            }
            if (!durableClientName.equals("")) {
                ccf.set("durable-client-id", durableClientName).set("durable-client-timeout", durableClientTimeOut);
            }
            ccf.setPoolSubscriptionEnabled(true);
            for (LocatorHostPort locator : locators) {
                ccf.addPoolLocator(locator.getHostName(), locator.getPort());
            }
            return ccf.create();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to create an client cache connected to Apache Geode cluster");
        }
    }

    public CqQuery newCq(String name, String query, CqAttributes cqAttributes, boolean isDurable) throws ConnectException {
        try {
            CqQuery cq = this.clientCache.getQueryService().newCq(name, query, cqAttributes, isDurable);
            cq.execute();
            return cq;
        }
        catch (CqException | CqExistsException | RegionNotFoundException e) {
            throw new ConnectException(e);
        }
    }

    public <E> CqResults<E> newCqWithInitialResults(String name, String query, CqAttributes cqAttributes, boolean isDurable) throws ConnectException {
        try {
            CqQuery cq = this.clientCache.getQueryService().newCq(name, query, cqAttributes, isDurable);
            return cq.executeWithInitialResults();
        }
        catch (CqException | CqExistsException | RegionNotFoundException e) {
            throw new ConnectException(e);
        }
    }

    public void close(boolean keepAlive) {
        this.clientCache.close(keepAlive);
    }
}

