/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class SemiAutoRebalancer
extends AbstractRebalancer {
    private static final Logger LOG = Logger.getLogger(SemiAutoRebalancer.class);

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }

    @Override
    public Map<String, String> computeAutoBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, List<String> instancePreferenceList, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition, boolean isResourceEnabled) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (instancePreferenceList == null || !instancePreferenceList.contains(instance)) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (!disabledInstancesForPartition.contains(instance) && isResourceEnabled || currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name())) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (instancePreferenceList == null) {
            return instanceStateMap;
        }
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        boolean[] assigned = new boolean[instancePreferenceList.size()];
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        Set<String> secondTopStates = stateModelDef.getSecondTopStates();
        String topState = statesPriorityList.get(0);
        int occupiedTopState = 0;
        for (String currentState : currentStateMap.values()) {
            if (!currentState.equals(topState)) continue;
            ++occupiedTopState;
        }
        block4: for (String state : statesPriorityList) {
            String num = stateModelDef.getNumInstancesPerState(state);
            int stateCount = -1;
            if ("N".equals(num)) {
                HashSet<String> liveAndEnabled = new HashSet<String>(liveInstancesMap.keySet());
                liveAndEnabled.removeAll(disabledInstancesForPartition);
                stateCount = isResourceEnabled ? liveAndEnabled.size() : 0;
            } else if ("R".equals(num)) {
                stateCount = instancePreferenceList.size();
            } else {
                try {
                    stateCount = Integer.parseInt(num);
                }
                catch (Exception e) {
                    LOG.error((Object)("Invalid count for state:" + state + " ,count=" + num));
                }
            }
            if (stateCount <= -1) continue;
            int count = 0;
            for (int i = 0; i < instancePreferenceList.size(); ++i) {
                String currentState;
                String instanceName = instancePreferenceList.get(i);
                boolean notInErrorState = currentStateMap == null || currentStateMap.get(instanceName) == null || !currentStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString());
                boolean enabled = !disabledInstancesForPartition.contains(instanceName) && isResourceEnabled;
                String string = currentState = currentStateMap == null || currentStateMap.get(instanceName) == null ? stateModelDef.getInitialState() : currentStateMap.get(instanceName);
                if (!liveInstancesMap.containsKey(instanceName) || assigned[i] || !notInErrorState || !enabled || state.equals(topState) && stateCount - occupiedTopState <= 0 && !currentState.equals(topState) && !secondTopStates.contains(currentState)) continue;
                instanceStateMap.put(instanceName, state);
                assigned[i] = true;
                ++occupiedTopState;
                if (++count == stateCount) continue block4;
            }
        }
        return instanceStateMap;
    }
}

