/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.ParticipantHistory;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.task.TaskPartitionState;
import org.apache.log4j.Logger;

public class ClusterDataCache {
    private static final String IDEAL_STATE_RULE_PREFIX = "IdealStateRule!";
    ClusterConfig _clusterConfig;
    Map<String, LiveInstance> _liveInstanceMap;
    Map<String, LiveInstance> _liveInstanceCacheMap;
    Map<String, IdealState> _idealStateMap;
    Map<String, IdealState> _idealStateCacheMap;
    Map<String, StateModelDefinition> _stateModelDefMap;
    Map<String, InstanceConfig> _instanceConfigMap;
    Map<String, InstanceConfig> _instanceConfigCacheMap;
    Map<String, Long> _instanceOfflineTimeMap;
    Map<String, ResourceConfig> _resourceConfigMap;
    Map<String, ResourceConfig> _resourceConfigCacheMap;
    Map<String, ClusterConstraints> _constraintMap;
    Map<String, Map<String, Map<String, CurrentState>>> _currentStateMap;
    Map<String, Map<String, Message>> _messageMap;
    Map<String, Map<String, String>> _idealStateRuleMap;
    Map<String, Map<String, Message>> _messageCache = Maps.newHashMap();
    Map<String, Integer> _participantActiveTaskCount = new HashMap<String, Integer>();
    boolean _init = true;
    boolean _updateInstanceOfflineTime = true;
    private static final Logger LOG = Logger.getLogger((String)ClusterDataCache.class.getName());

    public synchronized boolean refresh(HelixDataAccessor accessor) {
        LOG.info((Object)"START: ClusterDataCache.refresh()");
        long startTime = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (this._init) {
            this._idealStateCacheMap = accessor.getChildValuesMap(keyBuilder.idealStates());
            this._liveInstanceCacheMap = accessor.getChildValuesMap(keyBuilder.liveInstances());
            this._instanceConfigCacheMap = accessor.getChildValuesMap(keyBuilder.instanceConfigs());
        }
        this._idealStateMap = Maps.newHashMap(this._idealStateCacheMap);
        this._liveInstanceMap = Maps.newHashMap(this._liveInstanceCacheMap);
        this._instanceConfigMap = Maps.newHashMap(this._instanceConfigCacheMap);
        this._resourceConfigMap = accessor.getChildValuesMap(keyBuilder.resourceConfigs());
        this._stateModelDefMap = accessor.getChildValuesMap(keyBuilder.stateModelDefs());
        this._constraintMap = accessor.getChildValuesMap(keyBuilder.constraints());
        if (this._init || this._updateInstanceOfflineTime) {
            this.updateOfflineInstanceHistory(accessor);
        }
        if (LOG.isTraceEnabled()) {
            for (LiveInstance instance : this._liveInstanceMap.values()) {
                LOG.trace((Object)("live instance: " + instance.getInstanceName() + " " + instance.getSessionId()));
            }
        }
        HashMap<String, HashMap> msgMap = new HashMap<String, HashMap>();
        LinkedList newMessageKeys = Lists.newLinkedList();
        long purgeSum = 0L;
        for (String instanceName : this._liveInstanceMap.keySet()) {
            HashMap cachedMap = this._messageCache.get(instanceName);
            if (cachedMap == null) {
                cachedMap = Maps.newHashMap();
                this._messageCache.put(instanceName, cachedMap);
            }
            msgMap.put(instanceName, cachedMap);
            HashSet messageNames = Sets.newHashSet(accessor.getChildNames(keyBuilder.messages(instanceName)));
            long purgeStart = System.currentTimeMillis();
            Iterator cachedNamesIter = cachedMap.keySet().iterator();
            while (cachedNamesIter.hasNext()) {
                String messageName = (String)cachedNamesIter.next();
                if (messageNames.contains(messageName)) continue;
                cachedNamesIter.remove();
            }
            long purgeEnd = System.currentTimeMillis();
            purgeSum += purgeEnd - purgeStart;
            for (String messageName : messageNames) {
                if (cachedMap.containsKey(messageName)) continue;
                newMessageKeys.add(keyBuilder.message(instanceName, messageName));
            }
        }
        if (newMessageKeys.size() > 0) {
            List newMessages = accessor.getProperty(newMessageKeys);
            for (Message message : newMessages) {
                if (message == null) continue;
                Map<String, Message> cachedMap = this._messageCache.get(message.getTgtName());
                cachedMap.put(message.getId(), message);
            }
        }
        this._messageMap = Collections.unmodifiableMap(msgMap);
        LOG.debug((Object)("Purge took: " + purgeSum));
        LinkedList currentStateKeys = Lists.newLinkedList();
        HashMap allCurStateMap = new HashMap();
        for (String instanceName : this._liveInstanceMap.keySet()) {
            Map sessionCurStateMap;
            LiveInstance liveInstance = this._liveInstanceMap.get(instanceName);
            String sessionId = liveInstance.getSessionId();
            List<String> currentStateNames = accessor.getChildNames(keyBuilder.currentStates(instanceName, sessionId));
            for (String currentStateName : currentStateNames) {
                currentStateKeys.add(keyBuilder.currentState(instanceName, sessionId, currentStateName));
            }
            Map instanceCurStateMap = (Map)allCurStateMap.get(instanceName);
            if (instanceCurStateMap == null) {
                instanceCurStateMap = Maps.newHashMap();
                allCurStateMap.put(instanceName, instanceCurStateMap);
            }
            if ((sessionCurStateMap = (Map)instanceCurStateMap.get(sessionId)) != null) continue;
            sessionCurStateMap = Maps.newHashMap();
            instanceCurStateMap.put(sessionId, sessionCurStateMap);
        }
        List currentStates = accessor.getProperty(currentStateKeys);
        Iterator csKeyIter = currentStateKeys.iterator();
        for (CurrentState currentState : currentStates) {
            PropertyKey key = (PropertyKey)csKeyIter.next();
            String[] params = key.getParams();
            if (currentState == null || params.length < 4) continue;
            Map instanceCurStateMap = (Map)allCurStateMap.get(params[1]);
            Map sessionCurStateMap = (Map)instanceCurStateMap.get(params[2]);
            sessionCurStateMap.put(params[3], currentState);
        }
        for (String instance : allCurStateMap.keySet()) {
            allCurStateMap.put(instance, Collections.unmodifiableMap((Map)allCurStateMap.get(instance)));
        }
        this._currentStateMap = Collections.unmodifiableMap(allCurStateMap);
        this._idealStateRuleMap = Maps.newHashMap();
        this._clusterConfig = (ClusterConfig)accessor.getProperty(keyBuilder.clusterConfig());
        if (this._clusterConfig != null) {
            for (String simpleKey : this._clusterConfig.getRecord().getSimpleFields().keySet()) {
                if (!simpleKey.startsWith(IDEAL_STATE_RULE_PREFIX)) continue;
                String simpleValue = this._clusterConfig.getRecord().getSimpleField(simpleKey);
                String[] rules = simpleValue.split("(?<!\\\\),");
                HashMap singleRule = Maps.newHashMap();
                for (String rule : rules) {
                    String[] keyValue = rule.split("(?<!\\\\)=");
                    if (keyValue.length < 2) continue;
                    singleRule.put(keyValue[0], keyValue[1]);
                }
                this._idealStateRuleMap.put(simpleKey, singleRule);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("END: ClusterDataCache.refresh(), took " + (endTime - startTime) + " ms"));
        if (LOG.isDebugEnabled()) {
            int numPaths = this._liveInstanceMap.size() + this._idealStateMap.size() + this._stateModelDefMap.size() + this._instanceConfigMap.size() + this._resourceConfigMap.size() + this._constraintMap.size() + newMessageKeys.size() + currentStateKeys.size();
            LOG.debug((Object)("Paths read: " + numPaths));
        }
        this._init = false;
        return true;
    }

    public ClusterConfig getClusterConfig() {
        return this._clusterConfig;
    }

    public Map<String, Long> getInstanceOfflineTimeMap() {
        return this._instanceOfflineTimeMap;
    }

    private void updateOfflineInstanceHistory(HelixDataAccessor accessor) {
        ArrayList<String> offlineNodes = new ArrayList<String>(this._instanceConfigMap.keySet());
        offlineNodes.removeAll(this._liveInstanceMap.keySet());
        this._instanceOfflineTimeMap = new HashMap<String, Long>();
        for (String instance : offlineNodes) {
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            PropertyKey propertyKey = keyBuilder.participantHistory(instance);
            ParticipantHistory history = (ParticipantHistory)accessor.getProperty(propertyKey);
            if (history == null) {
                history = new ParticipantHistory(instance);
            }
            if (history.getLastOfflineTime() == ParticipantHistory.ONLINE) {
                history.reportOffline();
                accessor.setProperty(propertyKey, history);
            }
            this._instanceOfflineTimeMap.put(instance, history.getLastOfflineTime());
        }
        this._updateInstanceOfflineTime = false;
    }

    public Map<String, IdealState> getIdealStates() {
        return this._idealStateMap;
    }

    public synchronized void setIdealStates(List<IdealState> idealStates) {
        HashMap idealStateMap = Maps.newHashMap();
        for (IdealState idealState : idealStates) {
            idealStateMap.put(idealState.getId(), idealState);
        }
        this._idealStateCacheMap = idealStateMap;
    }

    public Map<String, Map<String, String>> getIdealStateRules() {
        return this._idealStateRuleMap;
    }

    public Map<String, LiveInstance> getLiveInstances() {
        return this._liveInstanceMap;
    }

    public Set<String> getAllInstances() {
        return new HashSet<String>(this._instanceConfigMap.keySet());
    }

    public Set<String> getEnabledLiveInstances() {
        HashSet<String> enabledLiveInstances = new HashSet<String>(this.getLiveInstances().keySet());
        enabledLiveInstances.removeAll(this.getDisabledInstances());
        return enabledLiveInstances;
    }

    public Set<String> getEnabledInstances() {
        HashSet<String> enabledNodes = new HashSet<String>(this.getInstanceConfigMap().keySet());
        enabledNodes.removeAll(this.getDisabledInstances());
        return enabledNodes;
    }

    public Set<String> getEnabledLiveInstancesWithTag(String instanceTag) {
        HashSet<String> enabledLiveInstancesWithTag = new HashSet<String>(this.getLiveInstances().keySet());
        Set<String> instancesWithTag = this.getInstancesWithTag(instanceTag);
        enabledLiveInstancesWithTag.retainAll(instancesWithTag);
        enabledLiveInstancesWithTag.removeAll(this.getDisabledInstances());
        return enabledLiveInstancesWithTag;
    }

    public Set<String> getInstancesWithTag(String instanceTag) {
        HashSet<String> taggedInstances = new HashSet<String>();
        for (String instance : this._instanceConfigMap.keySet()) {
            InstanceConfig instanceConfig = this._instanceConfigMap.get(instance);
            if (instanceConfig == null || !instanceConfig.containsTag(instanceTag)) continue;
            taggedInstances.add(instance);
        }
        return taggedInstances;
    }

    public synchronized void setLiveInstances(List<LiveInstance> liveInstances) {
        HashMap liveInstanceMap = Maps.newHashMap();
        for (LiveInstance liveInstance : liveInstances) {
            liveInstanceMap.put(liveInstance.getId(), liveInstance);
        }
        this._liveInstanceCacheMap = liveInstanceMap;
        this._updateInstanceOfflineTime = true;
    }

    public Map<String, CurrentState> getCurrentState(String instanceName, String clientSessionId) {
        if (!this._currentStateMap.containsKey(instanceName) || !this._currentStateMap.get(instanceName).containsKey(clientSessionId)) {
            return Collections.emptyMap();
        }
        return this._currentStateMap.get(instanceName).get(clientSessionId);
    }

    public Map<String, Message> getMessages(String instanceName) {
        Map<String, Message> map = this._messageMap.get(instanceName);
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public void cacheMessages(List<Message> messages) {
        for (Message message : messages) {
            String instanceName = message.getTgtName();
            Map<Object, Object> instMsgMap = null;
            if (this._messageCache.containsKey(instanceName)) {
                instMsgMap = this._messageCache.get(instanceName);
            } else {
                instMsgMap = Maps.newHashMap();
                this._messageCache.put(instanceName, (Map<String, Message>)instMsgMap);
            }
            instMsgMap.put(message.getId(), message);
        }
    }

    public StateModelDefinition getStateModelDef(String stateModelDefRef) {
        return this._stateModelDefMap.get(stateModelDefRef);
    }

    public Map<String, StateModelDefinition> getStateModelDefMap() {
        return this._stateModelDefMap;
    }

    public IdealState getIdealState(String resourceName) {
        return this._idealStateMap.get(resourceName);
    }

    public Map<String, InstanceConfig> getInstanceConfigMap() {
        return this._instanceConfigMap;
    }

    public Map<String, ResourceConfig> getResourceConfigMap() {
        return this._resourceConfigMap;
    }

    public ResourceConfig getResourceConfig(String resource) {
        return this._resourceConfigMap.get(resource);
    }

    public synchronized void setInstanceConfigs(List<InstanceConfig> instanceConfigs) {
        HashMap instanceConfigMap = Maps.newHashMap();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            instanceConfigMap.put(instanceConfig.getId(), instanceConfig);
        }
        this._instanceConfigCacheMap = instanceConfigMap;
    }

    public Set<String> getDisabledInstancesForPartition(String resource, String partition) {
        HashSet<String> disabledInstancesSet = new HashSet<String>();
        for (String instance : this._instanceConfigMap.keySet()) {
            InstanceConfig config = this._instanceConfigMap.get(instance);
            if (config.getInstanceEnabled() && config.getInstanceEnabledForPartition(resource, partition)) continue;
            disabledInstancesSet.add(instance);
        }
        return disabledInstancesSet;
    }

    public Set<String> getDisabledInstances() {
        HashSet<String> disabledInstancesSet = new HashSet<String>();
        for (String instance : this._instanceConfigMap.keySet()) {
            InstanceConfig config = this._instanceConfigMap.get(instance);
            if (config.getInstanceEnabled()) continue;
            disabledInstancesSet.add(instance);
        }
        return disabledInstancesSet;
    }

    public int getReplicas(String resourceName) {
        int replicas = -1;
        if (this._idealStateMap.containsKey(resourceName)) {
            String replicasStr = this._idealStateMap.get(resourceName).getReplicas();
            if (replicasStr != null) {
                if (replicasStr.equals(IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString())) {
                    replicas = this._liveInstanceMap.size();
                } else {
                    try {
                        replicas = Integer.parseInt(replicasStr);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("invalid replicas string: " + replicasStr));
                    }
                }
            } else {
                LOG.error((Object)("idealState for resource: " + resourceName + " does NOT have replicas"));
            }
        }
        return replicas;
    }

    public ClusterConstraints getConstraint(ClusterConstraints.ConstraintType type) {
        if (this._constraintMap != null) {
            return this._constraintMap.get(type.toString());
        }
        return null;
    }

    public Integer getParticipantActiveTaskCount(String instance) {
        return this._participantActiveTaskCount.get(instance);
    }

    public void setParticipantActiveTaskCount(String instance, int taskCount) {
        this._participantActiveTaskCount.put(instance, taskCount);
    }

    public void resetActiveTaskCount(CurrentStateOutput currentStateOutput) {
        for (String liveInstance : this.getLiveInstances().keySet()) {
            this._participantActiveTaskCount.put(liveInstance, 0);
        }
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithPendingState("Task", TaskPartitionState.INIT.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithPendingState("Task", TaskPartitionState.RUNNING.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithCurrentState("Task", TaskPartitionState.INIT.name()), this._participantActiveTaskCount);
        this.fillActiveTaskCount(currentStateOutput.getPartitionCountWithCurrentState("Task", TaskPartitionState.RUNNING.name()), this._participantActiveTaskCount);
    }

    private void fillActiveTaskCount(Map<String, Integer> additionPartitionMap, Map<String, Integer> partitionMap) {
        for (String participant : additionPartitionMap.keySet()) {
            partitionMap.put(participant, partitionMap.get(participant) + additionPartitionMap.get(participant));
        }
    }

    public synchronized void requireFullRefresh() {
        this._init = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("liveInstaceMap:" + this._liveInstanceMap).append("\n");
        sb.append("idealStateMap:" + this._idealStateMap).append("\n");
        sb.append("stateModelDefMap:" + this._stateModelDefMap).append("\n");
        sb.append("instanceConfigMap:" + this._instanceConfigMap).append("\n");
        sb.append("resourceConfigMap:" + this._resourceConfigMap).append("\n");
        sb.append("messageMap:" + this._messageMap).append("\n");
        return sb.toString();
    }
}

