/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.CurrentStateChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.IdealStateChangeListener;
import org.apache.helix.InstanceConfigChangeListener;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.MessageListener;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.ScopedConfigChangeListener;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKExceptionHandler;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class CallbackHandler
implements IZkChildListener,
IZkDataListener {
    private static Logger logger = Logger.getLogger(CallbackHandler.class);
    private static Map<NotificationContext.Type, List<NotificationContext.Type>> nextNotificationType = new HashMap<NotificationContext.Type, List<NotificationContext.Type>>();
    private final String _path;
    private final Object _listener;
    private final Watcher.Event.EventType[] _eventTypes;
    private final HelixDataAccessor _accessor;
    private final HelixConstants.ChangeType _changeType;
    private final ZkClient _zkClient;
    private final AtomicLong _lastNotificationTimeStamp;
    private final HelixManager _manager;
    private final PropertyKey _propertyKey;
    BlockingQueue<NotificationContext> _queue = new LinkedBlockingQueue<NotificationContext>(1000);
    private static boolean asyncBatchModeEnabled;
    private List<NotificationContext.Type> _expectTypes = nextNotificationType.get((Object)NotificationContext.Type.FINALIZE);

    public CallbackHandler(HelixManager manager, ZkClient client, PropertyKey propertyKey, Object listener, Watcher.Event.EventType[] eventTypes, HelixConstants.ChangeType changeType) {
        if (listener == null) {
            throw new HelixException("listener could not be null");
        }
        this._manager = manager;
        this._accessor = manager.getHelixDataAccessor();
        this._zkClient = client;
        this._propertyKey = propertyKey;
        this._path = propertyKey.getPath();
        this._listener = listener;
        this._eventTypes = eventTypes;
        this._changeType = changeType;
        this._lastNotificationTimeStamp = new AtomicLong(System.nanoTime());
        this._queue = new LinkedBlockingQueue<NotificationContext>(1000);
        if (asyncBatchModeEnabled) {
            new Thread(new CallbackInvoker(this)).start();
        }
        this.init();
    }

    public Object getListener() {
        return this._listener;
    }

    public String getPath() {
        return this._path;
    }

    public void enqueueTask(NotificationContext changeContext) throws Exception {
        if (asyncBatchModeEnabled && changeContext.getType() == NotificationContext.Type.CALLBACK) {
            logger.info((Object)"Enqueuing callback");
            this._queue.put(changeContext);
        } else {
            this.invoke(changeContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(NotificationContext changeContext) throws Exception {
        HelixManager helixManager = this._manager;
        synchronized (helixManager) {
            MessageListener messageListener;
            Object listener;
            NotificationContext.Type type = changeContext.getType();
            if (!this._expectTypes.contains((Object)type)) {
                logger.warn((Object)("Skip processing callbacks for listener: " + this._listener + ", path: " + this._path + ", expected types: " + this._expectTypes + " but was " + (Object)((Object)type)));
                return;
            }
            this._expectTypes = nextNotificationType.get((Object)type);
            long start = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)(Thread.currentThread().getId() + " START:INVOKE " + this._path + " listener:" + this._listener.getClass().getCanonicalName()));
            }
            if (this._changeType == HelixConstants.ChangeType.IDEAL_STATE) {
                IdealStateChangeListener idealStateChangeListener = (IdealStateChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<IdealState> idealStates = this._accessor.getChildValues(this._propertyKey);
                idealStateChangeListener.onIdealStateChange(idealStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.INSTANCE_CONFIG) {
                this.subscribeForChanges(changeContext, this._path, true, true);
                if (this._listener instanceof ConfigChangeListener) {
                    ConfigChangeListener configChangeListener = (ConfigChangeListener)this._listener;
                    List<InstanceConfig> configs = this._accessor.getChildValues(this._propertyKey);
                    configChangeListener.onConfigChange(configs, changeContext);
                } else if (this._listener instanceof InstanceConfigChangeListener) {
                    listener = (InstanceConfigChangeListener)this._listener;
                    List<InstanceConfig> configs = this._accessor.getChildValues(this._propertyKey);
                    listener.onInstanceConfigChange(configs, changeContext);
                }
            } else if (this._changeType == HelixConstants.ChangeType.CONFIG) {
                this.subscribeForChanges(changeContext, this._path, true, true);
                listener = (ScopedConfigChangeListener)this._listener;
                List<HelixProperty> configs = this._accessor.getChildValues(this._propertyKey);
                listener.onConfigChange(configs, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.LIVE_INSTANCE) {
                LiveInstanceChangeListener liveInstanceChangeListener = (LiveInstanceChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<LiveInstance> liveInstances = this._accessor.getChildValues(this._propertyKey);
                liveInstanceChangeListener.onLiveInstanceChange(liveInstances, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CURRENT_STATE) {
                CurrentStateChangeListener currentStateChangeListener = (CurrentStateChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<CurrentState> currentStates = this._accessor.getChildValues(this._propertyKey);
                currentStateChangeListener.onStateChange(instanceName, currentStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.MESSAGE) {
                messageListener = (MessageListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, false);
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<Message> messages = this._accessor.getChildValues(this._propertyKey);
                messageListener.onMessage(instanceName, messages, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.MESSAGES_CONTROLLER) {
                messageListener = (MessageListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, false);
                List<Message> messages = this._accessor.getChildValues(this._propertyKey);
                messageListener.onMessage(this._manager.getInstanceName(), messages, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.EXTERNAL_VIEW) {
                ExternalViewChangeListener externalViewListener = (ExternalViewChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<ExternalView> externalViewList = this._accessor.getChildValues(this._propertyKey);
                externalViewListener.onExternalViewChange(externalViewList, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CONTROLLER) {
                ControllerChangeListener controllerChangelistener = (ControllerChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, false);
                controllerChangelistener.onControllerChange(changeContext);
            }
            long end = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)(Thread.currentThread().getId() + " END:INVOKE " + this._path + " listener:" + this._listener.getClass().getCanonicalName() + " Took: " + (end - start) + "ms"));
            }
        }
    }

    private void subscribeChildChange(String path, NotificationContext context) {
        NotificationContext.Type type = context.getType();
        if (type == NotificationContext.Type.INIT || type == NotificationContext.Type.CALLBACK) {
            logger.info((Object)(this._manager.getInstanceName() + " subscribes child-change. path: " + path + ", listener: " + this._listener));
            this._zkClient.subscribeChildChanges(path, this);
        } else if (type == NotificationContext.Type.FINALIZE) {
            logger.info((Object)(this._manager.getInstanceName() + " unsubscribe child-change. path: " + path + ", listener: " + this._listener));
            this._zkClient.unsubscribeChildChanges(path, this);
        }
    }

    private void subscribeDataChange(String path, NotificationContext context) {
        NotificationContext.Type type = context.getType();
        if (type == NotificationContext.Type.INIT || type == NotificationContext.Type.CALLBACK) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this._manager.getInstanceName() + " subscribe data-change. path: " + path + ", listener: " + this._listener));
            }
            this._zkClient.subscribeDataChanges(path, this);
        } else if (type == NotificationContext.Type.FINALIZE) {
            logger.info((Object)(this._manager.getInstanceName() + " unsubscribe data-change. path: " + path + ", listener: " + this._listener));
            this._zkClient.unsubscribeDataChanges(path, this);
        }
    }

    private void subscribeForChanges(NotificationContext context, String path, boolean watchParent, boolean watchChild) {
        long start = System.currentTimeMillis();
        if (watchParent) {
            this.subscribeChildChange(path, context);
        }
        if (watchChild) {
            try {
                switch (this._changeType) {
                    case CURRENT_STATE: 
                    case IDEAL_STATE: 
                    case EXTERNAL_VIEW: {
                        ZkBaseDataAccessor baseAccessor = new ZkBaseDataAccessor(this._zkClient);
                        List records = baseAccessor.getChildren(path, null, 0);
                        for (ZNRecord record : records) {
                            HelixProperty property = new HelixProperty(record);
                            String childPath = path + "/" + record.getId();
                            int bucketSize = property.getBucketSize();
                            if (bucketSize > 0) {
                                this.subscribeChildChange(childPath, context);
                                this.subscribeDataChange(childPath, context);
                                List bucketizedChildNames = this._zkClient.getChildren(childPath);
                                if (bucketizedChildNames == null) continue;
                                for (String bucketizedChildName : bucketizedChildNames) {
                                    String bucketizedChildPath = childPath + "/" + bucketizedChildName;
                                    this.subscribeDataChange(bucketizedChildPath, context);
                                }
                                continue;
                            }
                            this.subscribeDataChange(childPath, context);
                        }
                        break;
                    }
                    default: {
                        List childNames = this._zkClient.getChildren(path);
                        if (childNames != null) {
                            for (String childName : childNames) {
                                String childPath = path + "/" + childName;
                                this.subscribeDataChange(childPath, context);
                            }
                        }
                    }
                }
            }
            catch (ZkNoNodeException e) {
                logger.warn((Object)("fail to subscribe child/data change. path: " + path + ", listener: " + this._listener), (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("Subcribing to path:" + path + " took:" + (end - start)));
    }

    public Watcher.Event.EventType[] getEventTypes() {
        return this._eventTypes;
    }

    public void init() {
        this.updateNotificationTime(System.nanoTime());
        try {
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.INIT);
            this.enqueueTask(changeContext);
        }
        catch (Exception e) {
            String msg = "Exception while invoking init callback for listener:" + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    public void handleDataChange(String dataPath, Object data) {
        try {
            this.updateNotificationTime(System.nanoTime());
            if (dataPath != null && dataPath.startsWith(this._path)) {
                NotificationContext changeContext = new NotificationContext(this._manager);
                changeContext.setType(NotificationContext.Type.CALLBACK);
                this.enqueueTask(changeContext);
            }
        }
        catch (Exception e) {
            String msg = "exception in handling data-change. path: " + dataPath + ", listener: " + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    public void handleDataDeleted(String dataPath) {
        try {
            this.updateNotificationTime(System.nanoTime());
            if (dataPath != null && dataPath.startsWith(this._path)) {
                logger.info((Object)(this._manager.getInstanceName() + " unsubscribe data-change. path: " + dataPath + ", listener: " + this._listener));
                this._zkClient.unsubscribeDataChanges(dataPath, this);
                logger.info((Object)(this._manager.getInstanceName() + " unsubscribe child-change. path: " + dataPath + ", listener: " + this._listener));
                this._zkClient.unsubscribeChildChanges(dataPath, this);
            }
        }
        catch (Exception e) {
            String msg = "exception in handling data-delete-change. path: " + dataPath + ", listener: " + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) {
        try {
            this.updateNotificationTime(System.nanoTime());
            if (parentPath != null && parentPath.startsWith(this._path)) {
                NotificationContext changeContext = new NotificationContext(this._manager);
                if (currentChilds == null && parentPath.equals(this._path)) {
                    this._manager.removeListener(this._propertyKey, this._listener);
                } else {
                    changeContext.setType(NotificationContext.Type.CALLBACK);
                    this.enqueueTask(changeContext);
                }
            }
        }
        catch (Exception e) {
            String msg = "exception in handling child-change. instance: " + this._manager.getInstanceName() + ", parentPath: " + parentPath + ", listener: " + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    public void reset() {
        try {
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.FINALIZE);
            this.enqueueTask(changeContext);
        }
        catch (Exception e) {
            String msg = "Exception while resetting the listener:" + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    private void updateNotificationTime(long nanoTime) {
        boolean b;
        long l = this._lastNotificationTimeStamp.get();
        while (nanoTime > l && !(b = this._lastNotificationTimeStamp.compareAndSet(l, nanoTime))) {
            l = this._lastNotificationTimeStamp.get();
        }
    }

    static {
        nextNotificationType.put(NotificationContext.Type.INIT, Arrays.asList(NotificationContext.Type.CALLBACK, NotificationContext.Type.FINALIZE));
        nextNotificationType.put(NotificationContext.Type.CALLBACK, Arrays.asList(NotificationContext.Type.CALLBACK, NotificationContext.Type.FINALIZE));
        nextNotificationType.put(NotificationContext.Type.FINALIZE, Arrays.asList(NotificationContext.Type.INIT));
        asyncBatchModeEnabled = false;
        asyncBatchModeEnabled = Boolean.parseBoolean(System.getProperty("isAsyncBatchModeEnabled"));
        logger.info((Object)("isAsyncBatchModeEnabled: " + asyncBatchModeEnabled));
    }

    class CallbackInvoker
    implements Runnable {
        private CallbackHandler handler;

        CallbackInvoker(CallbackHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        NotificationContext nextItem;
                        NotificationContext notificationToProcess = CallbackHandler.this._queue.take();
                        int mergedCallbacks = 0;
                        while ((nextItem = (NotificationContext)CallbackHandler.this._queue.peek()) != null && notificationToProcess.getType() == nextItem.getType()) {
                            notificationToProcess = CallbackHandler.this._queue.take();
                            ++mergedCallbacks;
                        }
                        try {
                            logger.info((Object)("Num callbacks merged for path:" + this.handler.getPath() + " : " + mergedCallbacks));
                            this.handler.invoke(notificationToProcess);
                            continue block4;
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Exception in callback processing thread. Skipping callback", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Interrupted exception in callback processing thread. Exiting thread, new callbacks will not be processed", (Throwable)e);
                    return;
                }
            }
        }
    }
}

