/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.model.Message;

public abstract class MessageHandler {
    protected final Message _message;
    protected boolean _cancelled;
    protected final NotificationContext _notificationContext;

    public MessageHandler(Message message, NotificationContext context) {
        this._message = message;
        this._notificationContext = context;
        this._cancelled = false;
    }

    public abstract HelixTaskResult handleMessage() throws InterruptedException;

    public abstract void onError(Exception var1, ErrorCode var2, ErrorType var3);

    public void onTimeout() {
    }

    public Message getMessage() {
        return this._message;
    }

    public void cancel() {
        this._cancelled = true;
    }

    public static enum ErrorCode {
        ERROR,
        CANCEL,
        TIMEOUT;

    }

    public static enum ErrorType {
        FRAMEWORK,
        INTERNAL;

    }
}

