/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;

public abstract class TaskRebalancer
implements Rebalancer,
MappingCalculator {
    private static final Logger LOG = Logger.getLogger(TaskRebalancer.class);
    protected static long JOB_PURGE_INTERVAL = 600000L;
    protected HelixManager _manager;
    protected static RebalanceScheduler _scheduledRebalancer = new RebalanceScheduler();
    protected ClusterStatusMonitor _clusterStatusMonitor;

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
    }

    @Override
    public abstract ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache var1, IdealState var2, Resource var3, CurrentStateOutput var4);

    protected boolean isWorkflowFinished(WorkflowContext ctx, WorkflowConfig cfg) {
        boolean incomplete = false;
        int failedJobs = 0;
        for (String job : cfg.getJobDag().getAllNodes()) {
            TaskState jobState = ctx.getJobState(job);
            if (!cfg.isJobQueue() && jobState == TaskState.FAILED && !cfg.isJobQueue() && ++failedJobs > cfg.getFailureThreshold()) {
                ctx.setWorkflowState(TaskState.FAILED);
                this._clusterStatusMonitor.updateWorkflowCounters(cfg, TaskState.FAILED);
                for (String jobToFail : cfg.getJobDag().getAllNodes()) {
                    if (ctx.getJobState(jobToFail) != TaskState.IN_PROGRESS) continue;
                    ctx.setJobState(jobToFail, TaskState.ABORTED);
                    this._clusterStatusMonitor.updateJobCounters(TaskUtil.getJobConfig(this._manager, jobToFail), TaskState.ABORTED);
                }
                return true;
            }
            if (jobState == TaskState.COMPLETED || jobState == TaskState.FAILED) continue;
            incomplete = true;
        }
        if (!incomplete && cfg.isTerminable()) {
            ctx.setWorkflowState(TaskState.COMPLETED);
            this._clusterStatusMonitor.updateWorkflowCounters(cfg, TaskState.COMPLETED);
            return true;
        }
        return false;
    }

    protected boolean isWorkflowStopped(WorkflowContext ctx, WorkflowConfig cfg) {
        for (String job : cfg.getJobDag().getAllNodes()) {
            TaskState jobState = ctx.getJobState(job);
            if (jobState == null || !jobState.equals((Object)TaskState.IN_PROGRESS) && !jobState.equals((Object)TaskState.STOPPING)) continue;
            return false;
        }
        return true;
    }

    protected ResourceAssignment buildEmptyAssignment(String name, CurrentStateOutput currStateOutput) {
        ResourceAssignment assignment = new ResourceAssignment(name);
        Set<Partition> partitions = currStateOutput.getCurrentStateMappedPartitions(name);
        for (Partition partition : partitions) {
            Map<String, String> currentStateMap = currStateOutput.getCurrentStateMap(name, partition);
            HashMap replicaMap = Maps.newHashMap();
            for (String instanceName : currentStateMap.keySet()) {
                replicaMap.put(instanceName, HelixDefinedState.DROPPED.toString());
            }
            assignment.addReplicaMap(partition, replicaMap);
        }
        return assignment;
    }

    protected boolean isJobReadyToSchedule(String job, WorkflowConfig workflowCfg, WorkflowContext workflowCtx) {
        int notStartedCount = 0;
        int failedCount = 0;
        int incompleteParentCount = 0;
        for (String parent : workflowCfg.getJobDag().getDirectParents(job)) {
            TaskState jobState = workflowCtx.getJobState(parent);
            if (jobState == null || jobState == TaskState.NOT_STARTED) {
                ++notStartedCount;
                continue;
            }
            if (jobState == TaskState.FAILED) {
                ++failedCount;
                continue;
            }
            if (jobState == TaskState.COMPLETED) continue;
            ++incompleteParentCount;
        }
        if (notStartedCount > 0) {
            LOG.debug((Object)String.format("Job %s is not ready to start, notStartedParent(s)=%d.", job, notStartedCount));
            return false;
        }
        JobConfig jobConfig = TaskUtil.getJobConfig(this._manager, job);
        if (failedCount > 0 && !jobConfig.isIgnoreDependentJobFailure()) {
            this.markJobFailed(job, null, workflowCfg, workflowCtx);
            LOG.debug((Object)String.format("Job %s is not ready to start, failedCount(s)=%d.", job, failedCount));
            return false;
        }
        if (workflowCfg.isJobQueue()) {
            int incompleteAllCount = this.getInCompleteJobCount(workflowCfg, workflowCtx);
            if (incompleteAllCount >= workflowCfg.getParallelJobs()) {
                LOG.debug((Object)String.format("Job %s is not ready to schedule, inCompleteJobs(s)=%d.", job, incompleteAllCount));
                return false;
            }
        } else if (incompleteParentCount > 0) {
            LOG.debug((Object)String.format("Job %s is not ready to start, notFinishedParent(s)=%d.", job, incompleteParentCount));
            return false;
        }
        return true;
    }

    protected boolean isJobStarted(String job, WorkflowContext workflowContext) {
        TaskState jobState = workflowContext.getJobState(job);
        return jobState != null && jobState != TaskState.NOT_STARTED;
    }

    protected int getInCompleteJobCount(WorkflowConfig workflowCfg, WorkflowContext workflowCtx) {
        int inCompleteCount = 0;
        for (String jobName : workflowCfg.getJobDag().getAllNodes()) {
            TaskState jobState = workflowCtx.getJobState(jobName);
            if (jobState != TaskState.IN_PROGRESS && jobState != TaskState.STOPPED) continue;
            ++inCompleteCount;
        }
        return inCompleteCount;
    }

    protected void markJobFailed(String jobName, JobContext jobContext, WorkflowConfig workflowConfig, WorkflowContext workflowContext) {
        long currentTime = System.currentTimeMillis();
        workflowContext.setJobState(jobName, TaskState.FAILED);
        if (jobContext != null) {
            jobContext.setFinishTime(currentTime);
        }
        if (this.isWorkflowFinished(workflowContext, workflowConfig)) {
            workflowContext.setFinishTime(currentTime);
        }
        this.scheduleJobCleanUp(jobName, workflowConfig, currentTime);
    }

    protected void scheduleJobCleanUp(String jobName, WorkflowConfig workflowConfig, long currentTime) {
        long currentScheduledTime;
        JobConfig jobConfig = TaskUtil.getJobConfig(this._manager, jobName);
        long l = currentScheduledTime = _scheduledRebalancer.getRebalanceTime(workflowConfig.getWorkflowId()) == -1L ? Long.MAX_VALUE : _scheduledRebalancer.getRebalanceTime(workflowConfig.getWorkflowId());
        if (currentTime + jobConfig.getExpiry() < currentScheduledTime) {
            _scheduledRebalancer.scheduleRebalance(this._manager, workflowConfig.getWorkflowId(), currentTime + jobConfig.getExpiry());
        }
    }

    protected boolean isWorkflowReadyForSchedule(WorkflowConfig workflowCfg) {
        Date startTime = workflowCfg.getStartTime();
        return startTime == null || startTime.getTime() <= System.currentTimeMillis();
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }

    public void setClusterStatusMonitor(ClusterStatusMonitor clusterStatusMonitor) {
        this._clusterStatusMonitor = clusterStatusMonitor;
    }
}

