/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.helix.HelixManager;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.task.TaskFactory;
import org.apache.helix.task.TaskStateModel;

public class TaskStateModelFactory
extends StateModelFactory<TaskStateModel> {
    private final HelixManager _manager;
    private final Map<String, TaskFactory> _taskFactoryRegistry;
    private final ScheduledExecutorService _taskExecutor;
    private static final int TASK_THREADPOOL_SIZE = 40;

    public TaskStateModelFactory(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry) {
        this(manager, taskFactoryRegistry, Executors.newScheduledThreadPool(40, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TaskStateModel-thread-pool");
            }
        }));
    }

    public TaskStateModelFactory(HelixManager manager, Map<String, TaskFactory> taskFactoryRegistry, ScheduledExecutorService taskExecutor) {
        this._manager = manager;
        this._taskFactoryRegistry = taskFactoryRegistry;
        this._taskExecutor = taskExecutor;
    }

    @Override
    public TaskStateModel createNewStateModel(String resourceName, String partitionKey) {
        return new TaskStateModel(this._manager, this._taskFactoryRegistry, this._taskExecutor);
    }

    public void shutdown() {
        this._taskExecutor.shutdown();
    }

    public boolean isShutdown() {
        return this._taskExecutor.isShutdown();
    }

    public boolean isTerminated() {
        return this._taskExecutor.isTerminated();
    }
}

