/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class TaskUtil {
    private static final Logger LOG = Logger.getLogger(TaskUtil.class);
    public static final String CONTEXT_NODE = "Context";
    public static final String USER_CONTENT_NODE = "UserContent";
    public static final String WORKFLOW_CONTEXT_KW = "WorkflowContext";
    public static final String TASK_CONTEXT_KW = "TaskContext";

    protected static JobConfig getJobConfig(HelixDataAccessor accessor, String job) {
        HelixProperty jobResourceConfig = TaskUtil.getResourceConfig(accessor, job);
        if (jobResourceConfig == null) {
            return null;
        }
        return new JobConfig(jobResourceConfig);
    }

    protected static JobConfig getJobConfig(HelixManager manager, String job) {
        return TaskUtil.getJobConfig(manager.getHelixDataAccessor(), job);
    }

    protected static boolean setJobConfig(HelixDataAccessor accessor, String job, JobConfig jobConfig) {
        return TaskUtil.setResourceConfig(accessor, job, jobConfig);
    }

    protected static boolean removeJobConfig(HelixDataAccessor accessor, String job) {
        return TaskUtil.removeWorkflowJobConfig(accessor, job);
    }

    protected static WorkflowConfig getWorkflowConfig(HelixDataAccessor accessor, String workflow) {
        HelixProperty workflowCfg = TaskUtil.getResourceConfig(accessor, workflow);
        if (workflowCfg == null) {
            return null;
        }
        return new WorkflowConfig(workflowCfg);
    }

    protected static WorkflowConfig getWorkflowConfig(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowConfig(manager.getHelixDataAccessor(), workflow);
    }

    protected static boolean setWorkflowConfig(HelixDataAccessor accessor, String workflow, WorkflowConfig workflowConfig) {
        return TaskUtil.setResourceConfig(accessor, workflow, workflowConfig);
    }

    protected static boolean removeWorkflowConfig(HelixDataAccessor accessor, String workflow) {
        return TaskUtil.removeWorkflowJobConfig(accessor, workflow);
    }

    protected static HelixConfigScope getResourceConfigScope(String clusterName, String resource) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterName).forResource(resource).build();
    }

    protected static JobContext getJobContext(HelixPropertyStore<ZNRecord> propertyStore, String jobResource) {
        ZNRecord r = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)jobResource, new Object[]{CONTEXT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new JobContext(r) : null;
    }

    protected static JobContext getJobContext(HelixManager manager, String jobResource) {
        return TaskUtil.getJobContext(manager.getHelixPropertyStore(), jobResource);
    }

    protected static void setJobContext(HelixManager manager, String jobResource, JobContext ctx) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)jobResource, new Object[]{CONTEXT_NODE}), ctx.getRecord(), AccessOption.PERSISTENT);
    }

    protected static boolean removeJobContext(HelixManager manager, String jobResource) {
        return TaskUtil.removeJobContext(manager.getHelixPropertyStore(), jobResource);
    }

    protected static boolean removeJobContext(HelixPropertyStore<ZNRecord> propertyStore, String job) {
        return TaskUtil.removeWorkflowJobContext(propertyStore, job);
    }

    protected static WorkflowContext getWorkflowContext(HelixPropertyStore<ZNRecord> propertyStore, String workflowResource) {
        ZNRecord r = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowResource, new Object[]{CONTEXT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new WorkflowContext(r) : null;
    }

    protected static WorkflowContext getWorkflowContext(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowContext(manager.getHelixPropertyStore(), workflow);
    }

    protected static void setWorkflowContext(HelixManager manager, String workflow, WorkflowContext workflowContext) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[]{CONTEXT_NODE}), workflowContext.getRecord(), AccessOption.PERSISTENT);
    }

    protected static boolean removeWorkflowContext(HelixManager manager, String workflow) {
        return TaskUtil.removeWorkflowContext(manager.getHelixPropertyStore(), workflow);
    }

    protected static boolean removeWorkflowContext(HelixPropertyStore<ZNRecord> propertyStore, String workflow) {
        return TaskUtil.removeWorkflowJobContext(propertyStore, workflow);
    }

    protected static void createUserContent(HelixPropertyStore propertyStore, String workflowJobResource, ZNRecord record) {
        propertyStore.create(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[]{USER_CONTENT_NODE}), record, AccessOption.PERSISTENT);
    }

    protected static String getWorkflowJobUserContent(HelixManager manager, String workflowJobResource, String key) {
        ZNRecord r = (ZNRecord)manager.getHelixPropertyStore().get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[]{USER_CONTENT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? r.getSimpleField(key) : null;
    }

    protected static void addWorkflowJobUserContent(HelixManager manager, String workflowJobResource, final String key, final String value) {
        String path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[]{USER_CONTENT_NODE});
        manager.getHelixPropertyStore().update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord znRecord) {
                znRecord.setSimpleField(key, value);
                return znRecord;
            }
        }, AccessOption.PERSISTENT);
    }

    protected static String getTaskUserContent(HelixManager manager, String job, String task, String key) {
        ZNRecord r = (ZNRecord)manager.getHelixPropertyStore().get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)job, new Object[]{USER_CONTENT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? (r.getMapField(task) != null ? r.getMapField(task).get(key) : null) : null;
    }

    protected static void addTaskUserContent(HelixManager manager, String job, final String task, final String key, final String value) {
        String path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)job, new Object[]{USER_CONTENT_NODE});
        manager.getHelixPropertyStore().update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord znRecord) {
                if (znRecord.getMapField(task) == null) {
                    znRecord.setMapField(task, new HashMap<String, String>());
                }
                znRecord.getMapField(task).put(key, value);
                return znRecord;
            }
        }, AccessOption.PERSISTENT);
    }

    public static String getNamespacedJobName(String singleJobWorkflow) {
        return TaskUtil.getNamespacedJobName(singleJobWorkflow, singleJobWorkflow);
    }

    public static String getNamespacedJobName(String workflow, String jobName) {
        return workflow + "_" + jobName;
    }

    public static String getDenamespacedJobName(String workflow, String jobName) {
        if (jobName.contains(workflow)) {
            return jobName.substring(jobName.indexOf(workflow) + workflow.length() + 1);
        }
        return jobName;
    }

    @Deprecated
    public static String serializeJobCommandConfigMap(Map<String, String> commandConfig) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String serializedMap = mapper.writeValueAsString(commandConfig);
            return serializedMap;
        }
        catch (IOException e) {
            LOG.error((Object)("Error serializing " + commandConfig), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static Map<String, String> deserializeJobCommandConfigMap(String commandConfig) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map commandConfigMap = (Map)mapper.readValue(commandConfig, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            return commandConfigMap;
        }
        catch (IOException e) {
            LOG.error((Object)("Error deserializing " + commandConfig), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected static int getPartitionId(String pName) {
        int index = pName.lastIndexOf("_");
        if (index == -1) {
            throw new HelixException("Invalid partition name " + pName);
        }
        return Integer.valueOf(pName.substring(index + 1));
    }

    @Deprecated
    public static String getWorkflowContextKey(String workflow) {
        return Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[0]);
    }

    @Deprecated
    public static PropertyKey getWorkflowConfigKey(HelixDataAccessor accessor, String workflow) {
        return accessor.keyBuilder().resourceConfig(workflow);
    }

    protected static boolean cleanupJobIdealStateExtView(HelixDataAccessor accessor, String job) {
        return TaskUtil.cleanupIdealStateExtView(accessor, job);
    }

    protected static boolean cleanupWorkflowIdealStateExtView(HelixDataAccessor accessor, String workflow) {
        return TaskUtil.cleanupIdealStateExtView(accessor, workflow);
    }

    private static boolean cleanupIdealStateExtView(HelixDataAccessor accessor, String workflowJobResource) {
        PropertyKey evKey;
        boolean success = true;
        PropertyKey isKey = accessor.keyBuilder().idealStates(workflowJobResource);
        if (accessor.getProperty(isKey) != null && !accessor.removeProperty(isKey)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove IdealState for %s. Failed to remove node %s.", workflowJobResource, isKey));
            success = false;
        }
        if (accessor.getProperty(evKey = accessor.keyBuilder().externalView(workflowJobResource)) != null && !accessor.removeProperty(evKey)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove ExternalView of resource %s. Failed to remove node %s.", workflowJobResource, evKey));
            success = false;
        }
        return success;
    }

    protected static boolean removeWorkflow(HelixManager manager, String workflow, Set<String> jobs) {
        boolean success = true;
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        for (String job : jobs) {
            if (TaskUtil.removeJob(accessor, manager.getHelixPropertyStore(), job)) continue;
            success = false;
        }
        if (!TaskUtil.cleanupWorkflowIdealStateExtView(accessor, workflow)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove workflow idealstate/externalview for %s.", workflow));
            success = false;
        }
        if (!TaskUtil.removeWorkflowConfig(accessor, workflow)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove workflow config for %s.", workflow));
            success = false;
        }
        if (!TaskUtil.removeWorkflowContext(manager, workflow)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove workflow context for %s.", workflow));
            success = false;
        }
        return success;
    }

    protected static boolean removeJobsFromWorkflow(HelixDataAccessor dataAccessor, HelixPropertyStore propertyStore, String workflow, Set<String> jobs, boolean maintainDependency) {
        boolean success = true;
        if (!TaskUtil.removeJobsFromDag(dataAccessor, workflow, jobs, maintainDependency)) {
            LOG.warn((Object)("Error occurred while trying to remove jobs + " + jobs + " from the workflow " + workflow));
            success = false;
        }
        if (!TaskUtil.removeJobsState(propertyStore, workflow, jobs)) {
            LOG.warn((Object)("Error occurred while trying to remove jobs states from workflow + " + workflow + " jobs " + jobs));
            success = false;
        }
        for (String job : jobs) {
            if (TaskUtil.removeJob(dataAccessor, propertyStore, job)) continue;
            success = false;
        }
        return success;
    }

    protected static Set<String> getExpiredJobs(HelixDataAccessor dataAccessor, HelixPropertyStore propertyStore, WorkflowConfig workflowConfig, WorkflowContext workflowContext) {
        HashSet<String> expiredJobs = new HashSet<String>();
        if (workflowContext != null) {
            Map<String, TaskState> jobStates = workflowContext.getJobStates();
            for (String job : workflowConfig.getJobDag().getAllNodes()) {
                JobConfig jobConfig = TaskUtil.getJobConfig(dataAccessor, job);
                JobContext jobContext = TaskUtil.getJobContext(propertyStore, job);
                long expiry = jobConfig.getExpiry();
                if (expiry == 86400000L || expiry < 0L) {
                    expiry = workflowConfig.getExpiry();
                }
                if (jobContext == null || jobStates.get(job) != TaskState.COMPLETED || System.currentTimeMillis() < jobContext.getFinishTime() + expiry) continue;
                expiredJobs.add(job);
            }
        }
        return expiredJobs;
    }

    protected static boolean removeJob(HelixDataAccessor accessor, HelixPropertyStore propertyStore, String job) {
        boolean success = true;
        if (!TaskUtil.cleanupJobIdealStateExtView(accessor, job)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove job idealstate/externalview for %s.", job));
            success = false;
        }
        if (!TaskUtil.removeWorkflowJobConfig(accessor, job)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove job config for %s.", job));
            success = false;
        }
        if (!TaskUtil.removeJobContext(propertyStore, job)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove job context for %s.", job));
            success = false;
        }
        return success;
    }

    protected static boolean removeJobsFromDag(HelixDataAccessor accessor, final String workflow, final Set<String> jobsToRemove, final boolean maintainDependency) {
        DataUpdater<ZNRecord> dagRemover = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    JobDag jobDag = JobDag.fromJson(currentData.getSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name()));
                    if (jobDag == null) {
                        LOG.warn((Object)("Could not update DAG for workflow: " + workflow + " JobDag is null."));
                        return null;
                    }
                    for (String job : jobsToRemove) {
                        jobDag.removeNode(job, maintainDependency);
                    }
                    try {
                        currentData.setSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name(), jobDag.toJson());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return currentData;
            }
        };
        String configPath = accessor.keyBuilder().resourceConfig(workflow).getPath();
        if (!accessor.getBaseDataAccessor().update(configPath, dagRemover, AccessOption.PERSISTENT)) {
            LOG.warn((Object)("Failed to remove jobs " + jobsToRemove + " from DAG of workflow " + workflow));
            return false;
        }
        return true;
    }

    protected static boolean removeJobsState(HelixPropertyStore propertyStore, String workflow, final Set<String> jobs) {
        DataUpdater<ZNRecord> updater;
        String contextPath = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[]{CONTEXT_NODE});
        if (!propertyStore.update(contextPath, updater = new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    WorkflowContext workflowContext = new WorkflowContext(currentData);
                    workflowContext.removeJobStates(jobs);
                    workflowContext.removeJobStartTime(jobs);
                    currentData = workflowContext.getRecord();
                }
                return currentData;
            }
        }, AccessOption.PERSISTENT)) {
            LOG.warn((Object)("Fail to remove job state for jobs " + jobs + " from workflow " + workflow));
            return false;
        }
        return true;
    }

    private static boolean removeWorkflowJobContext(HelixPropertyStore<ZNRecord> propertyStore, String workflowJobResource) {
        String path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[0]);
        if (propertyStore.exists(path, AccessOption.PERSISTENT) && !propertyStore.remove(path, AccessOption.PERSISTENT)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove workflow/jobcontext for %s. Failed to remove node %s.", workflowJobResource, path));
            return false;
        }
        return true;
    }

    private static boolean removeWorkflowJobConfig(HelixDataAccessor accessor, String workflowJobResource) {
        PropertyKey cfgKey = accessor.keyBuilder().resourceConfig(workflowJobResource);
        if (accessor.getProperty(cfgKey) != null && !accessor.removeProperty(cfgKey)) {
            LOG.warn((Object)String.format("Error occurred while trying to remove config for %s. Failed to remove node %s.", workflowJobResource, cfgKey));
            return false;
        }
        return true;
    }

    private static boolean setResourceConfig(HelixDataAccessor accessor, String resource, ResourceConfig resourceConfig) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.setProperty(keyBuilder.resourceConfig(resource), resourceConfig);
    }

    private static HelixProperty getResourceConfig(HelixDataAccessor accessor, String resource) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.getProperty(keyBuilder.resourceConfig(resource));
    }
}

