/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform;

import com.linkedin.data.schema.PathSpec;

public class Escaper {
    public static String escapePathSegment(String segment) {
        if (segment == PathSpec.WILDCARD) {
            return "$*";
        }
        return Escaper.escape(segment);
    }

    public static String unescapePathSegment(String segment) {
        if (segment.equals("$*")) {
            return PathSpec.WILDCARD;
        }
        return Escaper.unescape(segment);
    }

    public static String escape(String s) {
        return Escaper.replaceAll(s, "$", "$$");
    }

    public static String unescape(String s) {
        return Escaper.replaceAll(s, "$$", "$");
    }

    public static String replaceAll(String s, String what, String withWhat) {
        StringBuilder sb = null;
        int fromIndex = 0;
        boolean found = false;
        int length = s.length();
        do {
            int index;
            boolean bl = found = (index = s.indexOf(what, fromIndex)) >= 0;
            if (!found) continue;
            if (sb == null) {
                sb = new StringBuilder(s.length() * 2);
            }
            sb.append(s, fromIndex, index);
            sb.append(withWhat);
            fromIndex = index + what.length();
        } while (found && fromIndex < length);
        if (sb != null) {
            if (fromIndex < length) {
                sb.append(s, fromIndex, length);
            }
            return sb.toString();
        }
        return s;
    }
}

