/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.transform.patch.validator;

import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.schema.validator.AbstractValidator;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.schema.validator.ValidatorContext;
import java.util.ArrayList;

public class PatchFilterValidator
extends AbstractValidator {
    private final Validator _nextValidator;
    private final Object[] _patchedPath;
    private final DataMap _opMap;
    private final Mode _mode;
    private final ArrayList<Object> _path = new ArrayList();
    private static final Object[] _emptyPath = new Object[0];

    public PatchFilterValidator(Validator nextValidator, DataMap opMap, Mode mode) {
        this(nextValidator, opMap, mode, _emptyPath);
    }

    public PatchFilterValidator(Validator nextValidator, DataMap opMap, Mode mode, DataElement patchedElement) {
        this(nextValidator, opMap, mode, patchedElement.path());
    }

    public PatchFilterValidator(Validator nextValidator, DataMap opMap, Mode mode, Object[] patchedPath) {
        super(opMap);
        this._nextValidator = nextValidator;
        this._patchedPath = patchedPath;
        this._opMap = opMap;
        this._mode = mode;
    }

    public void validate(ValidatorContext context) {
        Status status = this.determineStatus(context.dataElement());
        if (status == Status.IS_SET_VALUE || status == Status.IS_CHILD_MODIFIED && (this._mode == Mode.PARENT_AND_SET || this._mode == Mode.ANCESTOR_AND_SET) || status == Status.IS_DESCENDANT_MODIFIED && this._mode == Mode.ANCESTOR_AND_SET) {
            this._nextValidator.validate(context);
        }
    }

    protected Status determineStatus(DataElement element) {
        int i;
        Status status = null;
        element.pathAsList(this._path);
        DataMap currentOpMap = this._opMap;
        for (i = 0; i < this._path.size(); ++i) {
            Object pathComponent = this._path.get(i);
            if (i < this._patchedPath.length) {
                if (!this._patchedPath[i].equals(pathComponent)) {
                    status = Status.NONE;
                    break;
                }
                status = Status.IS_DESCENDANT_MODIFIED;
                continue;
            }
            Object nextValue = currentOpMap.get(pathComponent);
            if (nextValue == null || nextValue.getClass() != DataMap.class) {
                Object setValue = currentOpMap.get((Object)"$set");
                if (setValue != null && setValue.getClass() == DataMap.class && ((DataMap)setValue).get(pathComponent) != null) {
                    status = Status.IS_SET_VALUE;
                    break;
                }
                status = Status.NONE;
                break;
            }
            status = Status.IS_DESCENDANT_MODIFIED;
            currentOpMap = (DataMap)nextValue;
        }
        if (i == this._path.size()) {
            if (i >= this._patchedPath.length) {
                for (String keys : currentOpMap.keySet()) {
                    if (!keys.startsWith("$")) continue;
                    status = Status.IS_CHILD_MODIFIED;
                    break;
                }
            }
            if (status != Status.IS_CHILD_MODIFIED && i <= this._patchedPath.length && !currentOpMap.isEmpty()) {
                status = Status.IS_DESCENDANT_MODIFIED;
            }
        } else if (status == null) {
            status = Status.NONE;
        }
        return status;
    }

    protected static enum Status {
        NONE,
        IS_SET_VALUE,
        IS_CHILD_MODIFIED,
        IS_DESCENDANT_MODIFIED;

    }

    public static enum Mode {
        SET_ONLY,
        PARENT_AND_SET,
        ANCESTOR_AND_SET;

    }
}

