/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.gobblin.metrics.reporter.util.FixedSchemaVersionWriter;
import org.apache.gobblin.metrics.reporter.util.SchemaVersionWriter;
import org.apache.gobblin.runtime.job_spec.AvroJobSpec;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroJobSpecDeserializer
implements Deserializer<AvroJobSpec> {
    private static final Logger log = LoggerFactory.getLogger(AvroJobSpecDeserializer.class);
    private BinaryDecoder _decoder;
    private SpecificDatumReader<AvroJobSpec> _reader;
    private SchemaVersionWriter<?> _versionWriter;

    public void configure(Map<String, ?> configs, boolean isKey) {
        ByteArrayInputStream dummyInputStream = new ByteArrayInputStream(new byte[0]);
        this._decoder = DecoderFactory.get().binaryDecoder((InputStream)dummyInputStream, null);
        this._reader = new SpecificDatumReader(AvroJobSpec.SCHEMA$);
        this._versionWriter = new FixedSchemaVersionWriter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AvroJobSpec deserialize(String topic, byte[] data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            this._versionWriter.readSchemaVersioningInformation(new DataInputStream(is));
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)is, this._decoder);
            AvroJobSpec avroJobSpec = (AvroJobSpec)this._reader.read(null, (Decoder)decoder);
            return avroJobSpec;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decode message");
        }
    }

    public void close() {
    }
}

