/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.metadata.types.Metadata;
import org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistry;
import org.apache.gobblin.metrics.kafka.KafkaAvroSchemaRegistryFactory;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.type.RecordWithMetadata;

public class RecordWithMetadataSchemaRegistrationConverter
extends Converter<String, String, RecordWithMetadata<?>, RecordWithMetadata<?>> {
    private static final String SCHEMA_ID_KEY = "Schema-Id";
    private static final String CONTENT_TYPE = "application/avro";
    private String schemaId;

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        Schema schema = Schema.parse((String)inputSchema);
        if (null == this.schemaId) {
            try {
                this.schemaId = RecordWithMetadataSchemaRegistrationConverter.getSchemaId(workUnit.getProperties(), schema);
            }
            catch (SchemaRegistryException e) {
                throw new SchemaConversionException((Throwable)e);
            }
        }
        return schema.toString();
    }

    private static String getSchemaId(Properties properties, Schema schema) throws SchemaRegistryException {
        KafkaAvroSchemaRegistry kafkaAvroSchemaRegistry = (KafkaAvroSchemaRegistry)new KafkaAvroSchemaRegistryFactory().create(properties);
        return kafkaAvroSchemaRegistry.register(schema);
    }

    public Iterable<RecordWithMetadata<?>> convertRecord(String outputSchema, RecordWithMetadata<?> inputRecord, WorkUnitState workUnit) throws DataConversionException {
        Preconditions.checkNotNull((Object)this.schemaId);
        Metadata metadata = inputRecord.getMetadata();
        metadata.getGlobalMetadata().setContentType(CONTENT_TYPE);
        metadata.getRecordMetadata().put(SCHEMA_ID_KEY, this.schemaId);
        return Collections.singleton(new RecordWithMetadata(inputRecord.getRecord(), metadata));
    }
}

