/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DynamicPartitionPruner;
import org.apache.hadoop.hive.ql.exec.tez.SplitGrouper;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.split.TezMapReduceSplitsGrouper;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.mapreduce.hadoop.InputSplitInfoMem;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputInitializer;
import org.apache.tez.runtime.api.InputInitializerContext;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;

public class HiveSplitGenerator
extends InputInitializer {
    private static final Log LOG = LogFactory.getLog(HiveSplitGenerator.class);
    private static final SplitGrouper grouper = new SplitGrouper();
    private final DynamicPartitionPruner pruner = new DynamicPartitionPruner();
    private InputInitializerContext context;
    private static Map<Map<String, PartitionDesc>, Map<String, PartitionDesc>> cache = new HashMap<Map<String, PartitionDesc>, Map<String, PartitionDesc>>();

    public HiveSplitGenerator(InputInitializerContext initializerContext) {
        super(initializerContext);
    }

    public HiveSplitGenerator() {
        this(null);
    }

    public List<Event> initialize() throws Exception {
        InputInitializerContext rootInputContext;
        this.context = rootInputContext = this.getContext();
        MRRuntimeProtos.MRInputUserPayloadProto userPayloadProto = MRInputHelpers.parseMRInputPayload((UserPayload)rootInputContext.getInputUserPayload());
        Configuration conf = TezUtils.createConfFromByteString((ByteString)userPayloadProto.getConfigurationBytes());
        boolean sendSerializedEvents = conf.getBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        JobConf jobConf = new JobConf(conf);
        ShimLoader.getHadoopShims().getMergedCredentials(jobConf);
        MapWork work = Utilities.getMapWork((Configuration)jobConf);
        this.pruner.prune(work, jobConf, this.context);
        InputSplitInfoMem inputSplitInfo = null;
        String realInputFormatName = conf.get("mapred.input.format.class");
        boolean groupingEnabled = userPayloadProto.getGroupingEnabled();
        if (!groupingEnabled) {
            throw new RuntimeException("HiveInputFormat does not support non-grouped splits, InputFormatName is: " + realInputFormatName);
        }
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance(Class.forName(realInputFormatName), (Configuration)jobConf);
        int totalResource = rootInputContext.getTotalAvailableResource().getMemory();
        int taskResource = rootInputContext.getVertexTaskResource().getMemory();
        int availableSlots = totalResource / taskResource;
        float waves = conf.getFloat("tez.grouping.split-waves", TezMapReduceSplitsGrouper.TEZ_GROUPING_SPLIT_WAVES_DEFAULT);
        InputSplit[] splits = inputFormat.getSplits(jobConf, (int)((float)availableSlots * waves));
        LOG.info((Object)("Number of input splits: " + splits.length + ". " + availableSlots + " available slots, " + waves + " waves. Input format is: " + realInputFormatName));
        Multimap<Integer, InputSplit> groupedSplits = this.generateGroupedSplits(jobConf, conf, splits, waves, availableSlots);
        InputSplit[] flatSplits = groupedSplits.values().toArray(new InputSplit[0]);
        LOG.info((Object)("Number of grouped splits: " + flatSplits.length));
        List<TaskLocationHint> locationHints = grouper.createTaskLocationHints(flatSplits);
        Utilities.clearWork((Configuration)jobConf);
        inputSplitInfo = new InputSplitInfoMem(flatSplits, locationHints, flatSplits.length, null, (Configuration)jobConf);
        return this.createEventList(sendSerializedEvents, inputSplitInfo);
    }

    public Multimap<Integer, InputSplit> generateGroupedSplits(JobConf jobConf, Configuration conf, InputSplit[] splits, float waves, int availableSlots) throws Exception {
        return this.generateGroupedSplits(jobConf, conf, splits, waves, availableSlots, null, true);
    }

    public Multimap<Integer, InputSplit> generateGroupedSplits(JobConf jobConf, Configuration conf, InputSplit[] splits, float waves, int availableSlots, String inputName, boolean groupAcrossFiles) throws Exception {
        MapWork work = this.populateMapWork(jobConf, inputName);
        ArrayListMultimap bucketSplitMultiMap = ArrayListMultimap.create();
        int i = 0;
        InputSplit prevSplit = null;
        for (InputSplit s : splits) {
            if (this.schemaEvolved(s, prevSplit, groupAcrossFiles, work)) {
                ++i;
                prevSplit = s;
            }
            bucketSplitMultiMap.put((Object)i, (Object)s);
        }
        LOG.info((Object)("# Src groups for split generation: " + (i + 1)));
        Multimap<Integer, InputSplit> groupedSplits = grouper.group((Configuration)jobConf, (Multimap<Integer, InputSplit>)bucketSplitMultiMap, availableSlots, waves);
        return groupedSplits;
    }

    private MapWork populateMapWork(JobConf jobConf, String inputName) {
        MapWork work = null;
        if (inputName != null) {
            work = (MapWork)Utilities.getMergeWork(jobConf, inputName);
        }
        if (work == null) {
            work = Utilities.getMapWork((Configuration)jobConf);
        }
        return work;
    }

    public boolean schemaEvolved(InputSplit s, InputSplit prevSplit, boolean groupAcrossFiles, MapWork work) throws IOException {
        boolean retval = false;
        Path path = ((FileSplit)s).getPath();
        PartitionDesc pd = HiveFileFormatUtils.getPartitionDescFromPathRecursively(work.getPathToPartitionInfo(), path, cache);
        String currentDeserializerClass = pd.getDeserializerClassName();
        Class<? extends InputFormat> currentInputFormatClass = pd.getInputFileFormatClass();
        Class<? extends InputFormat> previousInputFormatClass = null;
        String previousDeserializerClass = null;
        if (prevSplit != null) {
            Path prevPath = ((FileSplit)prevSplit).getPath();
            if (!groupAcrossFiles) {
                return !path.equals((Object)prevPath);
            }
            PartitionDesc prevPD = HiveFileFormatUtils.getPartitionDescFromPathRecursively(work.getPathToPartitionInfo(), prevPath, cache);
            previousDeserializerClass = prevPD.getDeserializerClassName();
            previousInputFormatClass = prevPD.getInputFileFormatClass();
        }
        if (currentInputFormatClass != previousInputFormatClass || !currentDeserializerClass.equals(previousDeserializerClass)) {
            retval = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding split " + path + " to src new group? " + retval));
        }
        return retval;
    }

    private List<Event> createEventList(boolean sendSerializedEvents, InputSplitInfoMem inputSplitInfo) {
        ArrayList events = Lists.newArrayListWithCapacity((int)(inputSplitInfo.getNumTasks() + 1));
        InputConfigureVertexTasksEvent configureVertexEvent = InputConfigureVertexTasksEvent.create((int)inputSplitInfo.getNumTasks(), (VertexLocationHint)VertexLocationHint.create((List)inputSplitInfo.getTaskLocationHints()), (InputSpecUpdate)InputSpecUpdate.getDefaultSinglePhysicalInputSpecUpdate());
        events.add(configureVertexEvent);
        if (sendSerializedEvents) {
            MRRuntimeProtos.MRSplitsProto splitsProto = inputSplitInfo.getSplitsProto();
            int count = 0;
            for (MRRuntimeProtos.MRSplitProto mrSplit : splitsProto.getSplitsList()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)count++, (ByteBuffer)mrSplit.toByteString().asReadOnlyByteBuffer());
                events.add(diEvent);
            }
        } else {
            int count = 0;
            for (InputSplit split : inputSplitInfo.getOldFormatSplits()) {
                InputDataInformationEvent diEvent = InputDataInformationEvent.createWithObjectPayload((int)count++, (Object)split);
                events.add(diEvent);
            }
        }
        return events;
    }

    public void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        this.pruner.processVertex(stateUpdate.getVertexName());
    }

    public void handleInputInitializerEvent(List<InputInitializerEvent> events) throws Exception {
        for (InputInitializerEvent e : events) {
            this.pruner.addEvent(e);
        }
    }
}

