/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;

public class TezCacheAccess {
    private ObjectCache cache;
    private static final String CACHED_INPUT_KEY = "CACHED_INPUTS";
    private final ReentrantLock cachedInputLock = new ReentrantLock();

    private TezCacheAccess(ObjectCache cache) {
        this.cache = cache;
    }

    public static TezCacheAccess createInstance(Configuration conf) {
        ObjectCache cache = ObjectCacheFactory.getCache(conf);
        return new TezCacheAccess(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputCached(String inputName) {
        this.cachedInputLock.lock();
        try {
            Set cachedInputs = (Set)this.cache.retrieve(CACHED_INPUT_KEY);
            if (cachedInputs == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = cachedInputs.contains(inputName);
            return bl;
        }
        finally {
            this.cachedInputLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCachedInput(String inputName) {
        this.cachedInputLock.lock();
        try {
            Set cachedInputs = (Set)this.cache.retrieve(CACHED_INPUT_KEY);
            if (cachedInputs == null) {
                cachedInputs = Collections.newSetFromMap(new ConcurrentHashMap());
                this.cache.cache(CACHED_INPUT_KEY, cachedInputs);
            }
            cachedInputs.add(inputName);
        }
        finally {
            this.cachedInputLock.unlock();
        }
    }
}

