/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.Hook;

public class HookUtils {
    public static <T extends Hook> List<T> getHooks(HiveConf conf, HiveConf.ConfVars hookConfVar, Class<T> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] hookClasses;
        String csHooks = conf.getVar(hookConfVar);
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        if (csHooks == null) {
            return hooks;
        }
        if ((csHooks = csHooks.trim()).equals("")) {
            return hooks;
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            Hook hook = (Hook)Class.forName(hookClass.trim(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance();
            hooks.add(hook);
        }
        return hooks;
    }
}

