/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.CombineHiveRecordReader;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class CombineHiveInputFormat<K extends WritableComparable, V extends Writable>
extends HiveInputFormat<K, V> {
    private static final String CLASS_NAME = CombineHiveInputFormat.class.getName();
    public static final Log LOG = LogFactory.getLog((String)CLASS_NAME);

    /*
     * WARNING - void declaration
     */
    private InputSplit[] getCombineSplits(JobConf job, int numSplits) throws IOException {
        void var16_19;
        PerfLogger perfLogger = PerfLogger.getPerfLogger();
        perfLogger.PerfLogBegin(CLASS_NAME, "getSplits");
        this.init(job);
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = this.mrwork.getAliasToWork();
        HadoopShims.CombineFileInputFormatShim combine = ShimLoader.getHadoopShims().getCombineFileInputFormat();
        InputSplit[] splits = null;
        if (combine == null) {
            splits = super.getSplits(job, numSplits);
            perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
            return splits;
        }
        if (combine.getInputPathsShim(job).length == 0) {
            throw new IOException("No input paths specified in job");
        }
        ArrayList<CombineHiveInputSplit> result = new ArrayList<CombineHiveInputSplit>();
        Path[] paths = combine.getInputPathsShim(job);
        ArrayList<Path> inpDirs = new ArrayList<Path>();
        ArrayList<Path> inpFiles = new ArrayList<Path>();
        HashMap<CombinePathInputFormat, CombineFilter> poolMap = new HashMap<CombinePathInputFormat, CombineFilter>();
        HashSet<Path> poolSet = new HashSet<Path>();
        Path[] arr$ = paths;
        int len$ = arr$.length;
        boolean bl = false;
        while (var16_19 < len$) {
            Path path = arr$[var16_19];
            PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, path, IOPrepareCache.get().allocatePartitionDescMap());
            TableDesc tableDesc = part.getTableDesc();
            if (tableDesc != null && tableDesc.isNonNative()) {
                return super.getSplits(job, numSplits);
            }
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            String inputFormatClassName = inputFormatClass.getName();
            InputFormat<WritableComparable, Writable> inputFormat = CombineHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            String deserializerClassName = null;
            try {
                deserializerClassName = part.getDeserializer((Configuration)job).getClass().getName();
            }
            catch (Exception e) {
                // empty catch block
            }
            FileSystem inpFs = path.getFileSystem((Configuration)job);
            if (this.mrwork != null && !this.mrwork.getHadoopSupportsSplittable() && inputFormat instanceof TextInputFormat) {
                LinkedList<Path> dirs = new LinkedList<Path>();
                FileStatus fStats = inpFs.getFileStatus(path);
                if (fStats.isDir()) {
                    dirs.offer(path);
                } else if (new CompressionCodecFactory((Configuration)job).getCodec(path) != null) {
                    splits = super.getSplits(job, numSplits);
                    perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
                    return splits;
                }
                while (dirs.peek() != null) {
                    Path tstPath = (Path)dirs.remove();
                    FileStatus[] fStatus = inpFs.listStatus(tstPath);
                    for (int idx = 0; idx < fStatus.length; ++idx) {
                        if (fStatus[idx].isDir()) {
                            dirs.offer(fStatus[idx].getPath());
                            continue;
                        }
                        if (new CompressionCodecFactory((Configuration)job).getCodec(fStatus[idx].getPath()) == null) continue;
                        splits = super.getSplits(job, numSplits);
                        perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
                        return splits;
                    }
                }
            }
            if (inputFormat instanceof SymlinkTextInputFormat) {
                splits = super.getSplits(job, numSplits);
                perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
                return splits;
            }
            Path filterPath = path;
            CombineFilter f = null;
            List<Operator<? extends OperatorDesc>> opList = null;
            if (!this.mrwork.isMapperCannotSpanPartns()) {
                opList = HiveFileFormatUtils.doGetWorksFromPath(pathToAliases, aliasToWork, filterPath);
                CombinePathInputFormat combinePathInputFormat = new CombinePathInputFormat(opList, inputFormatClassName, deserializerClassName);
                f = (CombineFilter)poolMap.get(combinePathInputFormat);
                if (f == null) {
                    f = new CombineFilter(filterPath);
                    LOG.info((Object)("CombineHiveInputSplit creating pool for " + path + "; using filter path " + filterPath));
                    combine.createPool(job, new PathFilter[]{f});
                    poolMap.put(combinePathInputFormat, f);
                } else {
                    LOG.info((Object)("CombineHiveInputSplit: pool is already created for " + path + "; using filter path " + filterPath));
                    f.addPath(filterPath);
                }
            } else if (!path.getFileSystem((Configuration)job).getFileStatus(path).isDir()) {
                filterPath = path.getParent();
                inpFiles.add(path);
                poolSet.add(filterPath);
            } else {
                inpDirs.add(path);
            }
            ++var16_19;
        }
        List<Object> iss = new ArrayList();
        if (!this.mrwork.isMapperCannotSpanPartns()) {
            iss = Arrays.asList(combine.getSplits(job, 1));
        } else {
            for (Path path : inpDirs) {
                this.processPaths(job, combine, iss, path);
            }
            if (inpFiles.size() > 0) {
                for (Path path : poolSet) {
                    combine.createPool(job, new PathFilter[]{new CombineFilter(path)});
                }
                this.processPaths(job, combine, iss, inpFiles.toArray(new Path[0]));
            }
        }
        if (this.mrwork.getNameToSplitSample() != null && !this.mrwork.getNameToSplitSample().isEmpty()) {
            iss = this.sampleSplits(iss);
        }
        for (HadoopShims.InputSplitShim inputSplitShim : iss) {
            CombineHiveInputSplit csplit = new CombineHiveInputSplit(job, inputSplitShim);
            result.add(csplit);
        }
        LOG.info((Object)("number of splits " + result.size()));
        perfLogger.PerfLogEnd(CLASS_NAME, "getSplits");
        return (InputSplit[])result.toArray(new CombineHiveInputSplit[result.size()]);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.init(job);
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = this.mrwork.getAliasToWork();
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        Path[] paths = this.getInputPaths(job);
        ArrayList<Path> nonCombinablePaths = new ArrayList<Path>(paths.length / 2);
        ArrayList<Path> combinablePaths = new ArrayList<Path>(paths.length / 2);
        for (Path path : paths) {
            PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, path, IOPrepareCache.get().allocatePartitionDescMap());
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            String inputFormatClassName = inputFormatClass.getName();
            InputFormat<WritableComparable, Writable> inputFormat = CombineHiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            if (inputFormat instanceof AvoidSplitCombination && ((AvoidSplitCombination)inputFormat).shouldSkipCombine(path, (Configuration)job)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The split [" + path + "] is being parked for HiveInputFormat.getSplits"));
                }
                nonCombinablePaths.add(path);
                continue;
            }
            combinablePaths.add(path);
        }
        String oldPaths = job.get(HiveConf.ConfVars.HADOOPMAPREDINPUTDIR.varname);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The received input paths are: [" + oldPaths + "] against the property " + HiveConf.ConfVars.HADOOPMAPREDINPUTDIR.varname));
        }
        if (nonCombinablePaths.size() > 0) {
            InputSplit[] splits;
            FileInputFormat.setInputPaths((JobConf)job, (Path[])nonCombinablePaths.toArray(new Path[nonCombinablePaths.size()]));
            for (InputSplit split : splits = super.getSplits(job, numSplits)) {
                result.add(split);
            }
        }
        if (combinablePaths.size() > 0) {
            InputSplit[] splits;
            FileInputFormat.setInputPaths((JobConf)job, (Path[])combinablePaths.toArray(new Path[combinablePaths.size()]));
            for (InputSplit split : splits = this.getCombineSplits(job, numSplits)) {
                result.add(split);
            }
        }
        if (oldPaths != null) {
            job.set(HiveConf.ConfVars.HADOOPMAPREDINPUTDIR.varname, oldPaths);
        }
        LOG.info((Object)("Number of all splits " + result.size()));
        return result.toArray(new InputSplit[result.size()]);
    }

    private void processPaths(JobConf job, HadoopShims.CombineFileInputFormatShim combine, List<HadoopShims.InputSplitShim> iss, Path ... path) throws IOException {
        JobConf currJob = new JobConf((Configuration)job);
        FileInputFormat.setInputPaths((JobConf)currJob, (Path[])path);
        iss.addAll(Arrays.asList(combine.getSplits(currJob, 1)));
    }

    private List<HadoopShims.InputSplitShim> sampleSplits(List<HadoopShims.InputSplitShim> splits) {
        HashMap<String, SplitSample> nameToSamples = this.mrwork.getNameToSplitSample();
        ArrayList<HadoopShims.InputSplitShim> retLists = new ArrayList<HadoopShims.InputSplitShim>();
        HashMap aliasToSplitList = new HashMap();
        LinkedHashMap<String, ArrayList<String>> pathToAliases = this.mrwork.getPathToAliases();
        Map<String, ArrayList<String>> pathToAliasesNoScheme = this.removeScheme(pathToAliases);
        for (HadoopShims.InputSplitShim inputSplitShim : splits) {
            String alias = null;
            for (Path path : inputSplitShim.getPaths()) {
                boolean schemeless = path.toUri().getScheme() == null;
                List<String> l = HiveFileFormatUtils.doGetAliasesFromPath(schemeless ? pathToAliasesNoScheme : pathToAliases, path);
                if (l.size() != 1 || !nameToSamples.containsKey(l.get(0)) || alias != null && l.get(0) != alias) {
                    alias = null;
                    break;
                }
                alias = l.get(0);
            }
            if (alias != null) {
                if (!aliasToSplitList.containsKey(alias)) {
                    aliasToSplitList.put(alias, new ArrayList());
                }
                ((ArrayList)aliasToSplitList.get(alias)).add(inputSplitShim);
                continue;
            }
            retLists.add(inputSplitShim);
        }
        block2: for (Map.Entry entry : aliasToSplitList.entrySet()) {
            ArrayList splitList = (ArrayList)entry.getValue();
            long totalSize = 0L;
            for (HadoopShims.InputSplitShim split : splitList) {
                totalSize += split.getLength();
            }
            SplitSample splitSample = nameToSamples.get(entry.getKey());
            long targetSize = splitSample.getTargetSize(totalSize);
            int startIndex = splitSample.getSeedNum() % splitList.size();
            long size = 0L;
            for (int i = 0; i < splitList.size(); ++i) {
                HadoopShims.InputSplitShim split = (HadoopShims.InputSplitShim)splitList.get((startIndex + i) % splitList.size());
                retLists.add(split);
                long splitgLength = split.getLength();
                if (size + splitgLength >= targetSize) {
                    LOG.info((Object)("Sample alias " + entry.getValue() + " using " + (i + 1) + "splits"));
                    if (size + splitgLength <= targetSize) continue block2;
                    split.shrinkSplit(targetSize - size);
                    continue block2;
                }
                size += splitgLength;
            }
        }
        return retLists;
    }

    Map<String, ArrayList<String>> removeScheme(Map<String, ArrayList<String>> pathToAliases) {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, ArrayList<String>> entry : pathToAliases.entrySet()) {
            String newKey = new Path(entry.getKey()).toUri().getPath();
            result.put(newKey, entry.getValue());
        }
        return result;
    }

    @Override
    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        if (!(split instanceof CombineHiveInputSplit)) {
            return super.getRecordReader(split, job, reporter);
        }
        CombineHiveInputSplit hsplit = (CombineHiveInputSplit)split;
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        this.pushProjectionsAndFilters(job, inputFormatClass, hsplit.getPath(0).toString(), hsplit.getPath(0).toUri().getPath());
        return ShimLoader.getHadoopShims().getCombineFileInputFormat().getRecordReader(job, ((CombineHiveInputSplit)split).getInputSplitShim(), reporter, CombineHiveRecordReader.class);
    }

    public static interface AvoidSplitCombination {
        public boolean shouldSkipCombine(Path var1, Configuration var2) throws IOException;
    }

    static class CombineFilter
    implements PathFilter {
        private final Set<String> pStrings = new HashSet<String>();

        public CombineFilter(Path p) {
            this.addPath(p);
        }

        public void addPath(Path p) {
            String pString = p.toUri().getPath();
            this.pStrings.add(pString);
        }

        public boolean accept(Path path) {
            boolean find = false;
            while (path != null && !find) {
                if (this.pStrings.contains(path.toUri().getPath())) {
                    find = true;
                    break;
                }
                path = path.getParent();
            }
            return find;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("PathFilter: ");
            for (String pString : this.pStrings) {
                s.append(pString + " ");
            }
            return s.toString();
        }
    }

    private static class CombinePathInputFormat {
        private final List<Operator<? extends OperatorDesc>> opList;
        private final String inputFormatClassName;
        private final String deserializerClassName;

        public CombinePathInputFormat(List<Operator<? extends OperatorDesc>> opList, String inputFormatClassName, String deserializerClassName) {
            this.opList = opList;
            this.inputFormatClassName = inputFormatClassName;
            this.deserializerClassName = deserializerClassName;
        }

        public boolean equals(Object o) {
            if (o instanceof CombinePathInputFormat) {
                CombinePathInputFormat mObj = (CombinePathInputFormat)o;
                if (mObj == null) {
                    return false;
                }
                return this.opList.equals(mObj.opList) && this.inputFormatClassName.equals(mObj.inputFormatClassName) && (this.deserializerClassName == null ? mObj.deserializerClassName == null : this.deserializerClassName.equals(mObj.deserializerClassName));
            }
            return false;
        }

        public int hashCode() {
            return this.opList == null ? 0 : this.opList.hashCode();
        }
    }

    public static class CombineHiveInputSplit
    implements HadoopShims.InputSplitShim {
        String inputFormatClassName;
        HadoopShims.InputSplitShim inputSplitShim;

        public CombineHiveInputSplit() throws IOException {
            this(ShimLoader.getHadoopShims().getCombineFileInputFormat().getInputSplitShim());
        }

        public CombineHiveInputSplit(HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this(inputSplitShim.getJob(), inputSplitShim);
        }

        public CombineHiveInputSplit(JobConf job, HadoopShims.InputSplitShim inputSplitShim) throws IOException {
            this.inputSplitShim = inputSplitShim;
            if (job != null) {
                LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapWork((Configuration)job).getPathToPartitionInfo();
                Path[] ipaths = inputSplitShim.getPaths();
                if (ipaths.length > 0) {
                    PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, ipaths[0], IOPrepareCache.get().getPartitionDescMap());
                    this.inputFormatClassName = part.getInputFileFormatClass().getName();
                }
            }
        }

        public HadoopShims.InputSplitShim getInputSplitShim() {
            return this.inputSplitShim;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public void setInputFormatClassName(String inputFormatClassName) {
            this.inputFormatClassName = inputFormatClassName;
        }

        public JobConf getJob() {
            return this.inputSplitShim.getJob();
        }

        public long getLength() {
            return this.inputSplitShim.getLength();
        }

        public long[] getStartOffsets() {
            return this.inputSplitShim.getStartOffsets();
        }

        public long[] getLengths() {
            return this.inputSplitShim.getLengths();
        }

        public long getOffset(int i) {
            return this.inputSplitShim.getOffset(i);
        }

        public long getLength(int i) {
            return this.inputSplitShim.getLength(i);
        }

        public int getNumPaths() {
            return this.inputSplitShim.getNumPaths();
        }

        public Path getPath(int i) {
            return this.inputSplitShim.getPath(i);
        }

        public Path[] getPaths() {
            return this.inputSplitShim.getPaths();
        }

        public String[] getLocations() throws IOException {
            return this.inputSplitShim.getLocations();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.inputSplitShim.toString());
            sb.append("InputFormatClass: " + this.inputFormatClassName);
            sb.append("\n");
            return sb.toString();
        }

        public void readFields(DataInput in) throws IOException {
            this.inputSplitShim.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        public void write(DataOutput out) throws IOException {
            this.inputSplitShim.write(out);
            if (this.inputFormatClassName == null) {
                LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapWork((Configuration)this.getJob()).getPathToPartitionInfo();
                PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, this.inputSplitShim.getPath(0), IOPrepareCache.get().getPartitionDescMap());
                this.inputFormatClassName = part.getInputFileFormatClass().getName();
            }
            out.writeUTF(this.inputFormatClassName);
        }

        public void shrinkSplit(long length) {
            this.inputSplitShim.shrinkSplit(length);
        }
    }
}

