/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.stats;

import java.util.BitSet;
import org.apache.hadoop.hive.ql.optimizer.optiq.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveTableScanRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.stats.HiveRelMdDistinctRowCount;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.SqlTypeUtil;

public class FilterSelectivityEstimator
extends RexVisitorImpl<Double> {
    private final RelNode childRel;
    private final double childCardinality;

    protected FilterSelectivityEstimator(RelNode childRel) {
        super(true);
        this.childRel = childRel;
        this.childCardinality = RelMetadataQuery.getRowCount((RelNode)childRel);
    }

    public Double estimateSelectivity(RexNode predicate) {
        return (Double)predicate.accept((RexVisitor)this);
    }

    public Double visitCall(RexCall call) {
        if (!this.deep) {
            return 1.0;
        }
        if (this.isPartitionPredicate((RexNode)call, this.childRel)) {
            return 1.0;
        }
        Double selectivity = null;
        SqlKind op = this.getOp(call);
        switch (op) {
            case AND: {
                selectivity = this.computeConjunctionSelectivity(call);
                break;
            }
            case OR: {
                selectivity = this.computeDisjunctionSelectivity(call);
                break;
            }
            case NOT: 
            case NOT_EQUALS: {
                selectivity = this.computeNotEqualitySelectivity(call);
                break;
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                selectivity = 0.3333333333333333;
                break;
            }
            case IN: {
                selectivity = this.computeFunctionSelectivity(call) * (double)(call.operands.size() - 1);
                if (selectivity <= 0.0) {
                    selectivity = 0.1;
                    break;
                }
                if (!(selectivity >= 1.0)) break;
                selectivity = 1.0;
                break;
            }
            default: {
                selectivity = this.computeFunctionSelectivity(call);
            }
        }
        return selectivity;
    }

    private Double computeNotEqualitySelectivity(RexCall call) {
        double tmpNDV = this.getMaxNDV(call);
        if (tmpNDV > 1.0) {
            return (tmpNDV - 1.0) / tmpNDV;
        }
        return 1.0;
    }

    private Double computeFunctionSelectivity(RexCall call) {
        return 1.0 / this.getMaxNDV(call);
    }

    private Double computeDisjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode dje : call.getOperands()) {
            Double tmpCardinality;
            Double tmpSelectivity = (Double)dje.accept((RexVisitor)this);
            if (tmpSelectivity == null) {
                tmpSelectivity = 0.99;
            }
            tmpSelectivity = (tmpCardinality = Double.valueOf(this.childCardinality * tmpSelectivity)) > 1.0 && tmpCardinality < this.childCardinality ? Double.valueOf(1.0 - tmpCardinality / this.childCardinality) : Double.valueOf(1.0);
            selectivity *= tmpSelectivity.doubleValue();
        }
        if (selectivity < 0.0) {
            selectivity = 0.0;
        }
        return 1.0 - selectivity;
    }

    private Double computeConjunctionSelectivity(RexCall call) {
        double selectivity = 1.0;
        for (RexNode cje : call.getOperands()) {
            Double tmpSelectivity = (Double)cje.accept((RexVisitor)this);
            if (tmpSelectivity == null) continue;
            selectivity *= tmpSelectivity.doubleValue();
        }
        return selectivity;
    }

    private Double getMaxNDV(RexCall call) {
        double maxNDV = 1.0;
        for (RexNode op : call.getOperands()) {
            double tmpNDV;
            if (op instanceof RexInputRef) {
                tmpNDV = HiveRelMdDistinctRowCount.getDistinctRowCount(this.childRel, ((RexInputRef)op).getIndex());
                if (!(tmpNDV > maxNDV)) continue;
                maxNDV = tmpNDV;
                continue;
            }
            RelOptUtil.InputReferencedVisitor irv = new RelOptUtil.InputReferencedVisitor();
            irv.apply(op);
            for (Integer childProjIndx : irv.inputPosReferenced) {
                tmpNDV = HiveRelMdDistinctRowCount.getDistinctRowCount(this.childRel, childProjIndx);
                if (!(tmpNDV > maxNDV)) continue;
                maxNDV = tmpNDV;
            }
        }
        return maxNDV;
    }

    private boolean isPartitionPredicate(RexNode expr, RelNode r) {
        if (r instanceof ProjectRelBase) {
            expr = RelOptUtil.pushFilterPastProject((RexNode)expr, (ProjectRelBase)((ProjectRelBase)r));
            return this.isPartitionPredicate(expr, ((ProjectRelBase)r).getChild());
        }
        if (r instanceof FilterRelBase) {
            return this.isPartitionPredicate(expr, ((FilterRelBase)r).getChild());
        }
        if (r instanceof HiveTableScanRel) {
            RelOptHiveTable table = (RelOptHiveTable)((HiveTableScanRel)r).getTable();
            BitSet cols = RelOptUtil.InputFinder.bits((RexNode)expr);
            return table.containsPartitionColumnsOnly(cols);
        }
        return false;
    }

    private SqlKind getOp(RexCall call) {
        SqlKind op = call.getKind();
        if (call.getKind().equals((Object)SqlKind.OTHER_FUNCTION) && SqlTypeUtil.inBooleanFamily((RelDataType)call.getType())) {
            String opName;
            SqlOperator sqlOp = call.getOperator();
            String string = opName = sqlOp != null ? sqlOp.getName() : "";
            if (opName.equalsIgnoreCase("in")) {
                op = SqlKind.IN;
            }
        }
        return op;
    }
}

