/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.optiq.stats;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.BuiltinMethod;
import org.apache.hadoop.hive.ql.optimizer.optiq.HiveOptiqUtil;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveJoinRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.reloperators.HiveTableScanRel;
import org.apache.hadoop.hive.ql.optimizer.optiq.stats.FilterSelectivityEstimator;
import org.apache.hadoop.hive.ql.optimizer.optiq.stats.HiveRelMdDistinctRowCount;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdSelectivity;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

public class HiveRelMdSelectivity
extends RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltinMethod.SELECTIVITY.method, (Object)((Object)new HiveRelMdSelectivity()));

    protected HiveRelMdSelectivity() {
    }

    public Double getSelectivity(HiveTableScanRel t, RexNode predicate) {
        if (predicate != null) {
            FilterSelectivityEstimator filterSelEstmator = new FilterSelectivityEstimator(t);
            return filterSelEstmator.estimateSelectivity(predicate);
        }
        return 1.0;
    }

    public Double getSelectivity(HiveJoinRel j, RexNode predicate) {
        if (j.getJoinType().equals((Object)JoinRelType.INNER)) {
            return this.computeInnerJoinSelectivity(j, predicate);
        }
        return 1.0;
    }

    private Double computeInnerJoinSelectivity(HiveJoinRel j, RexNode predicate) {
        double ndvCrossProduct = 1.0;
        Pair<Boolean, RexNode> predInfo = this.getCombinedPredicateForJoin(j, predicate);
        if (!((Boolean)predInfo.getKey()).booleanValue()) {
            return new FilterSelectivityEstimator(j).estimateSelectivity((RexNode)predInfo.getValue());
        }
        RexNode combinedPredicate = (RexNode)predInfo.getValue();
        HiveOptiqUtil.JoinPredicateInfo jpi = HiveOptiqUtil.JoinPredicateInfo.constructJoinPredicateInfo(j, combinedPredicate);
        ImmutableMap.Builder colStatMapBuilder = ImmutableMap.builder();
        int rightOffSet = j.getLeft().getRowType().getFieldCount();
        for (Integer ljk : jpi.getProjsFromLeftPartOfJoinKeysInChildSchema()) {
            colStatMapBuilder.put((Object)ljk, (Object)HiveRelMdDistinctRowCount.getDistinctRowCount(j.getLeft(), ljk));
        }
        for (Integer rjk : jpi.getProjsFromRightPartOfJoinKeysInChildSchema()) {
            colStatMapBuilder.put((Object)(rjk + rightOffSet), (Object)HiveRelMdDistinctRowCount.getDistinctRowCount(j.getRight(), rjk));
        }
        ImmutableMap colStatMap = colStatMapBuilder.build();
        List<HiveOptiqUtil.JoinLeafPredicateInfo> peLst = jpi.getEquiJoinPredicateElements();
        int noOfPE = peLst.size();
        if (noOfPE > 0) {
            ndvCrossProduct = this.exponentialBackoff(peLst, (ImmutableMap<Integer, Double>)colStatMap);
            ndvCrossProduct = j.isLeftSemiJoin() ? Math.min(RelMetadataQuery.getRowCount((RelNode)j.getLeft()), ndvCrossProduct) : Math.min(RelMetadataQuery.getRowCount((RelNode)j.getLeft()) * RelMetadataQuery.getRowCount((RelNode)j.getRight()), ndvCrossProduct);
        }
        return 1.0 / ndvCrossProduct;
    }

    protected double logSmoothing(List<HiveOptiqUtil.JoinLeafPredicateInfo> peLst, ImmutableMap<Integer, Double> colStatMap) {
        int noOfPE = peLst.size();
        double ndvCrossProduct = HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(0), colStatMap);
        if (noOfPE > 1) {
            double maxNDVSoFar = ndvCrossProduct;
            for (int i = 1; i < noOfPE; ++i) {
                double ndvToBeSmoothed;
                double tmpNDV = HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(i), colStatMap);
                if (tmpNDV > maxNDVSoFar) {
                    ndvToBeSmoothed = maxNDVSoFar;
                    maxNDVSoFar = tmpNDV;
                    ndvCrossProduct = ndvCrossProduct / ndvToBeSmoothed * tmpNDV;
                } else {
                    ndvToBeSmoothed = tmpNDV;
                }
                if (ndvToBeSmoothed > 3.0) {
                    ndvCrossProduct *= Math.log(ndvToBeSmoothed);
                    continue;
                }
                ndvCrossProduct *= ndvToBeSmoothed;
            }
        }
        return ndvCrossProduct;
    }

    protected double exponentialBackoff(List<HiveOptiqUtil.JoinLeafPredicateInfo> peLst, ImmutableMap<Integer, Double> colStatMap) {
        int noOfPE = peLst.size();
        ArrayList<Double> ndvs = new ArrayList<Double>(noOfPE);
        for (int i = 0; i < noOfPE; ++i) {
            ndvs.add(HiveRelMdSelectivity.getMaxNDVForJoinSelectivity(peLst.get(i), colStatMap));
        }
        Collections.sort(ndvs);
        Collections.reverse(ndvs);
        double ndvCrossProduct = 1.0;
        for (int i = 0; i < ndvs.size(); ++i) {
            double n = Math.pow((Double)ndvs.get(i), Math.pow(0.5, i));
            ndvCrossProduct *= n;
        }
        return ndvCrossProduct;
    }

    private Pair<Boolean, RexNode> getCombinedPredicateForJoin(HiveJoinRel j, RexNode additionalPredicate) {
        RexNode minusPred = RelMdUtil.minusPreds((RexBuilder)j.getCluster().getRexBuilder(), (RexNode)additionalPredicate, (RexNode)j.getCondition());
        if (minusPred != null) {
            ArrayList<RexNode> minusList = new ArrayList<RexNode>();
            minusList.add(j.getCondition());
            minusList.add(minusPred);
            return new Pair((Object)false, (Object)minusPred);
        }
        return new Pair((Object)true, (Object)j.getCondition());
    }

    private static Double getMaxNDVForJoinSelectivity(HiveOptiqUtil.JoinLeafPredicateInfo jlpi, ImmutableMap<Integer, Double> colStatMap) {
        Double maxNDVSoFar = 1.0;
        maxNDVSoFar = HiveRelMdSelectivity.getMaxNDVFromProjections(colStatMap, jlpi.getProjsFromLeftPartOfJoinKeysInJoinSchema(), maxNDVSoFar);
        maxNDVSoFar = HiveRelMdSelectivity.getMaxNDVFromProjections(colStatMap, jlpi.getProjsFromRightPartOfJoinKeysInJoinSchema(), maxNDVSoFar);
        return maxNDVSoFar;
    }

    private static Double getMaxNDVFromProjections(Map<Integer, Double> colStatMap, Set<Integer> projectionSet, Double defaultMaxNDV) {
        Double colNDV = null;
        Double maxNDVSoFar = defaultMaxNDV;
        for (Integer projIndx : projectionSet) {
            colNDV = colStatMap.get(projIndx);
            if (!(colNDV > maxNDVSoFar)) continue;
            maxNDVSoFar = colNDV;
        }
        return maxNDVSoFar;
    }
}

