/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;

public class BucketMapJoinContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Map<String, List<String>>> aliasBucketFileNameMapping;
    private String mapJoinBigTableAlias;
    private Class<? extends BucketMatcher> bucketMatcherClass;
    private transient Map<String, Map<String, List<String>>> aliasBucketBaseFileNameMapping;
    private Map<String, Integer> bucketFileNameMapping;
    private Map<String, List<String>> bigTablePartSpecToFileMapping;
    private transient Map<String, String> inputToPartSpecMapping;
    private static final Pattern partPattern = Pattern.compile("^[^=]+=[^=]+$");

    public BucketMapJoinContext() {
    }

    public BucketMapJoinContext(MapJoinDesc clone) {
        this.mapJoinBigTableAlias = clone.getBigTableAlias();
        this.aliasBucketFileNameMapping = clone.getAliasBucketFileNameMapping();
        this.bucketFileNameMapping = clone.getBigTableBucketNumMapping();
        this.bigTablePartSpecToFileMapping = clone.getBigTablePartSpecToFileMapping();
    }

    public void setMapJoinBigTableAlias(String bigTableAlias) {
        this.mapJoinBigTableAlias = bigTableAlias;
    }

    public void deriveBucketMapJoinMapping() {
        if (this.aliasBucketFileNameMapping != null) {
            this.aliasBucketBaseFileNameMapping = new LinkedHashMap<String, Map<String, List<String>>>();
            for (Map.Entry<String, Map<String, List<String>>> aliasToMappins : this.aliasBucketFileNameMapping.entrySet()) {
                String tableAlias = aliasToMappins.getKey();
                Map<String, List<String>> fullPathMappings = aliasToMappins.getValue();
                LinkedHashMap baseFileNameMapping = new LinkedHashMap();
                for (Map.Entry<String, List<String>> inputToBuckets : fullPathMappings.entrySet()) {
                    String inputPath = inputToBuckets.getKey();
                    List<String> bucketPaths = inputToBuckets.getValue();
                    ArrayList<String> bucketBaseFileNames = new ArrayList<String>(bucketPaths.size());
                    for (String bucketFName : bucketPaths) {
                        bucketBaseFileNames.add(this.getBaseFileName(bucketFName));
                    }
                    baseFileNameMapping.put(this.getBaseFileName(inputPath), bucketBaseFileNames);
                }
                this.aliasBucketBaseFileNameMapping.put(tableAlias, baseFileNameMapping);
            }
        }
    }

    private String getBaseFileName(String string) {
        try {
            Path path = new Path(string);
            Path cursor = path.getParent();
            while (partPattern.matcher(cursor.getName()).matches()) {
                cursor = cursor.getParent();
            }
            return cursor.toUri().relativize(path.toUri()).getPath();
        }
        catch (Exception ex) {
            return string;
        }
    }

    public String getMapJoinBigTableAlias() {
        return this.mapJoinBigTableAlias;
    }

    public Class<? extends BucketMatcher> getBucketMatcherClass() {
        return this.bucketMatcherClass;
    }

    public void setBucketMatcherClass(Class<? extends BucketMatcher> bucketMatcherClass) {
        this.bucketMatcherClass = bucketMatcherClass;
    }

    @Explain(displayName="Alias Bucket File Name Mapping", normalExplain=false)
    public Map<String, Map<String, List<String>>> getAliasBucketFileNameMapping() {
        return this.aliasBucketFileNameMapping;
    }

    public void setAliasBucketFileNameMapping(Map<String, Map<String, List<String>>> aliasBucketFileNameMapping) {
        this.aliasBucketFileNameMapping = aliasBucketFileNameMapping;
    }

    public String toString() {
        if (this.aliasBucketFileNameMapping != null) {
            return "Mapping:" + this.aliasBucketFileNameMapping.toString();
        }
        return "";
    }

    @Explain(displayName="Alias Bucket Base File Name Mapping", normalExplain=false)
    public Map<String, Map<String, List<String>>> getAliasBucketBaseFileNameMapping() {
        return this.aliasBucketBaseFileNameMapping;
    }

    public void setAliasBucketBaseFileNameMapping(Map<String, Map<String, List<String>>> aliasBucketBaseFileNameMapping) {
        this.aliasBucketBaseFileNameMapping = aliasBucketBaseFileNameMapping;
    }

    @Explain(displayName="Alias Bucket Output File Name Mapping", normalExplain=false)
    public Map<String, Integer> getBucketFileNameMapping() {
        return this.bucketFileNameMapping;
    }

    public void setBucketFileNameMapping(Map<String, Integer> bucketFileNameMapping) {
        this.bucketFileNameMapping = bucketFileNameMapping;
    }

    public Map<String, List<String>> getBigTablePartSpecToFileMapping() {
        return this.bigTablePartSpecToFileMapping;
    }

    public void setBigTablePartSpecToFileMapping(Map<String, List<String>> bigTablePartSpecToFileMapping) {
        this.bigTablePartSpecToFileMapping = bigTablePartSpecToFileMapping;
    }

    public String createFileId(String inputPath) {
        String bucketNum = String.valueOf(this.bucketFileNameMapping.get(inputPath));
        if (this.bigTablePartSpecToFileMapping != null) {
            return this.prependPartSpec(inputPath, bucketNum);
        }
        return bucketNum;
    }

    public String createFileName(String inputPath, String fileName) {
        if (this.bigTablePartSpecToFileMapping != null) {
            return this.prependPartSpec(inputPath, fileName);
        }
        return fileName;
    }

    private String prependPartSpec(String inputPath, String fileName) {
        Map<String, String> mapping = this.inputToPartSpecMapping == null ? (this.inputToPartSpecMapping = this.revert(this.bigTablePartSpecToFileMapping)) : this.inputToPartSpecMapping;
        String partSpec = mapping.get(URI.create(inputPath).getPath());
        return partSpec == null || partSpec.isEmpty() ? fileName : "(" + FileUtils.escapePathName((String)partSpec) + ")" + fileName;
    }

    private Map<String, String> revert(Map<String, List<String>> mapping) {
        HashMap<String, String> converted = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : mapping.entrySet()) {
            String partSpec = entry.getKey();
            for (String file : entry.getValue()) {
                converted.put(URI.create(file).getPath(), partSpec);
            }
        }
        return converted;
    }
}

