/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create Role")
public class RoleDDLDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private PrincipalType principalType;
    private boolean group;
    private RoleOperation operation;
    private String resFile;
    private String roleOwnerName;
    private static final String roleNameSchema = "role#string";
    private static final String roleShowGrantSchema = "role,grant_option,grant_time,grantor#string:boolean:bigint:string";
    private static final String roleShowRolePrincipals = "principal_name,principal_type,grant_option,grantor,grantor_type,grant_time#string:string:boolean:string:string:bigint";

    public static String getRoleNameSchema() {
        return roleNameSchema;
    }

    public static String getRoleShowGrantSchema() {
        return roleShowGrantSchema;
    }

    public static String getShowRolePrincipalsSchema() {
        return roleShowRolePrincipals;
    }

    public RoleDDLDesc() {
    }

    public RoleDDLDesc(String roleName, RoleOperation operation) {
        this(roleName, PrincipalType.USER, operation, null);
    }

    public RoleDDLDesc(String principalName, PrincipalType principalType, RoleOperation operation, String roleOwnerName) {
        this.name = principalName;
        this.principalType = principalType;
        this.operation = operation;
        this.roleOwnerName = roleOwnerName;
    }

    @Explain(displayName="name")
    public String getName() {
        return this.name;
    }

    @Explain(displayName="role operation")
    public RoleOperation getOperation() {
        return this.operation;
    }

    public void setOperation(RoleOperation operation) {
        this.operation = operation;
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
    }

    public boolean getGroup() {
        return this.group;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public String getResFile() {
        return this.resFile;
    }

    public void setResFile(String resFile) {
        this.resFile = resFile;
    }

    public String getRoleOwnerName() {
        return this.roleOwnerName;
    }

    public void setRoleOwnerName(String roleOwnerName) {
        this.roleOwnerName = roleOwnerName;
    }

    public static enum RoleOperation {
        DROP_ROLE("drop_role"),
        CREATE_ROLE("create_role"),
        SHOW_ROLE_GRANT("show_role_grant"),
        SHOW_ROLES("show_roles"),
        SET_ROLE("set_role"),
        SHOW_CURRENT_ROLE("show_current_role"),
        SHOW_ROLE_PRINCIPALS("show_role_principals");

        private String operationName;

        private RoleOperation() {
        }

        private RoleOperation(String operationName) {
            this.operationName = operationName;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

