/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsLongToLong;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="abs", value="_FUNC_(x) - returns the absolute value of x", extended="Example:\n  > SELECT _FUNC_(0) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(-5) FROM src LIMIT 1;\n  5")
@VectorizedExpressions(value={FuncAbsLongToLong.class, FuncAbsDoubleToDouble.class, FuncAbsDecimalToDecimal.class})
public class GenericUDFAbs
extends GenericUDF {
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType;
    private final DoubleWritable resultDouble = new DoubleWritable();
    private final LongWritable resultLong = new LongWritable();
    private final IntWritable resultInt = new IntWritable();
    private transient PrimitiveObjectInspector argumentOI;
    private transient ObjectInspectorConverters.Converter inputConverter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ABS() requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("ABS only takes primitive types, got " + arguments[0].getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.inputType = this.argumentOI.getPrimitiveCategory();
        WritableIntObjectInspector outputOI = null;
        switch (this.inputType) {
            case SHORT: 
            case BYTE: 
            case INT: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
                break;
            }
            case LONG: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableLongObjectInspector;
                break;
            }
            case FLOAT: 
            case STRING: 
            case DOUBLE: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
                break;
            }
            case DECIMAL: {
                this.inputConverter = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector);
                outputOI = PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector;
                break;
            }
            default: {
                throw new UDFArgumentException("ABS only takes SHORT/BYTE/INT/LONG/DOUBLE/FLOAT/STRING/DECIMAL types, got " + this.inputType);
            }
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject = arguments[0].get();
        if (valObject == null) {
            return null;
        }
        switch (this.inputType) {
            case SHORT: 
            case BYTE: 
            case INT: {
                valObject = this.inputConverter.convert(valObject);
                this.resultInt.set(Math.abs(((IntWritable)valObject).get()));
                return this.resultInt;
            }
            case LONG: {
                valObject = this.inputConverter.convert(valObject);
                this.resultLong.set(Math.abs(((LongWritable)valObject).get()));
                return this.resultLong;
            }
            case FLOAT: 
            case STRING: 
            case DOUBLE: {
                valObject = this.inputConverter.convert(valObject);
                this.resultDouble.set(Math.abs(((DoubleWritable)valObject).get()));
                return this.resultDouble;
            }
            case DECIMAL: {
                return PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector.set(PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector.create(HiveDecimal.ZERO), PrimitiveObjectInspectorUtils.getHiveDecimal((Object)valObject, (PrimitiveObjectInspector)this.argumentOI).abs());
            }
        }
        throw new UDFArgumentException("ABS only takes SHORT/BYTE/INT/LONG/DOUBLE/FLOAT/STRING/DECIMAL types, got " + this.inputType);
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("abs(");
        if (children.length > 0) {
            sb.append(children[0]);
            for (int i = 1; i < children.length; ++i) {
                sb.append(",");
                sb.append(children[i]);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

