/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.metrics.GobblinMetrics;
import org.apache.gobblin.metrics.Tag;

@Alpha
public class ContainerMetrics
extends GobblinMetrics {
    protected ContainerMetrics(State containerState, String applicationName, String taskRunnerId) {
        super(ContainerMetrics.name(taskRunnerId), null, ContainerMetrics.tagsForContainer(containerState, applicationName, taskRunnerId));
    }

    public static ContainerMetrics get(final State containerState, final String applicationName, final String workerId) {
        return (ContainerMetrics)GOBBLIN_METRICS_REGISTRY.getOrDefault(ContainerMetrics.name(workerId), (Callable)new Callable<GobblinMetrics>(){

            @Override
            public GobblinMetrics call() throws Exception {
                return new ContainerMetrics(containerState, applicationName, workerId);
            }
        });
    }

    private static String name(String workerId) {
        return "gobblin.metrics." + workerId;
    }

    private static List<Tag<?>> tagsForContainer(State containerState, String applicationName, String taskRunnerId) {
        ImmutableList.Builder tags = new ImmutableList.Builder();
        tags.add((Object)new Tag("application.name", (Object)applicationName));
        tags.add((Object)new Tag("task.runner.id", (Object)taskRunnerId));
        tags.addAll((Iterable)ContainerMetrics.getCustomTagsFromState((State)containerState));
        return tags.build();
    }
}

