/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Throwables;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.GobblinClusterUtils;
import org.apache.gobblin.cluster.SingleTask;
import org.apache.gobblin.cluster.TaskAttemptBuilder;
import org.apache.gobblin.runtime.util.StateStores;
import org.apache.gobblin.util.Id;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskCallbackContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Alpha
public class GobblinHelixTask
implements Task {
    private static final Logger _logger = LoggerFactory.getLogger(GobblinHelixTask.class);
    private final TaskConfig taskConfig;
    private String jobName;
    private String jobId;
    private String jobKey;
    private Path workUnitFilePath;
    private SingleTask task;

    public GobblinHelixTask(TaskCallbackContext taskCallbackContext, FileSystem fs, Path appWorkDir, TaskAttemptBuilder taskAttemptBuilder, StateStores stateStores) throws IOException {
        this.taskConfig = taskCallbackContext.getTaskConfig();
        this.getInfoFromTaskConfig();
        Path jobStateFilePath = GobblinClusterUtils.getJobStateFilePath(stateStores.haveJobStateStore(), appWorkDir, this.jobId);
        this.task = new SingleTask(this.jobId, this.workUnitFilePath, jobStateFilePath, fs, taskAttemptBuilder, stateStores);
    }

    private void getInfoFromTaskConfig() {
        Map configMap = this.taskConfig.getConfigMap();
        this.jobName = (String)configMap.get("job.name");
        this.jobId = (String)configMap.get("job.id");
        this.jobKey = Long.toString(Id.parse((String)this.jobId).getSequence());
        this.workUnitFilePath = new Path((String)configMap.get("gobblin.cluster.work.unit.file.path"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskResult run() {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)MDC.putCloseable((String)"job.name", (String)this.jobName));
            closer.register((Closeable)MDC.putCloseable((String)"job.key", (String)this.jobKey));
            this.task.run();
            TaskResult taskResult = new TaskResult(TaskResult.Status.COMPLETED, "");
            return taskResult;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return new TaskResult(TaskResult.Status.CANCELED, "");
        }
        catch (Throwable t) {
            _logger.error("GobblinHelixTask failed due to " + t.getMessage(), t);
            return new TaskResult(TaskResult.Status.FAILED, Throwables.getStackTraceAsString((Throwable)t));
        }
    }

    public void cancel() {
        this.task.cancel();
    }
}

