/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.codahale.metrics.Counter;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.ContainerMetrics;
import org.apache.gobblin.cluster.GobblinHelixTask;
import org.apache.gobblin.cluster.TaskAttemptBuilder;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.TaskExecutor;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.runtime.util.StateStores;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.helix.HelixManager;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskCallbackContext;
import org.apache.helix.task.TaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GobblinHelixTaskFactory
implements TaskFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GobblinHelixTaskFactory.class);
    private static final String GOBBLIN_CLUSTER_NEW_HELIX_TASK_COUNTER = "gobblin.cluster.new.helix.task";
    private final Optional<ContainerMetrics> containerMetrics;
    private final HelixManager helixManager;
    private final Optional<Counter> newTasksCounter;
    private final TaskExecutor taskExecutor;
    private final TaskStateTracker taskStateTracker;
    private final FileSystem fs;
    private final Path appWorkDir;
    private final StateStores stateStores;
    private final TaskAttemptBuilder taskAttemptBuilder;

    public GobblinHelixTaskFactory(Optional<ContainerMetrics> containerMetrics, TaskExecutor taskExecutor, TaskStateTracker taskStateTracker, FileSystem fs, Path appWorkDir, Config config, HelixManager helixManager) {
        this.containerMetrics = containerMetrics;
        this.helixManager = helixManager;
        this.newTasksCounter = this.containerMetrics.isPresent() ? Optional.of((Object)((ContainerMetrics)((Object)this.containerMetrics.get())).getCounter(GOBBLIN_CLUSTER_NEW_HELIX_TASK_COUNTER, new String[0])) : Optional.absent();
        this.taskExecutor = taskExecutor;
        this.taskStateTracker = taskStateTracker;
        this.fs = fs;
        this.appWorkDir = appWorkDir;
        this.stateStores = new StateStores(config, appWorkDir, "_taskstates", appWorkDir, "_workunits", appWorkDir, "_jobstates");
        this.taskAttemptBuilder = this.createTaskAttemptBuilder();
    }

    private TaskAttemptBuilder createTaskAttemptBuilder() {
        TaskAttemptBuilder builder = new TaskAttemptBuilder(this.taskStateTracker, this.taskExecutor);
        builder.setContainerId(this.helixManager.getInstanceName());
        builder.setTaskStateStore((StateStore<TaskState>)this.stateStores.getTaskStateStore());
        return builder;
    }

    public Task createNewTask(TaskCallbackContext context) {
        try {
            if (this.newTasksCounter.isPresent()) {
                ((Counter)this.newTasksCounter.get()).inc();
            }
            return new GobblinHelixTask(context, this.fs, this.appWorkDir, this.taskAttemptBuilder, this.stateStores);
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to create a new GobblinHelixTask", (Throwable)ioe);
            throw Throwables.propagate((Throwable)ioe);
        }
    }
}

