/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import org.apache.gobblin.instrumented.StandardMetricsBridge;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.TaskExecutor;

public class GobblinTaskRunnerMetrics {

    static class JvmTaskRunnerMetrics
    extends StandardMetricsBridge.StandardMetrics {
        JvmTaskRunnerMetrics() {
        }

        public String getName() {
            return JvmTaskRunnerMetrics.class.getName();
        }
    }

    static class InProcessTaskRunnerMetrics
    extends StandardMetricsBridge.StandardMetrics {
        private TaskExecutor taskExecutor;
        private static String CURRENT_QUEUED_TASK_COUNT = "currentQueuedTaskCount";
        private static String HISTORICAL_QUEUED_TASK_COUNT = "historicalQueuedTaskCount";
        private static String QUEUED_TASK_COUNT = "queuedTaskCount";
        private static String CURRENT_QUEUED_TASK_TOTAL_TIME = "currentQueuedTaskTotalTime";
        private static String HISTORICAL_QUEUED_TASK_TOTAL_TIME = "historicalQueuedTaskTotalTime";
        private static String QUEUED_TASK_TOTAL_TIME = "queuedTaskTotalTime";
        private static String FAILED_TASK_COUNT = "failedTaskCount";
        private static String SUCCESSFUL_TASK_COUNT = "successfulTaskCount";
        private static String RUNNING_TASK_COUNT = "runningTaskCount";

        public InProcessTaskRunnerMetrics(TaskExecutor executor, MetricContext context) {
            this.taskExecutor = executor;
            this.contextAwareMetrics.add(context.newContextAwareGauge(CURRENT_QUEUED_TASK_COUNT, () -> this.taskExecutor.getCurrentQueuedTaskCount().longValue()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(CURRENT_QUEUED_TASK_TOTAL_TIME, () -> this.taskExecutor.getCurrentQueuedTaskTotalTime().longValue()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(HISTORICAL_QUEUED_TASK_COUNT, () -> this.taskExecutor.getHistoricalQueuedTaskCount().longValue()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(HISTORICAL_QUEUED_TASK_TOTAL_TIME, () -> this.taskExecutor.getHistoricalQueuedTaskTotalTime().longValue()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(QUEUED_TASK_COUNT, () -> this.taskExecutor.getQueuedTaskCount().longValue()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(QUEUED_TASK_TOTAL_TIME, () -> this.taskExecutor.getQueuedTaskTotalTime().longValue()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(FAILED_TASK_COUNT, () -> this.taskExecutor.getFailedTaskCount().getCount()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(SUCCESSFUL_TASK_COUNT, () -> this.taskExecutor.getSuccessfulTaskCount().getCount()));
            this.contextAwareMetrics.add(context.newContextAwareGauge(RUNNING_TASK_COUNT, () -> this.taskExecutor.getRunningTaskCount().getCount()));
            this.rawMetrics.put("workunit.creation.and.run.interval", this.taskExecutor.getTaskCreateAndRunTimer());
        }

        public String getName() {
            return InProcessTaskRunnerMetrics.class.getName();
        }
    }
}

