/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.codahale.metrics.Counter;
import com.google.common.base.Optional;
import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.gobblin.cluster.ContainerMetrics;
import org.apache.gobblin.cluster.GobblinClusterException;
import org.apache.gobblin.cluster.SingleHelixTask;
import org.apache.gobblin.cluster.SingleTaskLauncher;
import org.apache.gobblin.util.GobblinProcessBuilder;
import org.apache.gobblin.util.SystemPropertiesWrapper;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskCallbackContext;
import org.apache.helix.task.TaskFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixTaskFactory
implements TaskFactory {
    private static final Logger logger = LoggerFactory.getLogger(HelixTaskFactory.class);
    private static final String GOBBLIN_CLUSTER_NEW_HELIX_TASK_COUNTER = "gobblin.cluster.new.helix.task";
    private final Optional<ContainerMetrics> containerMetrics;
    private final Optional<Counter> newTasksCounter;
    private final SingleTaskLauncher launcher;

    public HelixTaskFactory(Optional<ContainerMetrics> containerMetrics, Path clusterConfPath, Config sysConfig) {
        this.containerMetrics = containerMetrics;
        this.newTasksCounter = this.containerMetrics.isPresent() ? Optional.of((Object)((ContainerMetrics)((Object)this.containerMetrics.get())).getCounter(GOBBLIN_CLUSTER_NEW_HELIX_TASK_COUNTER, new String[0])) : Optional.absent();
        this.launcher = new SingleTaskLauncher(new GobblinProcessBuilder(), new SystemPropertiesWrapper(), clusterConfPath, sysConfig);
    }

    public Task createNewTask(TaskCallbackContext context) {
        try {
            if (this.newTasksCounter.isPresent()) {
                ((Counter)this.newTasksCounter.get()).inc();
            }
            Map configMap = context.getTaskConfig().getConfigMap();
            return new SingleHelixTask(this.launcher, configMap);
        }
        catch (IOException ioe) {
            String msg = "Failed to create a new SingleHelixTask";
            logger.error("Failed to create a new SingleHelixTask", (Throwable)ioe);
            throw new GobblinClusterException("Failed to create a new SingleHelixTask", ioe);
        }
    }
}

