/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.typesafe.config.Config;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.cluster.JobConfigurationManager;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.Spec;
import org.apache.gobblin.runtime.api.SpecConsumer;
import org.apache.gobblin.runtime.api.SpecExecutor;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.ExecutorsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class ScheduledJobConfigurationManager
extends JobConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledJobConfigurationManager.class);
    private static final long DEFAULT_JOB_SPEC_REFRESH_INTERVAL = 60L;
    private Map<URI, JobSpec> jobSpecs = Maps.newHashMap();
    private final long refreshIntervalInSeconds;
    private final ScheduledExecutorService fetchJobSpecExecutor;
    private final SpecConsumer _specConsumer;
    private final ClassAliasResolver<SpecConsumer> aliasResolver;

    public ScheduledJobConfigurationManager(EventBus eventBus, Config config) {
        super(eventBus, config);
        this.refreshIntervalInSeconds = ConfigUtils.getLong((Config)config, (String)"gobblin.cluster.job.spec.refresh.interval", (Long)60L);
        this.fetchJobSpecExecutor = Executors.newSingleThreadScheduledExecutor(ExecutorsUtils.newThreadFactory((Optional)Optional.of((Object)LOGGER), (Optional)Optional.of((Object)"FetchJobSpecExecutor")));
        this.aliasResolver = new ClassAliasResolver(SpecConsumer.class);
        try {
            String specConsumerClassName = "org.apache.gobblin.service.SimpleKafkaSpecConsumer";
            if (config.hasPath("gobblin.cluster.specConsumer.class")) {
                specConsumerClassName = config.getString("gobblin.cluster.specConsumer.class");
            }
            LOGGER.info("Using SpecConsumer ClassNameclass name/alias " + specConsumerClassName);
            this._specConsumer = (SpecConsumer)ConstructorUtils.invokeConstructor(Class.forName(this.aliasResolver.resolve(specConsumerClassName)), (Object[])new Object[]{config});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void startUp() throws Exception {
        LOGGER.info("Starting the " + ScheduledJobConfigurationManager.class.getSimpleName());
        LOGGER.info(String.format("Scheduling the job spec refresh task with an interval of %d second(s)", this.refreshIntervalInSeconds));
        this.fetchJobSpecExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ScheduledJobConfigurationManager.this.fetchJobSpecs();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error("Failed to fetch job specs", (Throwable)e);
                    throw new RuntimeException("Failed to fetch specs", e);
                }
            }
        }, 0L, this.refreshIntervalInSeconds, TimeUnit.SECONDS);
    }

    private void fetchJobSpecs() throws ExecutionException, InterruptedException {
        List changesSpecs = (List)this._specConsumer.changedSpecs().get();
        for (Pair entry : changesSpecs) {
            JobSpec jobSpec;
            SpecExecutor.Verb verb = (SpecExecutor.Verb)entry.getKey();
            if (verb.equals((Object)SpecExecutor.Verb.ADD)) {
                jobSpec = (JobSpec)entry.getValue();
                this.postNewJobConfigArrival(jobSpec.getUri().toString(), jobSpec.getConfigAsProperties());
                this.jobSpecs.put(((Spec)entry.getValue()).getUri(), (JobSpec)entry.getValue());
                continue;
            }
            if (verb.equals((Object)SpecExecutor.Verb.UPDATE)) {
                jobSpec = (JobSpec)entry.getValue();
                this.postUpdateJobConfigArrival(jobSpec.getUri().toString(), jobSpec.getConfigAsProperties());
                this.jobSpecs.put(((Spec)entry.getValue()).getUri(), (JobSpec)entry.getValue());
                continue;
            }
            if (!verb.equals((Object)SpecExecutor.Verb.DELETE)) continue;
            Spec anonymousSpec = (Spec)entry.getValue();
            this.postDeleteJobConfigArrival(anonymousSpec.getUri().toString(), new Properties());
            this.jobSpecs.remove(((Spec)entry.getValue()).getUri());
        }
    }

    @Override
    protected void shutDown() throws Exception {
        ExecutorsUtils.shutdownExecutorService((ExecutorService)this.fetchJobSpecExecutor, (Optional)Optional.of((Object)LOGGER));
    }
}

