/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.gobblin.cluster.SingleTaskLauncher;
import org.apache.helix.task.Task;
import org.apache.helix.task.TaskResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleHelixTask
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(SingleHelixTask.class);
    private final String jobId;
    private final String jobName;
    private final Process taskProcess;

    SingleHelixTask(SingleTaskLauncher launcher, Map<String, String> configMap) throws IOException {
        this.jobName = configMap.get("job.name");
        this.jobId = configMap.get("job.id");
        Path workUnitFilePath = Paths.get(configMap.get("gobblin.cluster.work.unit.file.path"), new String[0]);
        logger.info(String.format("Launching a single task process. job name: %s. job id: %s", this.jobName, this.jobId));
        this.taskProcess = launcher.launch(this.jobId, workUnitFilePath);
    }

    public TaskResult run() {
        try {
            logger.info(String.format("Waiting for a single task process to finish. job name: %s. job id: %s", this.jobName, this.jobId));
            int exitCode = this.taskProcess.waitFor();
            if (exitCode == 0) {
                logger.info("Task process finished. job name: {}. job id: {}", (Object)this.jobName, (Object)this.jobId);
                return new TaskResult(TaskResult.Status.COMPLETED, "");
            }
            logger.warn("Task process failed with exitcode ({}). job name: {}. job id: {}", new Object[]{exitCode, this.jobName, this.jobId});
            return new TaskResult(TaskResult.Status.FATAL_FAILED, "Exit code: " + exitCode);
        }
        catch (Throwable t) {
            logger.error("SingleHelixTask failed due to " + t.getMessage(), t);
            return new TaskResult(TaskResult.Status.FAILED, Throwables.getStackTraceAsString((Throwable)t));
        }
    }

    public void cancel() {
        logger.info(String.format("Canceling a single task process. job name: %s. job id: %s", this.jobName, this.jobId));
        this.taskProcess.destroyForcibly();
    }
}

