/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.StrTokenizer;
import org.apache.gobblin.cluster.SingleTaskRunnerMain;
import org.apache.gobblin.util.GobblinProcessBuilder;
import org.apache.gobblin.util.SystemPropertiesWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleTaskLauncher {
    private static final Logger logger = LoggerFactory.getLogger(SingleTaskLauncher.class);
    private final GobblinProcessBuilder processBuilder;
    private final SystemPropertiesWrapper propertiesWrapper;
    private final Path clusterConfigFilePath;
    private final Config sysConfig;

    SingleTaskLauncher(GobblinProcessBuilder processBuilder, SystemPropertiesWrapper propertiesWrapper, Path clusterConfigFilePath, Config sysConfig) {
        this.processBuilder = processBuilder;
        this.propertiesWrapper = propertiesWrapper;
        this.clusterConfigFilePath = clusterConfigFilePath;
        this.sysConfig = sysConfig;
    }

    Process launch(String jobId, Path workUnitFilePath) throws IOException {
        CmdBuilder cmdBuilder = new CmdBuilder(jobId, workUnitFilePath);
        List<String> command = cmdBuilder.build();
        logger.info("Launching a task process.");
        String completeCmdLine = String.join((CharSequence)" ", command);
        logger.info("cmd line:\n{}", (Object)completeCmdLine);
        Process taskProcess = this.processBuilder.start(command);
        return taskProcess;
    }

    private class CmdBuilder {
        private final String jobId;
        private final Path workUnitFilePath;
        private final List<String> cmd = new ArrayList<String>();

        private CmdBuilder(String jobId, Path workUnitFilePath) {
            this.jobId = jobId;
            this.workUnitFilePath = workUnitFilePath;
        }

        List<String> build() {
            this.addJavaBin();
            this.addJavaOptions();
            this.addClassPath();
            this.addLogConfig();
            this.addClassName();
            this.addOptions();
            return this.cmd;
        }

        private void addJavaOptions() {
            if (SingleTaskLauncher.this.sysConfig.hasPath("gobblin.cluster.task.jvm.options")) {
                String taskJvmOptions = SingleTaskLauncher.this.sysConfig.getString("gobblin.cluster.task.jvm.options");
                StrTokenizer tokenizer = new StrTokenizer(taskJvmOptions, ' ', '\"');
                while (tokenizer.hasNext()) {
                    this.cmd.add(tokenizer.next());
                }
            }
        }

        private void addClassName() {
            String runnerClassName = SingleTaskRunnerMain.class.getCanonicalName();
            this.cmd.add(runnerClassName);
        }

        private void addJavaBin() {
            String javaHomeDir = SingleTaskLauncher.this.propertiesWrapper.getJavaHome();
            Path javaBinPath = Paths.get(javaHomeDir, "bin", "java");
            this.cmd.add(javaBinPath.toString());
        }

        private void addLogConfig() {
            if (SingleTaskLauncher.this.sysConfig.hasPath("gobblin.cluster.task.log.config")) {
                String logConfig = SingleTaskLauncher.this.sysConfig.getString("gobblin.cluster.task.log.config");
                this.cmd.add(logConfig);
            }
        }

        private void addClassPath() {
            this.cmd.add("-cp");
            String classPath = SingleTaskLauncher.this.sysConfig.hasPath("gobblin.cluster.task.classpath") ? SingleTaskLauncher.this.sysConfig.getString("gobblin.cluster.task.classpath") : SingleTaskLauncher.this.propertiesWrapper.getJavaClassPath();
            this.cmd.add(classPath);
        }

        private void addOptions() {
            this.addClusterConfigPath();
            this.addJobId();
            this.addWorkUnitPath();
        }

        private void addClusterConfigPath() {
            this.addOneOption("cluster_config_file_path", SingleTaskLauncher.this.clusterConfigFilePath.toString());
        }

        private void addWorkUnitPath() {
            this.addOneOption("work_unit_file_path", this.workUnitFilePath.toString());
        }

        private void addJobId() {
            this.addOneOption("job_id", this.jobId);
        }

        private void addOneOption(String key, String value) {
            this.cmd.add("--" + key);
            this.cmd.add(value);
        }
    }
}

