/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.gobblin.cluster.GobblinClusterException;
import org.apache.gobblin.cluster.SingleTaskRunnerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleTaskRunnerMainOptions {
    private static final Logger logger = LoggerFactory.getLogger(SingleTaskRunnerMainOptions.class);
    static final String CLUSTER_CONFIG_FILE_PATH = "cluster_config_file_path";
    static final String WORK_UNIT_FILE_PATH = "work_unit_file_path";
    static final String JOB_ID = "job_id";
    private static final ImmutableMap<String, String> OPTIONS_MAP = ImmutableMap.of((Object)"job_id", (Object)"job id", (Object)"work_unit_file_path", (Object)"work unit file path", (Object)"cluster_config_file_path", (Object)"cluster configuration file path");
    private static final int CHARACTERS_PER_LINE = 80;
    private final PrintWriter writer;
    private CommandLine cmd;
    private Options options;

    SingleTaskRunnerMainOptions(String[] args, PrintWriter writer) {
        this.writer = writer;
        this.initCmdLineOptions(args);
    }

    private void initCmdLineOptions(String[] args) {
        this.options = this.buildExpectedOptions();
        try {
            this.cmd = new DefaultParser().parse(this.options, args);
        }
        catch (ParseException e) {
            logger.error("failed to parse command options.", (Throwable)e);
            this.printUsage(this.options);
            throw new GobblinClusterException("Failed to parse command line options", e);
        }
    }

    private Options buildExpectedOptions() {
        Options options = new Options();
        for (Map.Entry entry : OPTIONS_MAP.entrySet()) {
            Option option = Option.builder(null).required(true).longOpt((String)entry.getKey()).desc((String)entry.getValue()).hasArg().build();
            options.addOption(option);
        }
        return options;
    }

    private void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(this.writer, 80, SingleTaskRunnerMain.class.getSimpleName(), options);
    }

    String getJobId() {
        return this.cmd.getOptionValue(JOB_ID);
    }

    String getWorkUnitFilePath() {
        return this.cmd.getOptionValue(WORK_UNIT_FILE_PATH);
    }

    String getClusterConfigFilePath() {
        return this.cmd.getOptionValue(CLUSTER_CONFIG_FILE_PATH);
    }
}

