/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.cluster;

import com.google.common.base.Optional;
import java.util.Iterator;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metastore.StateStore;
import org.apache.gobblin.runtime.GobblinMultiTaskAttempt;
import org.apache.gobblin.runtime.JobState;
import org.apache.gobblin.runtime.TaskExecutor;
import org.apache.gobblin.runtime.TaskState;
import org.apache.gobblin.runtime.TaskStateTracker;
import org.apache.gobblin.source.workunit.WorkUnit;

public class TaskAttemptBuilder {
    private final TaskStateTracker _taskStateTracker;
    private final TaskExecutor _taskExecutor;
    private String _containerId;
    private StateStore<TaskState> _taskStateStore;

    public TaskAttemptBuilder(TaskStateTracker taskStateTracker, TaskExecutor taskExecutor) {
        this._taskStateTracker = taskStateTracker;
        this._taskExecutor = taskExecutor;
    }

    public TaskAttemptBuilder setContainerId(String containerId) {
        this._containerId = containerId;
        return this;
    }

    public TaskAttemptBuilder setTaskStateStore(StateStore<TaskState> taskStateStore) {
        this._taskStateStore = taskStateStore;
        return this;
    }

    public GobblinMultiTaskAttempt build(Iterator<WorkUnit> workUnits, String jobId, JobState jobState, SharedResourcesBroker<GobblinScopeTypes> jobBroker) {
        GobblinMultiTaskAttempt attemptInstance = new GobblinMultiTaskAttempt(workUnits, jobId, jobState, this._taskStateTracker, this._taskExecutor, Optional.fromNullable((Object)this._containerId), Optional.fromNullable(this._taskStateStore), jobBroker);
        return attemptInstance;
    }
}

