/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.data.management.conversion.hive.watermarker;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.math.LongMath;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.math.RoundingMode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.gobblin.source.extractor.Watermark;

public class MultiKeyValueLongWatermark
implements Watermark {
    private static final Gson GSON = new Gson();
    private final Map<String, Long> watermarks;

    public MultiKeyValueLongWatermark() {
        this.watermarks = Maps.newConcurrentMap();
    }

    public MultiKeyValueLongWatermark(Map<String, Long> watermarks) {
        this.watermarks = watermarks == null ? Maps.newConcurrentMap() : new ConcurrentHashMap<String, Long>(watermarks);
    }

    public JsonElement toJson() {
        return GSON.toJsonTree((Object)this);
    }

    public short calculatePercentCompletion(Watermark lowWatermark, Watermark highWatermark) {
        Preconditions.checkArgument((lowWatermark instanceof MultiKeyValueLongWatermark && highWatermark instanceof MultiKeyValueLongWatermark ? 1 : 0) != 0, (Object)String.format("lowWatermark and highWatermark are not instances of %s", MultiKeyValueLongWatermark.class.getSimpleName()));
        MultiKeyValueLongWatermark low = (MultiKeyValueLongWatermark)lowWatermark;
        MultiKeyValueLongWatermark high = (MultiKeyValueLongWatermark)highWatermark;
        long total = 0L;
        long pulled = 0L;
        for (Map.Entry<String, Long> entry : low.watermarks.entrySet()) {
            if (!high.watermarks.containsKey(entry.getKey())) continue;
            total += high.watermarks.get(entry.getKey()) - entry.getValue();
        }
        for (Map.Entry<String, Long> entry : low.watermarks.entrySet()) {
            if (!this.watermarks.containsKey(entry.getKey())) continue;
            pulled += this.watermarks.get(entry.getKey()) - entry.getValue();
        }
        if (pulled > total) {
            return 100;
        }
        return (short)LongMath.divide((long)(pulled * 100L), (long)total, (RoundingMode)RoundingMode.CEILING);
    }

    Map<String, Long> getWatermarks() {
        return this.watermarks;
    }
}

